/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.executor;

import com.digiwin.jdbc.config.CalciteConfig;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.executor.BaseQueryExecutor;
import com.digiwin.jdbc.factory.DatabaseStrategyFactory;
import com.digiwin.jdbc.model.QueryResult;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.calcite.adapter.jdbc.JdbcSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteQueryExecutor
extends BaseQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(CalciteQueryExecutor.class);
    private CalciteConnection calciteConnection;
    private Map<String, BaseDatabaseStrategy> strategies = new HashMap<String, BaseDatabaseStrategy>();
    private CalciteConfig calciteConfig = new CalciteConfig();
    private boolean initialized = false;

    public CalciteQueryExecutor(Map<String, DatabaseConfig> dataSourceConfigs) {
        super(dataSourceConfigs);
    }

    private synchronized void initialize() throws Exception {
        if (this.initialized) {
            return;
        }
        try {
            Class.forName("org.apache.calcite.jdbc.Driver");
            Properties info = this.calciteConfig.buildConnectionProperties();
            Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
            this.calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = this.calciteConnection.getRootSchema();
            for (Map.Entry entry : this.dataSourceConfigs.entrySet()) {
                String dsName = (String)entry.getKey();
                DatabaseConfig dbConfig = (DatabaseConfig)entry.getValue();
                try {
                    BaseDatabaseStrategy strategy = DatabaseStrategyFactory.createStrategy(dbConfig);
                    this.strategies.put(dsName, strategy);
                    DataSource dataSource = strategy.buildCalciteDataSource();
                    SqlDialect sqlDialect = strategy.getSqlDialect();
                    SqlDialectFactory dialectFactory = databaseMetaData -> sqlDialect;
                    JdbcSchema jdbcSchema = JdbcSchema.create((SchemaPlus)rootSchema, (String)dsName, (DataSource)dataSource, (SqlDialectFactory)dialectFactory, null, null);
                    rootSchema.add(dsName, (Schema)jdbcSchema);
                    logger.info("\u6210\u529f\u6ce8\u518c\u6570\u636e\u6e90\u5230Calcite: {}", (Object)dsName);
                }
                catch (Exception e) {
                    logger.error("\u6ce8\u518c\u6570\u636e\u6e90 {} \u5230Calcite\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{dsName, e.getMessage(), e});
                    throw new Exception("Failed to register data source: " + dsName, e);
                }
            }
            this.initialized = true;
            logger.info("Calcite\u73af\u5883\u521d\u59cb\u5316\u6210\u529f\uff0c\u5171\u6ce8\u518c {} \u4e2a\u6570\u636e\u6e90", (Object)this.dataSourceConfigs.size());
        }
        catch (ClassNotFoundException e) {
            throw new Exception("\u627e\u4e0d\u5230Calcite\u9a71\u52a8\u7a0b\u5e8f: org.apache.calcite.jdbc.Driver", e);
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316Calcite\u73af\u5883\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("Failed to initialize Calcite environment: " + e.getMessage(), e);
        }
    }

    private CalciteConnection getCalciteConnection() throws Exception {
        if (!this.initialized || this.calciteConnection == null || this.calciteConnection.isClosed()) {
            this.initialize();
        }
        return this.calciteConnection;
    }

    @Override
    public QueryResult executeQuery(String sql) throws Exception {
        return this.executeQuery(sql, null);
    }

    @Override
    public QueryResult executeQuery(String sql, Map<String, Object> params) throws Exception {
        QueryResult queryResult;
        logger.debug("\u6267\u884cCalcite\u8054\u90a6\u67e5\u8be2: {}", (Object)sql);
        long startTime = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            CalciteConnection conn = this.getCalciteConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = this.buildQueryResult(rs, startTime);
            logger.debug("Calcite\u8054\u90a6\u67e5\u8be2\u6267\u884c\u6210\u529f, \u8017\u65f6: {} ms, \u8fd4\u56de {} \u6761\u8bb0\u5f55", (Object)result.getQueryTime(), (Object)result.getTotalCount());
            queryResult = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cCalcite\u8054\u90a6\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                throw new Exception("Failed to execute Calcite federated query: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(rs);
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(rs);
        this.closeResourceQuietly(stmt);
        return queryResult;
    }

    @Override
    public int executeUpdate(String sql) throws Exception {
        return this.executeUpdate(sql, null);
    }

    @Override
    public int executeUpdate(String sql, Map<String, Object> params) throws Exception {
        int n;
        logger.debug("\u6267\u884cCalcite\u8054\u90a6\u66f4\u65b0\u64cd\u4f5c: {}", (Object)sql);
        PreparedStatement stmt = null;
        try {
            CalciteConnection conn = this.getCalciteConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            int result = stmt.executeUpdate();
            logger.debug("Calcite\u8054\u90a6\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f, \u5f71\u54cd {} \u884c", (Object)result);
            n = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cCalcite\u8054\u90a6\u66f4\u65b0\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                throw new Exception("Failed to execute Calcite federated update: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(stmt);
        return n;
    }

    @Override
    public int[] executeBatch(List<String> sqlList) throws Exception {
        int[] nArray;
        logger.debug("\u6267\u884cCalcite\u8054\u90a6\u6279\u5904\u7406\u64cd\u4f5c, \u5171 {} \u6761SQL", (Object)sqlList.size());
        Statement stmt = null;
        try {
            CalciteConnection conn = this.getCalciteConnection();
            stmt = conn.createStatement();
            for (String sql : sqlList) {
                stmt.addBatch(sql);
            }
            int[] result = stmt.executeBatch();
            logger.debug("Calcite\u8054\u90a6\u6279\u5904\u7406\u64cd\u4f5c\u6267\u884c\u6210\u529f");
            nArray = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884cCalcite\u8054\u90a6\u6279\u5904\u7406\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                throw new Exception("Failed to execute Calcite federated batch: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(stmt);
        return nArray;
    }

    @Override
    public boolean testConnection() {
        logger.debug("\u6d4b\u8bd5Calcite\u8054\u90a6\u8fde\u63a5");
        try {
            CalciteConnection conn = this.getCalciteConnection();
            boolean result = conn != null && !conn.isClosed() && conn.isValid(5);
            logger.debug("Calcite\u8054\u90a6\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c: {}", (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            return result;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5Calcite\u8054\u90a6\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    @Override
    public boolean testConnection(String dataSourceName) {
        logger.debug("\u6d4b\u8bd5\u6570\u636e\u6e90\u8fde\u63a5 [\u6570\u636e\u6e90: {}]", (Object)dataSourceName);
        try {
            BaseDatabaseStrategy strategy;
            if (!this.initialized) {
                this.initialize();
            }
            if ((strategy = this.strategies.get(dataSourceName)) == null) {
                logger.warn("\u672a\u627e\u5230\u6570\u636e\u6e90: {}", (Object)dataSourceName);
                return false;
            }
            boolean result = strategy.testCalciteConnection();
            logger.debug("\u6570\u636e\u6e90\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c [\u6570\u636e\u6e90: {}]: {}", (Object)dataSourceName, (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            return result;
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u6570\u636e\u6e90\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{dataSourceName, e.getMessage(), e});
            return false;
        }
    }

    @Override
    public void close() {
        logger.debug("\u5173\u95edCalcite\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90");
        if (this.calciteConnection != null) {
            try {
                if (!this.calciteConnection.isClosed()) {
                    this.calciteConnection.close();
                }
            }
            catch (SQLException e) {
                logger.warn("\u5173\u95edCalcite\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
            this.calciteConnection = null;
        }
        for (Map.Entry<String, BaseDatabaseStrategy> entry : this.strategies.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u6570\u636e\u6e90 {} \u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{entry.getKey(), e.getMessage(), e});
            }
        }
        this.strategies.clear();
        this.initialized = false;
    }

    @Override
    public Connection getConnection(String dataSourceName) throws Exception {
        BaseDatabaseStrategy strategy;
        if (!this.initialized) {
            this.initialize();
        }
        if ((strategy = this.strategies.get(dataSourceName)) == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6570\u636e\u6e90: " + dataSourceName);
        }
        return strategy.buildCalciteDataSource().getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> getTableMeta(String dataSourceName, String tableName) throws Exception {
        ArrayList<Map<String, Object>> arrayList;
        logger.debug("\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f [\u6570\u636e\u6e90: {}]", (Object)tableName, (Object)dataSourceName);
        Connection conn = this.getConnection(dataSourceName);
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(null, null, tableName, null);
            ArrayList<Map<String, Object>> metaList = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                LinkedHashMap<String, Object> columnInfo = new LinkedHashMap<String, Object>();
                columnInfo.put("TABLE_NAME", rs.getString("TABLE_NAME"));
                columnInfo.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                columnInfo.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                columnInfo.put("COLUMN_SIZE", rs.getInt("COLUMN_SIZE"));
                columnInfo.put("DECIMAL_DIGITS", rs.getInt("DECIMAL_DIGITS"));
                columnInfo.put("NULLABLE", rs.getInt("NULLABLE"));
                columnInfo.put("REMARKS", rs.getString("REMARKS"));
                metaList.add(columnInfo);
            }
            logger.debug("\u6210\u529f\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f [\u6570\u636e\u6e90: {}], \u5171 {} \u5217", new Object[]{tableName, dataSourceName, metaList.size()});
            arrayList = metaList;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(conn);
            throw throwable;
        }
        this.closeResourceQuietly(rs);
        this.closeResourceQuietly(conn);
        return arrayList;
    }

    public QueryResult executeQueryWithTimeout(String sql, Map<String, Object> params, int timeout) throws Exception {
        QueryResult queryResult;
        logger.debug("\u6267\u884c\u5e26\u8d85\u65f6\u8bbe\u7f6e\u7684Calcite\u8054\u90a6\u67e5\u8be2: {}, \u8d85\u65f6\u65f6\u95f4: {}\u79d2", (Object)sql, (Object)timeout);
        if (timeout <= 0) {
            return this.executeQuery(sql, params);
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            CalciteConnection conn = this.getCalciteConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setQueryTimeout(timeout);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = this.buildQueryResult(rs, startTime);
            logger.debug("\u5e26\u8d85\u65f6\u8bbe\u7f6e\u7684Calcite\u8054\u90a6\u67e5\u8be2\u6267\u884c\u6210\u529f, \u8017\u65f6: {} ms", (Object)result.getQueryTime());
            queryResult = result;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884c\u5e26\u8d85\u65f6\u8bbe\u7f6e\u7684Calcite\u8054\u90a6\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
                throw new Exception("Failed to execute Calcite federated query with timeout: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.closeResourceQuietly(rs);
                this.closeResourceQuietly(stmt);
                throw throwable;
            }
        }
        this.closeResourceQuietly(rs);
        this.closeResourceQuietly(stmt);
        return queryResult;
    }

    public Set<String> getDataSourceNames() {
        return this.dataSourceConfigs.keySet();
    }

    public void refreshSchema() throws Exception {
        this.close();
        this.initialize();
    }
}

