/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.factory;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.executor.BaseQueryExecutor;
import com.digiwin.jdbc.executor.CalciteQueryExecutor;
import com.digiwin.jdbc.executor.JdbcQueryExecutor;
import com.digiwin.jdbc.model.QueryResult;
import com.digiwin.jdbc.model.QueryType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutorFactory.class);

    public static BaseQueryExecutor createExecutor(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs) {
        log.debug("\u521b\u5efa\u67e5\u8be2\u6267\u884c\u5668: {}", (Object)queryType);
        switch (queryType) {
            case JDBC_RAW: {
                return new JdbcQueryExecutor(dataSourceConfigs);
            }
            case CALCITE_FEDERATED: {
                return new CalciteQueryExecutor(dataSourceConfigs);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b: " + (Object)((Object)queryType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryResult executeQuery(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql) throws Exception {
        log.debug("\u6267\u884c{}\u67e5\u8be2: {}", (Object)queryType, (Object)sql);
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            QueryResult queryResult = executor.executeQuery(sql);
            return queryResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryResult executeQuery(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql, Map<String, Object> params) throws Exception {
        log.debug("\u6267\u884c{}\u67e5\u8be2: {}", (Object)queryType, (Object)sql);
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            QueryResult queryResult = executor.executeQuery(sql, params);
            return queryResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql) throws Exception {
        log.debug("\u6267\u884c{}\u66f4\u65b0\u64cd\u4f5c: {}", (Object)queryType, (Object)sql);
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            int n = executor.executeUpdate(sql);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql, Map<String, Object> params) throws Exception {
        log.debug("\u6267\u884c{}\u66f4\u65b0\u64cd\u4f5c: {}", (Object)queryType, (Object)sql);
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            int n = executor.executeUpdate(sql, params);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] executeBatch(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, List<String> sqlList) throws Exception {
        log.debug("\u6267\u884c{}\u6279\u5904\u7406\u64cd\u4f5c, \u5171 {} \u6761SQL", (Object)queryType, (Object)sqlList.size());
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            int[] nArray = executor.executeBatch(sqlList);
            return nArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testConnection(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs) {
        log.debug("\u6d4b\u8bd5{}\u6570\u636e\u5e93\u8fde\u63a5", (Object)queryType);
        try (BaseQueryExecutor executor = null;){
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            boolean bl = executor.testConnection();
            return bl;
        }
    }
}

