/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.strategy;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.model.DatabaseType;
import com.digiwin.jdbc.model.QueryResult;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.calcite.sql.SqlDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDatabaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(BaseDatabaseStrategy.class);
    protected static final Logger logger = LoggerFactory.getLogger(BaseDatabaseStrategy.class);
    protected DatabaseConfig config;
    protected HikariDataSource jdbcDataSource;
    protected HikariDataSource calciteDataSource;
    protected Connection jdbcConnection;

    public BaseDatabaseStrategy(DatabaseConfig config) {
        this.config = config;
    }

    public abstract DatabaseType getDatabaseType();

    public abstract String buildJdbcUrl();

    public String buildCalciteUrl() {
        return this.buildJdbcUrl();
    }

    public SqlDialect getSqlDialect() {
        return this.getDatabaseType().getSqlDialect();
    }

    public Connection buildJdbcConnection() throws Exception {
        try {
            if (this.jdbcDataSource == null) {
                this.initializeJdbcDataSource();
            }
            if (this.jdbcConnection == null || this.jdbcConnection.isClosed()) {
                this.jdbcConnection = this.jdbcDataSource.getConnection();
                this.applyConnectionProperties(this.jdbcConnection);
            }
            return this.jdbcConnection;
        }
        catch (SQLException e) {
            logger.error("\u6784\u5efaJDBC\u8fde\u63a5\u65f6\u53d1\u751fSQL\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("Failed to build JDBC connection: " + e.getMessage(), e);
        }
    }

    public DataSource buildCalciteDataSource() throws Exception {
        try {
            if (this.calciteDataSource == null) {
                this.initializeCalciteDataSource();
            }
            return this.calciteDataSource;
        }
        catch (Exception e) {
            logger.error("\u6784\u5efaCalcite\u6570\u636e\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            throw new Exception("Failed to build Calcite data source: " + e.getMessage(), e);
        }
    }

    protected synchronized void initializeJdbcDataSource() throws Exception {
        if (this.jdbcDataSource != null) {
            return;
        }
        try {
            Class.forName(this.getDatabaseType().getDriverClass());
        }
        catch (ClassNotFoundException e) {
            throw new Exception("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f: " + this.getDatabaseType().getDriverClass(), e);
        }
        String jdbcUrl = this.buildJdbcUrl();
        logger.info("\u6b63\u5728\u521d\u59cb\u5316JDBC\u6570\u636e\u6e90...");
        logger.info("\u6570\u636e\u5e93\u7c7b\u578b: {}", (Object)this.getDatabaseType());
        logger.info("\u8fde\u63a5\u5730\u5740: {}:{}", (Object)this.config.getHost(), (Object)this.config.getPort());
        logger.info("\u6570\u636e\u5e93\u540d: {}", (Object)this.config.getDatabase());
        logger.info("\u7528\u6237\u540d: {}", (Object)this.config.getUsername());
        logger.info("JDBC URL: {}", (Object)jdbcUrl);
        try {
            HikariConfig hikariConfig = this.createHikariConfig(jdbcUrl, "JDBC");
            this.jdbcDataSource = new HikariDataSource(hikariConfig);
            logger.info("\u6210\u529f\u521d\u59cb\u5316JDBC\u6570\u636e\u6e90: {} ({}:{})", new Object[]{this.getDatabaseType(), this.config.getHost(), this.config.getPort()});
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316JDBC\u6570\u636e\u6e90\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            String errorMsg = this.buildConnectionErrorMessage(e);
            throw new Exception(errorMsg, e);
        }
    }

    protected synchronized void initializeCalciteDataSource() throws Exception {
        if (this.calciteDataSource != null) {
            return;
        }
        try {
            Class.forName(this.getDatabaseType().getDriverClass());
        }
        catch (ClassNotFoundException e) {
            throw new Exception("\u627e\u4e0d\u5230\u6570\u636e\u5e93\u9a71\u52a8\u7a0b\u5e8f: " + this.getDatabaseType().getDriverClass(), e);
        }
        String calciteUrl = this.buildCalciteUrl();
        logger.info("\u6b63\u5728\u521d\u59cb\u5316Calcite\u6570\u636e\u6e90...");
        logger.info("\u6570\u636e\u5e93\u7c7b\u578b: {}", (Object)this.getDatabaseType());
        logger.info("\u8fde\u63a5\u5730\u5740: {}:{}", (Object)this.config.getHost(), (Object)this.config.getPort());
        logger.info("\u6570\u636e\u5e93\u540d: {}", (Object)this.config.getDatabase());
        logger.info("Calcite URL: {}", (Object)calciteUrl);
        try {
            HikariConfig hikariConfig = this.createHikariConfig(calciteUrl, "Calcite");
            this.calciteDataSource = new HikariDataSource(hikariConfig);
            logger.info("\u6210\u529f\u521d\u59cb\u5316Calcite\u6570\u636e\u6e90: {} ({}:{})", new Object[]{this.getDatabaseType(), this.config.getHost(), this.config.getPort()});
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316Calcite\u6570\u636e\u6e90\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            String errorMsg = this.buildConnectionErrorMessage(e);
            throw new Exception(errorMsg, e);
        }
    }

    protected HikariConfig createHikariConfig(String jdbcUrl, String poolType) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(jdbcUrl);
        hikariConfig.setUsername(this.config.getUsername());
        hikariConfig.setPassword(this.config.getPassword());
        int maxPoolSize = Math.max(1, this.config.getMaxConnections());
        hikariConfig.setMaximumPoolSize(maxPoolSize);
        hikariConfig.setPoolName(this.getDatabaseType().name() + "_" + poolType + "_Pool");
        hikariConfig.setConnectionTimeout(30000L);
        hikariConfig.setIdleTimeout(600000L);
        hikariConfig.setMaxLifetime(1800000L);
        hikariConfig.setMinimumIdle(1);
        if (this.config.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                hikariConfig.addDataSourceProperty(entry.getKey(), (Object)entry.getValue());
            }
        }
        return hikariConfig;
    }

    protected void applyConnectionProperties(Connection connection) {
        if (this.config.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                try {
                    connection.setClientInfo(entry.getKey(), entry.getValue());
                }
                catch (SQLException e) {
                    logger.debug("\u8bbe\u7f6e\u8fde\u63a5\u5c5e\u6027\u5931\u8d25: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult executeJdbcQuery(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cJDBC\u67e5\u8be2: {}", (Object)sql);
        Connection conn = this.buildJdbcConnection();
        long startTime = System.currentTimeMillis();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = new QueryResult();
            result.setColumns(this.extractColumnNames(rs));
            result.setData(this.extractResultSetData(rs));
            result.setQueryTime(System.currentTimeMillis() - startTime);
            result.setSuccess(true);
            result.setMessage("Success");
            logger.debug("JDBC\u67e5\u8be2\u6267\u884c\u6210\u529f\uff0c\u8017\u65f6: {} ms", (Object)result.getQueryTime());
            QueryResult queryResult = result;
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            return queryResult;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult executeCalciteQuery(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cCalcite\u67e5\u8be2: {}", (Object)sql);
        DataSource dataSource = this.buildCalciteDataSource();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = dataSource.getConnection();
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            rs = stmt.executeQuery();
            QueryResult result = new QueryResult();
            result.setColumns(this.extractColumnNames(rs));
            result.setData(this.extractResultSetData(rs));
            result.setQueryTime(System.currentTimeMillis() - startTime);
            result.setSuccess(true);
            result.setMessage("Success");
            logger.debug("Calcite\u67e5\u8be2\u6267\u884c\u6210\u529f\uff0c\u8017\u65f6: {} ms", (Object)result.getQueryTime());
            QueryResult queryResult = result;
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            return queryResult;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            this.closeResourceQuietly(stmt);
            this.closeResourceQuietly(conn);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeJdbcUpdate(String sql, Map<String, Object> params) throws Exception {
        logger.debug("\u6267\u884cJDBC\u66f4\u65b0\u64cd\u4f5c: {}", (Object)sql);
        Connection conn = this.buildJdbcConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            this.setStatementParameters(stmt, params);
            int result = stmt.executeUpdate();
            logger.debug("JDBC\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd {} \u884c", (Object)result);
            int n = result;
            return n;
        }
        finally {
            this.closeResourceQuietly(stmt);
        }
    }

    public boolean testJdbcConnection() {
        logger.debug("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5");
        try {
            Connection conn = this.buildJdbcConnection();
            return conn != null && !conn.isClosed() && conn.isValid(5);
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5JDBC\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean testCalciteConnection() {
        logger.debug("\u6d4b\u8bd5Calcite\u6570\u636e\u5e93\u8fde\u63a5");
        try {
            DataSource dataSource = this.buildCalciteDataSource();
            try (Connection conn = dataSource.getConnection();){
                boolean bl = conn != null && !conn.isClosed() && conn.isValid(5);
                return bl;
            }
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5Calcite\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getTableMeta(String tableName) throws Exception {
        logger.debug("\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f", (Object)tableName);
        Connection conn = this.buildJdbcConnection();
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            rs = metaData.getColumns(null, null, tableName, null);
            ArrayList<Map<String, Object>> metaList = new ArrayList<Map<String, Object>>();
            while (rs.next()) {
                LinkedHashMap<String, Object> columnInfo = new LinkedHashMap<String, Object>();
                columnInfo.put("TABLE_NAME", rs.getString("TABLE_NAME"));
                columnInfo.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                columnInfo.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                columnInfo.put("COLUMN_SIZE", rs.getInt("COLUMN_SIZE"));
                columnInfo.put("DECIMAL_DIGITS", rs.getInt("DECIMAL_DIGITS"));
                columnInfo.put("NULLABLE", rs.getInt("NULLABLE"));
                columnInfo.put("REMARKS", rs.getString("REMARKS"));
                metaList.add(columnInfo);
            }
            logger.debug("\u6210\u529f\u83b7\u53d6\u8868 {} \u7684\u5143\u6570\u636e\u4fe1\u606f\uff0c\u5171 {} \u5217", (Object)tableName, (Object)metaList.size());
            ArrayList<Map<String, Object>> arrayList = metaList;
            this.closeResourceQuietly(rs);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.closeResourceQuietly(rs);
            throw throwable;
        }
    }

    public void close() {
        logger.debug("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90");
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.isClosed()) {
                    this.jdbcConnection.close();
                }
            }
            catch (SQLException e) {
                logger.warn("\u5173\u95edJDBC\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
            this.jdbcConnection = null;
        }
        if (this.jdbcDataSource != null) {
            try {
                this.jdbcDataSource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95edJDBC\u6570\u636e\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
            this.jdbcDataSource = null;
        }
        if (this.calciteDataSource != null) {
            try {
                this.calciteDataSource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95edCalcite\u6570\u636e\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
            this.calciteDataSource = null;
        }
    }

    public DatabaseConfig getConfig() {
        return this.config;
    }

    protected void setStatementParameters(PreparedStatement stmt, Map<String, Object> params) throws SQLException {
        if (params == null || params.isEmpty()) {
            return;
        }
        int index = 1;
        for (Object value : params.values()) {
            stmt.setObject(index++, value);
        }
    }

    protected List<String> extractColumnNames(ResultSet rs) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        int columnCount = rs.getMetaData().getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            columnNames.add(rs.getMetaData().getColumnLabel(i));
        }
        return columnNames;
    }

    protected List<Map<String, Object>> extractResultSetData(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            int columnCount = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rs.getMetaData().getColumnLabel(i);
                Object value = rs.getObject(i);
                row.put(columnName, value);
            }
            dataList.add(row);
        }
        return dataList;
    }

    protected void closeResourceQuietly(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    protected String buildUrlParameters() {
        if (this.config.getProperties() == null || this.config.getProperties().isEmpty()) {
            return "";
        }
        StringBuilder params = new StringBuilder("?");
        for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
            params.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        return params.substring(0, params.length() - 1);
    }

    private String buildConnectionErrorMessage(Exception e) {
        StringBuilder msg = new StringBuilder();
        msg.append("\u65e0\u6cd5\u8fde\u63a5\u5230\u6570\u636e\u5e93\u670d\u52a1\u5668\n");
        msg.append("\u6570\u636e\u5e93\u7c7b\u578b: ").append((Object)this.getDatabaseType()).append("\n");
        msg.append("\u8fde\u63a5\u5730\u5740: ").append(this.config.getHost()).append(":").append(this.config.getPort()).append("\n");
        msg.append("\u6570\u636e\u5e93\u540d: ").append(this.config.getDatabase()).append("\n");
        msg.append("\n\u53ef\u80fd\u7684\u539f\u56e0:\n");
        String exMsg = e.getMessage();
        if (exMsg != null && exMsg.contains("Connection refused")) {
            msg.append("1. \u6570\u636e\u5e93\u670d\u52a1\u5668\u672a\u542f\u52a8\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u670d\u52a1\u662f\u5426\u6b63\u5728\u8fd0\u884c\n");
            msg.append("2. \u6570\u636e\u5e93\u672a\u76d1\u542c\u5728\u6307\u5b9a\u7684\u7aef\u53e3 ").append(this.config.getPort()).append("\n");
            msg.append("3. \u9632\u706b\u5899\u963b\u6b62\u4e86\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u9632\u706b\u5899\u8bbe\u7f6e\n");
            msg.append("4. \u4e3b\u673a\u5730\u5740 '").append(this.config.getHost()).append("' \u914d\u7f6e\u9519\u8bef\n");
        } else if (exMsg != null && exMsg.contains("timeout")) {
            msg.append("1. \u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\n");
            msg.append("2. \u6570\u636e\u5e93\u670d\u52a1\u5668\u54cd\u5e94\u7f13\u6162\n");
            msg.append("3. \u9632\u706b\u5899\u53ef\u80fd\u963b\u6b62\u4e86\u8fde\u63a5\n");
        } else if (exMsg != null && exMsg.contains("Access denied")) {
            msg.append("1. \u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\n");
            msg.append("2. \u7528\u6237\u6ca1\u6709\u8bbf\u95ee\u8be5\u6570\u636e\u5e93\u7684\u6743\u9650\n");
        } else if (exMsg != null && exMsg.contains("Unknown database")) {
            msg.append("1. \u6570\u636e\u5e93 '").append(this.config.getDatabase()).append("' \u4e0d\u5b58\u5728\n");
            msg.append("2. \u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u540d\u79f0\u662f\u5426\u6b63\u786e\n");
        } else {
            msg.append("1. \u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u670d\u52a1\u5668\u662f\u5426\u6b63\u5728\u8fd0\u884c\n");
            msg.append("2. \u8bf7\u68c0\u67e5\u4e3b\u673a\u5730\u5740\u548c\u7aef\u53e3\u53f7\u662f\u5426\u6b63\u786e\n");
            msg.append("3. \u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38\n");
            msg.append("4. \u8bf7\u68c0\u67e5\u7528\u6237\u540d\u548c\u5bc6\u7801\u662f\u5426\u6b63\u786e\n");
        }
        msg.append("\n\u539f\u59cb\u9519\u8bef\u4fe1\u606f: ").append(exMsg);
        return msg.toString();
    }
}

