/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.strategy.databaseStrategy;

import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.model.DatabaseType;
import com.digiwin.jdbc.strategy.BaseDatabaseStrategy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLServerStrategy
extends BaseDatabaseStrategy {
    private static final Logger log = LoggerFactory.getLogger(SQLServerStrategy.class);

    public SQLServerStrategy(DatabaseConfig config) {
        super(config);
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.SQLSERVER;
    }

    @Override
    public String buildJdbcUrl() {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:sqlserver://").append(this.config.getHost()).append(":").append(this.config.getPort()).append(";databaseName=").append(this.config.getDatabase());
        String params = this.buildUrlParams(";");
        if (!params.isEmpty()) {
            url.append(";").append(params);
        }
        return url.toString();
    }

    @Override
    public String buildCalciteUrl() {
        return this.buildJdbcUrl();
    }

    private String buildUrlParams(String separator) {
        StringBuilder params = new StringBuilder();
        if (this.config.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.config.getProperties().entrySet()) {
                params.append(entry.getKey()).append("=").append(entry.getValue()).append(separator);
            }
        }
        if (params.length() > 0 && params.charAt(params.length() - 1) == separator.charAt(0)) {
            params.deleteCharAt(params.length() - 1);
        }
        return params.toString();
    }
}

