/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.model;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryResult {
    private boolean success = true;
    private String message = "Success";
    private List<String> columns;
    private List<Map<String, Object>> data;
    private int totalCount;
    private long queryTime;

    public QueryResult(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public void setData(List<Map<String, Object>> data) {
        this.data = data;
        if (data != null) {
            this.totalCount = data.size();
        }
    }

    public Map<String, Object> getRow(int rowIndex) {
        if (this.data != null && rowIndex >= 0 && rowIndex < this.data.size()) {
            return this.data.get(rowIndex);
        }
        return null;
    }

    public Object getValue(int rowIndex, String columnName) {
        Map<String, Object> row = this.getRow(rowIndex);
        if (row != null) {
            return row.get(columnName);
        }
        return null;
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public Map<String, Object> getFirstRow() {
        return this.getRow(0);
    }

    public List<Object> getColumnValues(String columnName) {
        if (this.data != null) {
            return this.data.stream().map(row -> row.get(columnName)).collect(Collectors.toList());
        }
        return null;
    }

    public static QueryResultBuilder builder() {
        return new QueryResultBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryResult)) {
            return false;
        }
        QueryResult other = (QueryResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        if (this.getQueryTime() != other.getQueryTime()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<Map<String, Object>> this$data = this.getData();
        List<Map<String, Object>> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + this.getTotalCount();
        long $queryTime = this.getQueryTime();
        result = result * 59 + (int)($queryTime >>> 32 ^ $queryTime);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<Map<String, Object>> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "QueryResult(success=" + this.isSuccess() + ", message=" + this.getMessage() + ", columns=" + this.getColumns() + ", data=" + this.getData() + ", totalCount=" + this.getTotalCount() + ", queryTime=" + this.getQueryTime() + ")";
    }

    public QueryResult() {
    }

    public QueryResult(boolean success, String message, List<String> columns, List<Map<String, Object>> data, int totalCount, long queryTime) {
        this.success = success;
        this.message = message;
        this.columns = columns;
        this.data = data;
        this.totalCount = totalCount;
        this.queryTime = queryTime;
    }

    public static class QueryResultBuilder {
        private boolean success;
        private String message;
        private List<String> columns;
        private List<Map<String, Object>> data;
        private int totalCount;
        private long queryTime;

        QueryResultBuilder() {
        }

        public QueryResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public QueryResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        public QueryResultBuilder columns(List<String> columns) {
            this.columns = columns;
            return this;
        }

        public QueryResultBuilder data(List<Map<String, Object>> data) {
            this.data = data;
            return this;
        }

        public QueryResultBuilder totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public QueryResultBuilder queryTime(long queryTime) {
            this.queryTime = queryTime;
            return this;
        }

        public QueryResult build() {
            return new QueryResult(this.success, this.message, this.columns, this.data, this.totalCount, this.queryTime);
        }

        public String toString() {
            return "QueryResult.QueryResultBuilder(success=" + this.success + ", message=" + this.message + ", columns=" + this.columns + ", data=" + this.data + ", totalCount=" + this.totalCount + ", queryTime=" + this.queryTime + ")";
        }
    }
}

