/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.factory.jdbc;

import com.digiwin.commons.entity.enums.jdbc.QueryType;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.executor.BaseQueryExecutor;
import com.digiwin.jdbc.executor.CalciteQueryExecutor;
import com.digiwin.jdbc.executor.JdbcQueryExecutor;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(QueryExecutorFactory.class);

    public static BaseQueryExecutor createExecutor(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs) {
        log.debug("\u521b\u5efa\u67e5\u8be2\u6267\u884c\u5668: {}", (Object)queryType);
        switch (queryType) {
            case JDBC_RAW: {
                return new JdbcQueryExecutor(dataSourceConfigs);
            }
            case CALCITE_FEDERATED: {
                return new CalciteQueryExecutor(dataSourceConfigs);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u67e5\u8be2\u7c7b\u578b: " + (Object)((Object)queryType));
    }
}

