/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc;

import com.digiwin.commons.entity.enums.jdbc.DatabaseType;
import com.digiwin.commons.entity.enums.jdbc.QueryType;
import com.digiwin.commons.entity.model.QueryResult;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.service.MultiDbQueryService;
import com.digiwin.jdbc.service.impl.MultiDbQueryServiceImpl;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDbUsageExample {
    private static final Logger log = LoggerFactory.getLogger(MultiDbUsageExample.class);
    private static final Logger logger = LoggerFactory.getLogger(MultiDbUsageExample.class);
    private static final MultiDbQueryService multiDbQueryService = new MultiDbQueryServiceImpl();

    public static void main(String[] args) {
        try {
            HashMap<String, DatabaseConfig> calciteDataSources = new HashMap<String, DatabaseConfig>();
            QueryResult starrocksResult = MultiDbUsageExample.queryStarrocksResult(calciteDataSources);
            MultiDbUsageExample.logQueryResult("StarRocks\u67e5\u8be2", starrocksResult);
            DatabaseConfig mysqlConfig2 = new DatabaseConfig();
            mysqlConfig2.setType(DatabaseType.MYSQL);
            mysqlConfig2.setHost("172.16.101.227");
            mysqlConfig2.setPort(3306);
            mysqlConfig2.setDatabase("dolphinscheduler");
            mysqlConfig2.setUsername("root");
            mysqlConfig2.setPassword("DiGiWin@123");
            calciteDataSources.put("mysql_ds", mysqlConfig2);
            String calciteSingleSql = "SELECT * FROM mysql_ds.t_ds_code_assignment LIMIT 5";
            QueryResult calciteSingleResult = multiDbQueryService.executeQuery(QueryType.CALCITE_FEDERATED, calciteDataSources, calciteSingleSql);
            MultiDbUsageExample.logQueryResult("Calcite\u5355\u6570\u636e\u5e93\u67e5\u8be2", calciteSingleResult);
            DatabaseConfig oracleConfig = new DatabaseConfig();
            oracleConfig.setType(DatabaseType.ORACLE);
            oracleConfig.setHost("192.168.83.211");
            oracleConfig.setPort(1521);
            oracleConfig.setDatabase("dsdata");
            oracleConfig.setUsername("dsdata");
            oracleConfig.setPassword("Digiwin99");
            calciteDataSources.put("oracle_ds", oracleConfig);
            String federatedSql2 = "SELECT m.*, o.* FROM mysql_ds.t_ds_code_assignment m JOIN oracle_ds.T_DS_CODE_ASSIGNMENT_VERSION o ON m.id = o.CODE_ASSIGNMENT_ID WHERE m.state = 1";
            QueryResult federatedResult = multiDbQueryService.executeQuery(QueryType.CALCITE_FEDERATED, calciteDataSources, federatedSql2);
            MultiDbUsageExample.logQueryResult("Calcite\u8054\u90a6\u67e5\u8be2", federatedResult);
            MultiDbUsageExample.createTableExample(calciteDataSources);
            MultiDbUsageExample.alterTableExample(calciteDataSources);
            MultiDbUsageExample.dropTableExample(calciteDataSources);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static QueryResult queryStarrocksResult(Map<String, DatabaseConfig> calciteDataSources) {
        try {
            String sql1 = "SELECT * FROM `catalog_join`.`Cubedemo2_SalesDetails` WHERE `Year` = 2022";
            DatabaseConfig starRocksConfig = new DatabaseConfig();
            starRocksConfig.setType(DatabaseType.STARROCKS);
            starRocksConfig.setHost("172.16.101.227");
            starRocksConfig.setPort(19030);
            starRocksConfig.setDatabase("catalog_join");
            starRocksConfig.setUsername("dmp");
            starRocksConfig.setPassword("DiGiWin@dSr312");
            calciteDataSources.put("default", starRocksConfig);
            QueryResult starrocksResult = multiDbQueryService.executeQuery(QueryType.JDBC_RAW, calciteDataSources, sql1);
            return starrocksResult;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2StarRocks\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static void createTableExample(Map<String, DatabaseConfig> dataSources) {
        try {
            String createTableSql = "CREATE TABLE IF NOT EXISTS `test_table` (`id` INT AUTO_INCREMENT PRIMARY KEY, `name` VARCHAR(100) NOT NULL, `age` INT, `created_time` TIMESTAMP DEFAULT CURRENT_TIMESTAMP)";
            DatabaseConfig mysqlConfig = dataSources.get("default");
            if (mysqlConfig != null && mysqlConfig.getType() == DatabaseType.MYSQL) {
                HashMap<String, DatabaseConfig> mysqlDataSource = new HashMap<String, DatabaseConfig>();
                mysqlDataSource.put("default", mysqlConfig);
                MultiDbUsageExample.executeUpdate(mysqlDataSource, createTableSql);
            }
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8868\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void alterTableExample(Map<String, DatabaseConfig> dataSources) {
        try {
            String alterTableSql = "ALTER TABLE `test_table` ADD COLUMN `email` VARCHAR(100)";
            DatabaseConfig mysqlConfig = dataSources.get("default");
            if (mysqlConfig != null && mysqlConfig.getType() == DatabaseType.MYSQL) {
                HashMap<String, DatabaseConfig> mysqlDataSource = new HashMap<String, DatabaseConfig>();
                mysqlDataSource.put("default", mysqlConfig);
                MultiDbUsageExample.executeUpdate(mysqlDataSource, alterTableSql);
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u8868\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void dropTableExample(Map<String, DatabaseConfig> dataSources) {
        try {
            String dropTableSql = "DROP TABLE IF EXISTS `test_table`";
            DatabaseConfig mysqlConfig = dataSources.get("default");
            if (mysqlConfig != null && mysqlConfig.getType() == DatabaseType.MYSQL) {
                HashMap<String, DatabaseConfig> mysqlDataSource = new HashMap<String, DatabaseConfig>();
                mysqlDataSource.put("default", mysqlConfig);
                MultiDbUsageExample.executeUpdate(mysqlDataSource, dropTableSql);
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u8868\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void executeUpdate(Map<String, DatabaseConfig> dataSources, String sql) {
        try {
            int result = multiDbQueryService.executeUpdate(QueryType.JDBC_RAW, dataSources, sql);
            log.info("\u6267\u884cSQL\u6210\u529f: {}\uff0c\u5f71\u54cd\u884c\u6570: {}", (Object)sql, (Object)result);
        }
        catch (Exception e) {
            log.error("\u6267\u884cSQL\u5931\u8d25: {}, \u9519\u8bef: {}", (Object)sql, (Object)e.getMessage());
        }
    }

    private static void logQueryResult(String queryType, QueryResult result) {
        if (result.isSuccess()) {
            log.info(queryType + "\u6210\u529f\uff0c\u8fd4\u56de {} \u6761\u8bb0\u5f55", (Object)result.getTotalCount());
            if (result.getData() != null && !result.getData().isEmpty()) {
                log.info("\u5217\u540d: {}", result.getColumns());
                log.info("\u6570\u636e\u793a\u4f8b\uff08\u524d3\u6761\uff09:");
                result.getData().stream().limit(3L).forEach(row -> log.info("  {}", row));
            }
        } else {
            log.error(queryType + "\u5931\u8d25: {}", (Object)result.getMessage());
        }
    }
}

