/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.config;

import com.digiwin.commons.entity.enums.jdbc.DatabaseType;
import com.digiwin.jdbc.config.DatabaseConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CalciteConfig
extends DatabaseConfig {
    private Map<String, DatabaseConfig> dataSources = new HashMap<String, DatabaseConfig>();
    private Map<String, String> schemaDefinitions = new HashMap<String, String>();
    private String defaultSchema;
    private boolean enableCache = true;
    private int cacheSize = 1000;
    private boolean enableValidation = true;
    private boolean enableMaterialization = false;
    private boolean enableStreaming = false;
    private String timeZone = "UTC";
    private String locale = "en_US";
    private List<String> udfJars = new ArrayList<String>();
    private Map<String, Object> optimizerRules = new HashMap<String, Object>();
    private Map<String, String> modelProperties = new HashMap<String, String>();

    public CalciteConfig() {
        this.setType(DatabaseType.CALCITE);
        this.initDefaultProperties();
    }

    private void initDefaultProperties() {
        this.addProperty("lex", "JAVA");
        this.addProperty("caseSensitive", "false");
        this.addProperty("unquotedCasing", "UNCHANGED");
        this.addProperty("quoting", "DOUBLE_QUOTE");
        this.addProperty("conformance", "LENIENT");
        this.modelProperties.put("type", "custom");
        this.modelProperties.put("name", "MultiDBModel");
        this.modelProperties.put("defaultSchema", "ROOT");
        this.addProperty("model", "inline:{\"version\": \"1.0\", \"defaultSchema\": \"ROOT\", \"schemas\": []}");
    }

    public void addDataSource(String name, DatabaseConfig config) {
        this.dataSources.put(name, config);
    }

    public void addDataSource(String name, DatabaseType type, String host, int port, String database, String username, String password) {
        DatabaseConfig config = new DatabaseConfig();
        config.setType(type);
        config.setHost(host);
        config.setPort(port);
        config.setDatabase(database);
        config.setUsername(username);
        config.setPassword(password);
        this.dataSources.put(name, config);
    }

    public void removeDataSource(String name) {
        this.dataSources.remove(name);
    }

    public void defineSchema(String schemaName, String definition) {
        this.schemaDefinitions.put(schemaName, definition);
    }

    public void addUdfJar(String jarPath) {
        this.udfJars.add(jarPath);
    }

    public void enableCacheRule() {
        this.optimizerRules.put("CacheEnabled", true);
        this.optimizerRules.put("CacheMaxSize", this.cacheSize);
        this.optimizerRules.put("CacheExpireAfterAccess", 3600000);
    }

    public void enablePushDown() {
        this.optimizerRules.put("PushProjection", true);
        this.optimizerRules.put("PushFilter", true);
        this.optimizerRules.put("PushAggregate", true);
        this.optimizerRules.put("PushSort", true);
    }

    public void setMaterializationConfig(String viewName, String sql, boolean automaticRefresh) {
        HashMap<String, Object> mvConfig = new HashMap<String, Object>();
        mvConfig.put("sql", sql);
        mvConfig.put("automaticRefresh", automaticRefresh);
        mvConfig.put("refreshInterval", 300000);
        this.optimizerRules.put("MaterializedView_" + viewName, mvConfig);
    }

    public String buildModelJson() {
        StringBuilder json = new StringBuilder();
        json.append("{\n");
        json.append("  \"version\": \"1.0\",\n");
        json.append("  \"defaultSchema\": \"").append(this.defaultSchema != null ? this.defaultSchema : "ROOT").append("\",\n");
        json.append("  \"schemas\": [\n");
        int schemaCount = 0;
        for (Map.Entry<String, String> entry : this.schemaDefinitions.entrySet()) {
            if (schemaCount > 0) {
                json.append(",\n");
            }
            json.append("    {\n");
            json.append("      \"name\": \"").append(entry.getKey()).append("\",\n");
            json.append("      \"custom\": \"").append(entry.getValue()).append("\"\n");
            json.append("    }");
            ++schemaCount;
        }
        for (Map.Entry<String, Object> entry : this.dataSources.entrySet()) {
            if (schemaCount > 0) {
                json.append(",\n");
            }
            json.append("    {\n");
            json.append("      \"name\": \"").append(entry.getKey()).append("\",\n");
            json.append("      \"type\": \"jdbc\",\n");
            json.append("      \"jdbcDriver\": \"").append(((DatabaseConfig)entry.getValue()).getType().getDriverClass()).append("\",\n");
            json.append("      \"jdbcUrl\": \"").append(this.buildJdbcUrl((DatabaseConfig)entry.getValue())).append("\",\n");
            json.append("      \"jdbcUser\": \"").append(((DatabaseConfig)entry.getValue()).getUsername()).append("\",\n");
            json.append("      \"jdbcPassword\": \"").append(((DatabaseConfig)entry.getValue()).getPassword()).append("\",\n");
            json.append("      \"jdbcSchema\": \"").append(((DatabaseConfig)entry.getValue()).getDatabase()).append("\"\n");
            json.append("    }");
            ++schemaCount;
        }
        json.append("\n  ]");
        if (!this.optimizerRules.isEmpty()) {
            json.append(",\n  \"optimizer\": {\n");
            json.append("    \"rules\": {\n");
            int ruleCount = 0;
            for (Map.Entry<String, Object> entry : this.optimizerRules.entrySet()) {
                if (ruleCount > 0) {
                    json.append(",\n");
                }
                json.append("      \"").append(entry.getKey()).append("\": ");
                if (entry.getValue() instanceof Boolean || entry.getValue() instanceof Number) {
                    json.append(entry.getValue());
                } else {
                    json.append("\"").append(entry.getValue()).append("\"");
                }
                ++ruleCount;
            }
            json.append("\n    }\n  }");
        }
        json.append("\n}");
        return json.toString();
    }

    private String buildJdbcUrl(DatabaseConfig config) {
        StringBuilder url = new StringBuilder();
        switch (config.getType()) {
            case MYSQL: 
            case STARROCKS: {
                url.append("jdbc:mysql://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDatabase());
                break;
            }
            case ORACLE: {
                url.append("jdbc:oracle:thin:@//").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDatabase());
                break;
            }
            case SQLSERVER: {
                url.append("jdbc:sqlserver://").append(config.getHost()).append(":").append(config.getPort()).append(";databaseName=").append(config.getDatabase());
                break;
            }
            case HIVE: {
                url.append("jdbc:hive2://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDatabase());
                break;
            }
            case IMPALA: {
                url.append("jdbc:impala://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDatabase());
                break;
            }
            default: {
                url.append("jdbc:").append(config.getType().getType()).append("://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDatabase());
            }
        }
        if (config.getProperties() != null && !config.getProperties().isEmpty()) {
            url.append(config.getType() == DatabaseType.SQLSERVER ? ";" : "?");
            for (Map.Entry<String, String> prop : config.getProperties().entrySet()) {
                url.append(prop.getKey()).append("=").append(prop.getValue()).append(config.getType() == DatabaseType.SQLSERVER ? ";" : "&");
            }
            if (config.getType() != DatabaseType.SQLSERVER) {
                url.deleteCharAt(url.length() - 1);
            }
        }
        return url.toString();
    }

    public Properties buildConnectionProperties() {
        Properties props = new Properties();
        props.setProperty("lex", this.getProperties().getOrDefault("lex", "JAVA"));
        props.setProperty("caseSensitive", this.getProperties().getOrDefault("caseSensitive", "false"));
        props.setProperty("unquotedCasing", this.getProperties().getOrDefault("unquotedCasing", "UNCHANGED"));
        props.setProperty("quoting", this.getProperties().getOrDefault("quoting", "DOUBLE_QUOTE"));
        props.setProperty("conformance", this.getProperties().getOrDefault("conformance", "LENIENT"));
        props.setProperty("model", "inline:" + this.buildModelJson());
        props.setProperty("timeZone", this.timeZone);
        props.setProperty("locale", this.locale);
        props.setProperty("materializationsEnabled", String.valueOf(this.enableMaterialization));
        props.setProperty("streaming", String.valueOf(this.enableStreaming));
        if (this.enableCache) {
            props.setProperty("cacheEnabled", "true");
            props.setProperty("cacheMaxSize", String.valueOf(this.cacheSize));
        }
        if (this.enableValidation) {
            props.setProperty("validate", "true");
        }
        for (Map.Entry<String, String> entry : this.getProperties().entrySet()) {
            if (props.containsKey(entry.getKey())) continue;
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public List<String> getDataSourceNames() {
        return new ArrayList<String>(this.dataSources.keySet());
    }

    public DatabaseConfig getDataSource(String name) {
        return this.dataSources.get(name);
    }

    public boolean containsDataSource(String name) {
        return this.dataSources.containsKey(name);
    }

    public void clearDataSources() {
        this.dataSources.clear();
    }

    public int getDataSourceCount() {
        return this.dataSources.size();
    }

    public String exportToProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("# Calcite Configuration\n");
        sb.append("calcite.defaultSchema=").append(this.defaultSchema).append("\n");
        sb.append("calcite.enableCache=").append(this.enableCache).append("\n");
        sb.append("calcite.cacheSize=").append(this.cacheSize).append("\n");
        sb.append("calcite.timeZone=").append(this.timeZone).append("\n");
        sb.append("calcite.locale=").append(this.locale).append("\n");
        sb.append("calcite.enableMaterialization=").append(this.enableMaterialization).append("\n");
        sb.append("calcite.enableStreaming=").append(this.enableStreaming).append("\n");
        sb.append("\n");
        sb.append("# Data Sources\n");
        for (Map.Entry<String, DatabaseConfig> entry : this.dataSources.entrySet()) {
            String name = entry.getKey();
            DatabaseConfig config = entry.getValue();
            sb.append("datasource.").append(name).append(".type=").append((Object)config.getType()).append("\n");
            sb.append("datasource.").append(name).append(".host=").append(config.getHost()).append("\n");
            sb.append("datasource.").append(name).append(".port=").append(config.getPort()).append("\n");
            sb.append("datasource.").append(name).append(".database=").append(config.getDatabase()).append("\n");
            sb.append("datasource.").append(name).append(".username=").append(config.getUsername()).append("\n");
            sb.append("datasource.").append(name).append(".password=").append(config.getPassword()).append("\n");
        }
        return sb.toString();
    }

    protected CalciteConfig(CalciteConfigBuilder<?, ?> b) {
        super(b);
        this.dataSources = ((CalciteConfigBuilder)b).dataSources;
        this.schemaDefinitions = ((CalciteConfigBuilder)b).schemaDefinitions;
        this.defaultSchema = ((CalciteConfigBuilder)b).defaultSchema;
        this.enableCache = ((CalciteConfigBuilder)b).enableCache;
        this.cacheSize = ((CalciteConfigBuilder)b).cacheSize;
        this.enableValidation = ((CalciteConfigBuilder)b).enableValidation;
        this.enableMaterialization = ((CalciteConfigBuilder)b).enableMaterialization;
        this.enableStreaming = ((CalciteConfigBuilder)b).enableStreaming;
        this.timeZone = ((CalciteConfigBuilder)b).timeZone;
        this.locale = ((CalciteConfigBuilder)b).locale;
        this.udfJars = ((CalciteConfigBuilder)b).udfJars;
        this.optimizerRules = ((CalciteConfigBuilder)b).optimizerRules;
        this.modelProperties = ((CalciteConfigBuilder)b).modelProperties;
    }

    public static CalciteConfigBuilder<?, ?> builder() {
        return new CalciteConfigBuilderImpl();
    }

    public Map<String, DatabaseConfig> getDataSources() {
        return this.dataSources;
    }

    public Map<String, String> getSchemaDefinitions() {
        return this.schemaDefinitions;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public boolean isEnableValidation() {
        return this.enableValidation;
    }

    public boolean isEnableMaterialization() {
        return this.enableMaterialization;
    }

    public boolean isEnableStreaming() {
        return this.enableStreaming;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getLocale() {
        return this.locale;
    }

    public List<String> getUdfJars() {
        return this.udfJars;
    }

    public Map<String, Object> getOptimizerRules() {
        return this.optimizerRules;
    }

    public Map<String, String> getModelProperties() {
        return this.modelProperties;
    }

    public void setDataSources(Map<String, DatabaseConfig> dataSources) {
        this.dataSources = dataSources;
    }

    public void setSchemaDefinitions(Map<String, String> schemaDefinitions) {
        this.schemaDefinitions = schemaDefinitions;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setEnableValidation(boolean enableValidation) {
        this.enableValidation = enableValidation;
    }

    public void setEnableMaterialization(boolean enableMaterialization) {
        this.enableMaterialization = enableMaterialization;
    }

    public void setEnableStreaming(boolean enableStreaming) {
        this.enableStreaming = enableStreaming;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setUdfJars(List<String> udfJars) {
        this.udfJars = udfJars;
    }

    public void setOptimizerRules(Map<String, Object> optimizerRules) {
        this.optimizerRules = optimizerRules;
    }

    public void setModelProperties(Map<String, String> modelProperties) {
        this.modelProperties = modelProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalciteConfig)) {
            return false;
        }
        CalciteConfig other = (CalciteConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DatabaseConfig> this$dataSources = this.getDataSources();
        Map<String, DatabaseConfig> other$dataSources = other.getDataSources();
        if (this$dataSources == null ? other$dataSources != null : !((Object)this$dataSources).equals(other$dataSources)) {
            return false;
        }
        Map<String, String> this$schemaDefinitions = this.getSchemaDefinitions();
        Map<String, String> other$schemaDefinitions = other.getSchemaDefinitions();
        if (this$schemaDefinitions == null ? other$schemaDefinitions != null : !((Object)this$schemaDefinitions).equals(other$schemaDefinitions)) {
            return false;
        }
        String this$defaultSchema = this.getDefaultSchema();
        String other$defaultSchema = other.getDefaultSchema();
        if (this$defaultSchema == null ? other$defaultSchema != null : !this$defaultSchema.equals(other$defaultSchema)) {
            return false;
        }
        if (this.isEnableCache() != other.isEnableCache()) {
            return false;
        }
        if (this.getCacheSize() != other.getCacheSize()) {
            return false;
        }
        if (this.isEnableValidation() != other.isEnableValidation()) {
            return false;
        }
        if (this.isEnableMaterialization() != other.isEnableMaterialization()) {
            return false;
        }
        if (this.isEnableStreaming() != other.isEnableStreaming()) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        List<String> this$udfJars = this.getUdfJars();
        List<String> other$udfJars = other.getUdfJars();
        if (this$udfJars == null ? other$udfJars != null : !((Object)this$udfJars).equals(other$udfJars)) {
            return false;
        }
        Map<String, Object> this$optimizerRules = this.getOptimizerRules();
        Map<String, Object> other$optimizerRules = other.getOptimizerRules();
        if (this$optimizerRules == null ? other$optimizerRules != null : !((Object)this$optimizerRules).equals(other$optimizerRules)) {
            return false;
        }
        Map<String, String> this$modelProperties = this.getModelProperties();
        Map<String, String> other$modelProperties = other.getModelProperties();
        return !(this$modelProperties == null ? other$modelProperties != null : !((Object)this$modelProperties).equals(other$modelProperties));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CalciteConfig;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DatabaseConfig> $dataSources = this.getDataSources();
        result = result * 59 + ($dataSources == null ? 43 : ((Object)$dataSources).hashCode());
        Map<String, String> $schemaDefinitions = this.getSchemaDefinitions();
        result = result * 59 + ($schemaDefinitions == null ? 43 : ((Object)$schemaDefinitions).hashCode());
        String $defaultSchema = this.getDefaultSchema();
        result = result * 59 + ($defaultSchema == null ? 43 : $defaultSchema.hashCode());
        result = result * 59 + (this.isEnableCache() ? 79 : 97);
        result = result * 59 + this.getCacheSize();
        result = result * 59 + (this.isEnableValidation() ? 79 : 97);
        result = result * 59 + (this.isEnableMaterialization() ? 79 : 97);
        result = result * 59 + (this.isEnableStreaming() ? 79 : 97);
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : $locale.hashCode());
        List<String> $udfJars = this.getUdfJars();
        result = result * 59 + ($udfJars == null ? 43 : ((Object)$udfJars).hashCode());
        Map<String, Object> $optimizerRules = this.getOptimizerRules();
        result = result * 59 + ($optimizerRules == null ? 43 : ((Object)$optimizerRules).hashCode());
        Map<String, String> $modelProperties = this.getModelProperties();
        result = result * 59 + ($modelProperties == null ? 43 : ((Object)$modelProperties).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CalciteConfig(dataSources=" + this.getDataSources() + ", schemaDefinitions=" + this.getSchemaDefinitions() + ", defaultSchema=" + this.getDefaultSchema() + ", enableCache=" + this.isEnableCache() + ", cacheSize=" + this.getCacheSize() + ", enableValidation=" + this.isEnableValidation() + ", enableMaterialization=" + this.isEnableMaterialization() + ", enableStreaming=" + this.isEnableStreaming() + ", timeZone=" + this.getTimeZone() + ", locale=" + this.getLocale() + ", udfJars=" + this.getUdfJars() + ", optimizerRules=" + this.getOptimizerRules() + ", modelProperties=" + this.getModelProperties() + ")";
    }

    public CalciteConfig(Map<String, DatabaseConfig> dataSources, Map<String, String> schemaDefinitions, String defaultSchema, boolean enableCache, int cacheSize, boolean enableValidation, boolean enableMaterialization, boolean enableStreaming, String timeZone, String locale, List<String> udfJars, Map<String, Object> optimizerRules, Map<String, String> modelProperties) {
        this.dataSources = dataSources;
        this.schemaDefinitions = schemaDefinitions;
        this.defaultSchema = defaultSchema;
        this.enableCache = enableCache;
        this.cacheSize = cacheSize;
        this.enableValidation = enableValidation;
        this.enableMaterialization = enableMaterialization;
        this.enableStreaming = enableStreaming;
        this.timeZone = timeZone;
        this.locale = locale;
        this.udfJars = udfJars;
        this.optimizerRules = optimizerRules;
        this.modelProperties = modelProperties;
    }

    private static final class CalciteConfigBuilderImpl
    extends CalciteConfigBuilder<CalciteConfig, CalciteConfigBuilderImpl> {
        private CalciteConfigBuilderImpl() {
        }

        @Override
        protected CalciteConfigBuilderImpl self() {
            return this;
        }

        @Override
        public CalciteConfig build() {
            return new CalciteConfig(this);
        }
    }

    public static abstract class CalciteConfigBuilder<C extends CalciteConfig, B extends CalciteConfigBuilder<C, B>>
    extends DatabaseConfig.DatabaseConfigBuilder<C, B> {
        private Map<String, DatabaseConfig> dataSources;
        private Map<String, String> schemaDefinitions;
        private String defaultSchema;
        private boolean enableCache;
        private int cacheSize;
        private boolean enableValidation;
        private boolean enableMaterialization;
        private boolean enableStreaming;
        private String timeZone;
        private String locale;
        private List<String> udfJars;
        private Map<String, Object> optimizerRules;
        private Map<String, String> modelProperties;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B dataSources(Map<String, DatabaseConfig> dataSources) {
            this.dataSources = dataSources;
            return (B)this.self();
        }

        public B schemaDefinitions(Map<String, String> schemaDefinitions) {
            this.schemaDefinitions = schemaDefinitions;
            return (B)this.self();
        }

        public B defaultSchema(String defaultSchema) {
            this.defaultSchema = defaultSchema;
            return (B)this.self();
        }

        public B enableCache(boolean enableCache) {
            this.enableCache = enableCache;
            return (B)this.self();
        }

        public B cacheSize(int cacheSize) {
            this.cacheSize = cacheSize;
            return (B)this.self();
        }

        public B enableValidation(boolean enableValidation) {
            this.enableValidation = enableValidation;
            return (B)this.self();
        }

        public B enableMaterialization(boolean enableMaterialization) {
            this.enableMaterialization = enableMaterialization;
            return (B)this.self();
        }

        public B enableStreaming(boolean enableStreaming) {
            this.enableStreaming = enableStreaming;
            return (B)this.self();
        }

        public B timeZone(String timeZone) {
            this.timeZone = timeZone;
            return (B)this.self();
        }

        public B locale(String locale) {
            this.locale = locale;
            return (B)this.self();
        }

        public B udfJars(List<String> udfJars) {
            this.udfJars = udfJars;
            return (B)this.self();
        }

        public B optimizerRules(Map<String, Object> optimizerRules) {
            this.optimizerRules = optimizerRules;
            return (B)this.self();
        }

        public B modelProperties(Map<String, String> modelProperties) {
            this.modelProperties = modelProperties;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CalciteConfig.CalciteConfigBuilder(super=" + super.toString() + ", dataSources=" + this.dataSources + ", schemaDefinitions=" + this.schemaDefinitions + ", defaultSchema=" + this.defaultSchema + ", enableCache=" + this.enableCache + ", cacheSize=" + this.cacheSize + ", enableValidation=" + this.enableValidation + ", enableMaterialization=" + this.enableMaterialization + ", enableStreaming=" + this.enableStreaming + ", timeZone=" + this.timeZone + ", locale=" + this.locale + ", udfJars=" + this.udfJars + ", optimizerRules=" + this.optimizerRules + ", modelProperties=" + this.modelProperties + ")";
        }
    }
}

