/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.jdbc.service.impl;

import com.digiwin.commons.entity.enums.jdbc.QueryType;
import com.digiwin.commons.entity.model.QueryResult;
import com.digiwin.commons.factory.jdbc.QueryExecutorFactory;
import com.digiwin.jdbc.config.DatabaseConfig;
import com.digiwin.jdbc.executor.BaseQueryExecutor;
import com.digiwin.jdbc.service.MultiDbQueryService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiDbQueryServiceImpl
implements MultiDbQueryService {
    private static final Logger log = LoggerFactory.getLogger(MultiDbQueryServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(MultiDbQueryServiceImpl.class);

    @Override
    public QueryResult executeQuery(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql) throws Exception {
        return this.executeQuery(queryType, dataSourceConfigs, sql, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public QueryResult executeQuery(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql, Map<String, Object> params) throws Exception {
        QueryResult queryResult;
        logger.debug("\u6267\u884c{}\u67e5\u8be2: {}", (Object)queryType, (Object)sql);
        BaseQueryExecutor executor = null;
        try {
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            QueryResult result = params != null && !params.isEmpty() ? executor.executeQuery(sql, params) : executor.executeQuery(sql);
            logger.debug("{}\u67e5\u8be2\u6267\u884c\u6210\u529f\uff0c\u8fd4\u56de{}\u6761\u8bb0\u5f55", (Object)queryType, (Object)result.getTotalCount());
            queryResult = result;
            if (executor == null) return queryResult;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884c{}\u67e5\u8be2\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
                throw new Exception("Failed to execute " + (Object)((Object)queryType) + " query: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (executor == null) throw throwable;
                try {
                    executor.close();
                    logger.debug("executeQuery{}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e2.getMessage(), e2});
                }
                throw throwable;
            }
        }
        try {
            executor.close();
            logger.debug("executeQuery{}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
            return queryResult;
        }
        catch (Exception e) {
            logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
        }
        return queryResult;
    }

    @Override
    public int executeUpdate(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql) throws Exception {
        return this.executeUpdate(queryType, dataSourceConfigs, sql, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int executeUpdate(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String sql, Map<String, Object> params) throws Exception {
        int n;
        logger.debug("\u6267\u884c{}\u66f4\u65b0\u64cd\u4f5c: {}", (Object)queryType, (Object)sql);
        BaseQueryExecutor executor = null;
        try {
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            int result = params != null && !params.isEmpty() ? executor.executeUpdate(sql, params) : executor.executeUpdate(sql);
            logger.debug("{}\u66f4\u65b0\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd{}\u884c", (Object)queryType, (Object)result);
            n = result;
            if (executor == null) return n;
        }
        catch (Exception e) {
            try {
                logger.error("\u6267\u884c{}\u66f4\u65b0\u64cd\u4f5c\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
                throw new Exception("Failed to execute " + (Object)((Object)queryType) + " update: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                if (executor == null) throw throwable;
                try {
                    executor.close();
                    logger.debug("executeUpdate {}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e2.getMessage(), e2});
                }
                throw throwable;
            }
        }
        try {
            executor.close();
            logger.debug("executeUpdate {}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
            return n;
        }
        catch (Exception e) {
            logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean testConnection(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs) {
        boolean bl;
        BaseQueryExecutor executor;
        block11: {
            logger.debug("\u6d4b\u8bd5{}\u6570\u636e\u5e93\u8fde\u63a5", (Object)queryType);
            executor = null;
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            boolean result = executor.testConnection();
            logger.debug("{}\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c: {}", (Object)queryType, (Object)(result ? "\u6210\u529f" : "\u5931\u8d25"));
            bl = result;
            if (executor == null) break block11;
            try {
                executor.close();
                logger.debug("testConnection {}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
            }
            catch (Exception e) {
                logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
            }
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            block12: {
                try {
                    logger.error("\u6d4b\u8bd5{}\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
                    bl2 = false;
                    if (executor == null) break block12;
                }
                catch (Throwable throwable) {
                    if (executor != null) {
                        try {
                            executor.close();
                            logger.debug("testConnection {}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                        }
                        catch (Exception e2) {
                            logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e2.getMessage(), e2});
                        }
                    }
                    throw throwable;
                }
                try {
                    executor.close();
                    logger.debug("testConnection {}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                }
                catch (Exception e3) {
                    logger.warn("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e3.getMessage(), e3});
                }
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean testConnection(QueryType queryType, Map<String, DatabaseConfig> dataSourceConfigs, String dataSourceName) {
        boolean bl;
        BaseQueryExecutor executor;
        block11: {
            logger.debug("\u6d4b\u8bd5{}\u6570\u636e\u6e90\u8fde\u63a5 [\u6570\u636e\u6e90: {}]", (Object)queryType, (Object)dataSourceName);
            executor = null;
            executor = QueryExecutorFactory.createExecutor(queryType, dataSourceConfigs);
            boolean result = executor.testConnection(dataSourceName);
            logger.debug("{}\u6570\u636e\u6e90\u8fde\u63a5\u6d4b\u8bd5\u7ed3\u679c [\u6570\u636e\u6e90: {}]: {}", new Object[]{queryType, dataSourceName, result ? "\u6210\u529f" : "\u5931\u8d25"});
            bl = result;
            if (executor == null) break block11;
            try {
                executor.close();
                logger.debug("{}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e.getMessage(), e});
            }
        }
        return bl;
        catch (Exception e) {
            boolean bl2;
            block12: {
                try {
                    logger.error("\u6d4b\u8bd5{}\u6570\u636e\u6e90\u8fde\u63a5\u65f6\u53d1\u751f\u9519\u8bef [\u6570\u636e\u6e90: {}]: {}", new Object[]{queryType, dataSourceName, e.getMessage(), e});
                    bl2 = false;
                    if (executor == null) break block12;
                }
                catch (Throwable throwable) {
                    if (executor != null) {
                        try {
                            executor.close();
                            logger.debug("{}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                        }
                        catch (Exception e2) {
                            logger.error("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e2.getMessage(), e2});
                        }
                    }
                    throw throwable;
                }
                try {
                    executor.close();
                    logger.debug("{}\u67e5\u8be2\u6267\u884c\u5668\u8d44\u6e90\u5df2\u91ca\u653e", (Object)queryType);
                }
                catch (Exception e3) {
                    logger.error("\u5173\u95ed{}\u67e5\u8be2\u6267\u884c\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", new Object[]{queryType, e3.getMessage(), e3});
                }
            }
            return bl2;
        }
    }
}

