/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.core.entity.datasource;

import com.digiwin.dcc.core.entity.datasource.DataSource;

public class DataSourceRequest {
    protected String query;
    protected String viewName;
    protected DataSource datasource;
    protected String table;
    private Integer pageSize;
    private Integer page;
    private boolean pageable = false;

    private static Integer $default$pageSize() {
        return 50;
    }

    private static Integer $default$page() {
        return 1;
    }

    public static DataSourceRequestBuilder builder() {
        return new DataSourceRequestBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public String getViewName() {
        return this.viewName;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public String getTable() {
        return this.table;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPage() {
        return this.page;
    }

    public boolean isPageable() {
        return this.pageable;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageable(boolean pageable) {
        this.pageable = pageable;
    }

    public DataSourceRequest(String query, String viewName, DataSource datasource, String table, Integer pageSize, Integer page, boolean pageable) {
        this.query = query;
        this.viewName = viewName;
        this.datasource = datasource;
        this.table = table;
        this.pageSize = pageSize;
        this.page = page;
        this.pageable = pageable;
    }

    public DataSourceRequest() {
        this.pageSize = DataSourceRequest.$default$pageSize();
        this.page = DataSourceRequest.$default$page();
    }

    public static class DataSourceRequestBuilder {
        private String query;
        private String viewName;
        private DataSource datasource;
        private String table;
        private boolean pageSize$set;
        private Integer pageSize$value;
        private boolean page$set;
        private Integer page$value;
        private boolean pageable;

        DataSourceRequestBuilder() {
        }

        public DataSourceRequestBuilder query(String query) {
            this.query = query;
            return this;
        }

        public DataSourceRequestBuilder viewName(String viewName) {
            this.viewName = viewName;
            return this;
        }

        public DataSourceRequestBuilder datasource(DataSource datasource) {
            this.datasource = datasource;
            return this;
        }

        public DataSourceRequestBuilder table(String table) {
            this.table = table;
            return this;
        }

        public DataSourceRequestBuilder pageSize(Integer pageSize) {
            this.pageSize$value = pageSize;
            this.pageSize$set = true;
            return this;
        }

        public DataSourceRequestBuilder page(Integer page) {
            this.page$value = page;
            this.page$set = true;
            return this;
        }

        public DataSourceRequestBuilder pageable(boolean pageable) {
            this.pageable = pageable;
            return this;
        }

        public DataSourceRequest build() {
            Integer pageSize$value = this.pageSize$value;
            if (!this.pageSize$set) {
                pageSize$value = DataSourceRequest.$default$pageSize();
            }
            Integer page$value = this.page$value;
            if (!this.page$set) {
                page$value = DataSourceRequest.$default$page();
            }
            return new DataSourceRequest(this.query, this.viewName, this.datasource, this.table, pageSize$value, page$value, this.pageable);
        }

        public String toString() {
            return "DataSourceRequest.DataSourceRequestBuilder(query=" + this.query + ", viewName=" + this.viewName + ", datasource=" + this.datasource + ", table=" + this.table + ", pageSize$value=" + this.pageSize$value + ", page$value=" + this.page$value + ", pageable=" + this.pageable + ")";
        }
    }
}

