/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.core.entity.model;

import com.digiwin.dcc.core.entity.datasource.DataSource;
import com.digiwin.dcc.core.entity.model.ModelField;
import com.digiwin.dcc.core.entity.model.ModelLink;
import com.digiwin.dcc.core.entity.model.ModelMirror;
import com.digiwin.dcc.core.entity.model.ModelTable;
import com.digiwin.dcc.core.entity.model.ModelTableTree;
import com.digiwin.dcc.core.entity.model.ModelTableTreeField;
import com.digiwin.dcc.core.entity.query.PlaygroundComputedField;
import com.digiwin.dcc.core.entity.query.PlaygroundComputedFieldAnalysis;
import com.digiwin.dcc.core.enums.DataSourceTypeEnum;
import com.digiwin.dcc.core.exception.Asserts;
import com.digiwin.dcc.core.util.BeanUtil;
import com.digiwin.dcc.core.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Schema(name="DataModel DTO")
public class DataModel {
    private static final Logger log = LoggerFactory.getLogger(DataModel.class);
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Schema(description="\u4e3b\u952e")
    private Long id;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Schema(description="\u6570\u636e\u6e90\u4e3b\u952e")
    private Long dsId;
    @Schema(description="\u6570\u636e\u6e90\u7c7b\u578b")
    private String dsType = DataSourceTypeEnum.mysql.getType();
    @NotBlank(message="\u6a21\u578bcode\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u6a21\u578bcode")
    private @NotBlank(message="\u6a21\u578bcode\u4e0d\u80fd\u4e3a\u7a7a") String code;
    @NotBlank(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    @Schema(description="\u6a21\u578b\u540d\u79f0")
    private @NotBlank(message="\u6a21\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String name;
    @Schema(description="\u63cf\u8ff0")
    private String comment;
    @Valid
    @Schema(description="\u5b9e\u4f53\u96c6\u5408")
    private List<ModelTable> tables;
    @Valid
    @Schema(description="\u5b9e\u4f53\u96c6\u5408")
    @JsonIgnore
    private List<ModelTable> realTables;
    @Valid
    @Schema(description="\u5b9e\u4f53\u5173\u7cfb\u96c6\u5408")
    private List<ModelLink> links;
    @NotNull(message="\u6a21\u578b\u7c7b\u578b\u5fc5\u586b\u9879")
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Schema(description="\u6a21\u578b\u7c7b\u578b", required=true, allowableValues={"1", "2", "3"})
    private @NotNull(message="\u6a21\u578b\u7c7b\u578b\u5fc5\u586b\u9879") Integer type;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Integer multiTenant;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Schema(description="\u662f\u5426\u5f00\u542f\u5f3a\u5173\u8054(\u5bf9\u8c61\u6a21\u578b)\u7684\u5b57\u6bb5, 0:\u5426, 1:\u662f", defaultValue="0", allowableValues={"0", "1"})
    private Integer strongRelationship = 0;
    @Schema(description="\u6a21\u578b\u955c\u50cf")
    private List<ModelMirror> mirrors = new ArrayList<ModelMirror>();
    @Schema(description="\u4ea7\u54c1\u7c7b\u578b")
    private String productType;
    private DataSource dataSource;

    public Map<String, Map<String, ModelField>> getModelFieldMap(Map<String, PlaygroundComputedField> computedFieldMap, String keywordPrefix, Map<String, Map<String, String>> queryFieldAliasMap) {
        return this.tables.stream().collect(Collectors.toMap(ModelTable::getPath, b -> {
            log.debug("DataModel getModelFieldMap getPath::{}", (Object)b.getPath());
            return b.getFields().stream().collect(Collectors.toMap(ModelField::getCode, a -> {
                if (a.getExtFiled() == 1) {
                    PlaygroundComputedField computedField = new PlaygroundComputedField();
                    BeanUtil.copyBeanProp(computedField, a);
                    computedField.setField(b.getPath() + "__" + a.getCode());
                    log.debug("DataModel getModelFieldMap getComputeField::{}", (Object)computedField.getField());
                    PlaygroundComputedFieldAnalysis playgroundComputedFieldAnalysis = DataModel.analysisComputedField(computedField, keywordPrefix, queryFieldAliasMap);
                    computedField.setExpressionFields(playgroundComputedFieldAnalysis.getFields());
                    computedField.setSql(playgroundComputedFieldAnalysis.getExpression());
                    computedFieldMap.putIfAbsent(computedField.getField(), computedField);
                }
                return a;
            }));
        }));
    }

    public static ModelTableTree getAllTableTree(DataModel dataModelDTO) {
        List<ModelTable> tables = dataModelDTO.getTables();
        List<ModelLink> links = dataModelDTO.getLinks();
        HashMap<String, ModelTable> tableMap = new HashMap<String, ModelTable>();
        ModelTable mainEntity = null;
        for (int i = 0; i < tables.size(); ++i) {
            tableMap.put(tables.get(i).getPath(), tables.get(i));
            if (tables.get(i).getType() != 1) continue;
            mainEntity = tables.get(i);
        }
        if (mainEntity == null) {
            return null;
        }
        HashSet<String> usedCode = new HashSet<String>();
        String path = mainEntity.getPath();
        usedCode.add(path);
        ModelTableTree vo = new ModelTableTree();
        vo.setCode(path);
        vo.setCodeName(mainEntity.getName());
        vo.setChildren(DataModel.getAllTableChildren(links, path, tableMap, usedCode));
        List<ModelTableTreeField> tableFields = BeanUtil.copyListProperties(mainEntity.getFields(), ModelTableTreeField::new, (s, t) -> {
            t.setCode(s.getCode());
            t.setField(path + "__" + s.getCode());
        });
        vo.setTableFields(tableFields);
        return vo;
    }

    public static PlaygroundComputedFieldAnalysis analysisComputedField(PlaygroundComputedField computedField, String keywordPrefix, Map<String, Map<String, String>> queryFieldAliasMap) {
        List<String> originalFields = StringUtils.matcherPatternWord(computedField.getExpression(), "\\[(.*?)\\]");
        String expression = computedField.getExpression();
        for (int i = 0; i < originalFields.size(); ++i) {
            String field = originalFields.get(i);
            String[] splitArr = field.split("__");
            if (!queryFieldAliasMap.containsKey(splitArr[0])) continue;
            expression = expression.replaceAll(field, splitArr[0].concat("__").concat(queryFieldAliasMap.get(splitArr[0]).get(splitArr[1])));
        }
        expression = expression.replaceAll("\u00a0", " ").replaceAll("\\[", keywordPrefix).replaceAll("__", keywordPrefix + ".").replaceAll("\\]", "");
        return new PlaygroundComputedFieldAnalysis(expression, originalFields);
    }

    private static List<ModelTableTree> getAllTableChildren(List<ModelLink> links, String tableCode, Map<String, ModelTable> tablesMap, Set<String> usedCode) {
        ArrayList<ModelTableTree> resList = new ArrayList<ModelTableTree>();
        for (int i = 0; i < links.size(); ++i) {
            ModelLink modelLinkDTO = links.get(i);
            String targetTableCode = null;
            if (modelLinkDTO.getSourcePath().equals(tableCode) && !usedCode.contains(modelLinkDTO.getTargetPath())) {
                targetTableCode = modelLinkDTO.getTargetPath();
            } else if (modelLinkDTO.getTargetPath().equals(tableCode) && !usedCode.contains(modelLinkDTO.getSourcePath())) {
                targetTableCode = modelLinkDTO.getSourcePath();
            }
            if (null == modelLinkDTO || !tablesMap.containsKey(targetTableCode)) continue;
            ModelTable entity = tablesMap.get(targetTableCode);
            tablesMap.remove(targetTableCode);
            ModelTableTree vo = new ModelTableTree();
            String path = entity.getPath();
            vo.setCode(path);
            vo.setCodeName(entity.getName());
            vo.setChildren(DataModel.getAllTableChildren(links, path, tablesMap, usedCode));
            vo.setTableFields(BeanUtil.copyListProperties(entity.getFields(), ModelTableTreeField::new, (s, t) -> {
                t.setCode(s.getCode());
                t.setField(path + "__" + s.getCode());
            }));
            resList.add(vo);
        }
        return resList;
    }

    public ModelTableTree getTableTreeMap(DataModel dataModelDTO) {
        List<ModelTable> tables = dataModelDTO.getTables();
        List<ModelLink> links = dataModelDTO.getLinks();
        HashMap<String, ModelTable> tableMap = new HashMap<String, ModelTable>();
        ModelTable mainEntity = null;
        for (int i = 0; i < tables.size(); ++i) {
            tableMap.put(tables.get(i).getPath(), tables.get(i));
            if (tables.get(i).getType() != 1) continue;
            mainEntity = tables.get(i);
        }
        Asserts.fail(mainEntity == null, "\u4e0d\u652f\u6301\u6a21\u578b\u4e2d\u65e0\u4e3b\u5b9e\u4f53");
        HashSet<String> usedPath = new HashSet<String>();
        usedPath.add(mainEntity.getPath());
        ModelTableTree vo = new ModelTableTree();
        vo.setCode(mainEntity.getPath());
        vo.setCodeName(mainEntity.getName());
        vo.setChildren(this.getTableChildren(links, mainEntity.getPath(), tableMap, usedPath));
        return vo;
    }

    private List<ModelTableTree> getTableChildren(List<ModelLink> links, String tablePath, Map<String, ModelTable> tablesMap, Set<String> usedPath) {
        ArrayList<ModelTableTree> resList = new ArrayList<ModelTableTree>();
        for (int i = 0; i < links.size(); ++i) {
            ModelLink modelLinkDTO = links.get(i);
            String targetTablePath = null;
            if (modelLinkDTO.getSourcePath().equals(tablePath) && !usedPath.contains(modelLinkDTO.getTargetPath())) {
                targetTablePath = modelLinkDTO.getTargetPath();
            } else if (modelLinkDTO.getTargetPath().equals(tablePath) && !usedPath.contains(modelLinkDTO.getSourcePath())) {
                targetTablePath = modelLinkDTO.getSourcePath();
            }
            if (null == modelLinkDTO || !tablesMap.containsKey(targetTablePath)) continue;
            ModelTable entity = tablesMap.get(targetTablePath);
            tablesMap.remove(targetTablePath);
            ModelTableTree vo = new ModelTableTree();
            vo.setCode(entity.getPath());
            vo.setCodeName(entity.getName());
            vo.setChildren(this.getTableChildren(links, entity.getPath(), tablesMap, usedPath));
            resList.add(vo);
        }
        return resList;
    }

    public Long getId() {
        return this.id;
    }

    public Long getDsId() {
        return this.dsId;
    }

    public String getDsType() {
        return this.dsType;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public List<ModelTable> getTables() {
        return this.tables;
    }

    public List<ModelTable> getRealTables() {
        return this.realTables;
    }

    public List<ModelLink> getLinks() {
        return this.links;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getMultiTenant() {
        return this.multiTenant;
    }

    public Integer getStrongRelationship() {
        return this.strongRelationship;
    }

    public List<ModelMirror> getMirrors() {
        return this.mirrors;
    }

    public String getProductType() {
        return this.productType;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setId(Long id) {
        this.id = id;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setDsId(Long dsId) {
        this.dsId = dsId;
    }

    public void setDsType(String dsType) {
        this.dsType = dsType;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTables(List<ModelTable> tables) {
        this.tables = tables;
    }

    @JsonIgnore
    public void setRealTables(List<ModelTable> realTables) {
        this.realTables = realTables;
    }

    public void setLinks(List<ModelLink> links) {
        this.links = links;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setType(Integer type) {
        this.type = type;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setMultiTenant(Integer multiTenant) {
        this.multiTenant = multiTenant;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setStrongRelationship(Integer strongRelationship) {
        this.strongRelationship = strongRelationship;
    }

    public void setMirrors(List<ModelMirror> mirrors) {
        this.mirrors = mirrors;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataModel)) {
            return false;
        }
        DataModel other = (DataModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$dsId = this.getDsId();
        Long other$dsId = other.getDsId();
        if (this$dsId == null ? other$dsId != null : !((Object)this$dsId).equals(other$dsId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$multiTenant = this.getMultiTenant();
        Integer other$multiTenant = other.getMultiTenant();
        if (this$multiTenant == null ? other$multiTenant != null : !((Object)this$multiTenant).equals(other$multiTenant)) {
            return false;
        }
        Integer this$strongRelationship = this.getStrongRelationship();
        Integer other$strongRelationship = other.getStrongRelationship();
        if (this$strongRelationship == null ? other$strongRelationship != null : !((Object)this$strongRelationship).equals(other$strongRelationship)) {
            return false;
        }
        String this$dsType = this.getDsType();
        String other$dsType = other.getDsType();
        if (this$dsType == null ? other$dsType != null : !this$dsType.equals(other$dsType)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<ModelTable> this$tables = this.getTables();
        List<ModelTable> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
            return false;
        }
        List<ModelTable> this$realTables = this.getRealTables();
        List<ModelTable> other$realTables = other.getRealTables();
        if (this$realTables == null ? other$realTables != null : !((Object)this$realTables).equals(other$realTables)) {
            return false;
        }
        List<ModelLink> this$links = this.getLinks();
        List<ModelLink> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<ModelMirror> this$mirrors = this.getMirrors();
        List<ModelMirror> other$mirrors = other.getMirrors();
        if (this$mirrors == null ? other$mirrors != null : !((Object)this$mirrors).equals(other$mirrors)) {
            return false;
        }
        String this$productType = this.getProductType();
        String other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
            return false;
        }
        DataSource this$dataSource = this.getDataSource();
        DataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $dsId = this.getDsId();
        result = result * 59 + ($dsId == null ? 43 : ((Object)$dsId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $multiTenant = this.getMultiTenant();
        result = result * 59 + ($multiTenant == null ? 43 : ((Object)$multiTenant).hashCode());
        Integer $strongRelationship = this.getStrongRelationship();
        result = result * 59 + ($strongRelationship == null ? 43 : ((Object)$strongRelationship).hashCode());
        String $dsType = this.getDsType();
        result = result * 59 + ($dsType == null ? 43 : $dsType.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<ModelTable> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        List<ModelTable> $realTables = this.getRealTables();
        result = result * 59 + ($realTables == null ? 43 : ((Object)$realTables).hashCode());
        List<ModelLink> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<ModelMirror> $mirrors = this.getMirrors();
        result = result * 59 + ($mirrors == null ? 43 : ((Object)$mirrors).hashCode());
        String $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
        DataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    public String toString() {
        return "DataModel(id=" + this.getId() + ", dsId=" + this.getDsId() + ", dsType=" + this.getDsType() + ", code=" + this.getCode() + ", name=" + this.getName() + ", comment=" + this.getComment() + ", tables=" + this.getTables() + ", realTables=" + this.getRealTables() + ", links=" + this.getLinks() + ", type=" + this.getType() + ", multiTenant=" + this.getMultiTenant() + ", strongRelationship=" + this.getStrongRelationship() + ", mirrors=" + this.getMirrors() + ", productType=" + this.getProductType() + ", dataSource=" + this.getDataSource() + ")";
    }
}

