/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.core.enums;

import java.util.Arrays;
import java.util.List;

public enum DataSourceTypeEnum {
    mysql("mysql", "MySQL", "`", "`", "", "", "characterEncoding=UTF-8&connectTimeout=5000&useSSL=false&allowPublicKeyRetrieval=true", true, null, null, true),
    impala("impala", "Apache Impala", "`", "`", "'", "'", "AuthMech=0", true, null, null, true),
    mariadb("mariadb", "MariaDB", "`", "`", "'", "'", "characterEncoding=UTF-8&connectTimeout=5000&useSSL=false&allowPublicKeyRetrieval=true", true, null, null, true),
    sqlServer("sqlServer", "SQL Server", "\"", "\"", "\"", "\"", "", true, null, null, true),
    oracle("oracle", "Oracle", "\"", "\"", "\"", "\"", "", true, Arrays.asList("Default", "GBK", "BIG5", "ISO-8859-1", "UTF-8", "UTF-16", "CP850", "EUC_JP", "EUC_KR"), Arrays.asList("Default", "GBK", "UTF-8"), true);

    private String type;
    private String name;
    private String keywordPrefix;
    private String keywordSuffix;
    private String aliasPrefix;
    private String aliasSuffix;
    private String extraParams;
    private boolean isDatasource;
    private boolean isJdbc;
    private List<String> charset;
    private List<String> targetCharset;

    private DataSourceTypeEnum(String type, String name, String keywordPrefix, String keywordSuffix, String aliasPrefix, String aliasSuffix, String extraParams, boolean isDatasource, List<String> charset, List<String> targetCharset, boolean isJdbc) {
        this.type = type;
        this.name = name;
        this.keywordPrefix = keywordPrefix;
        this.keywordSuffix = keywordSuffix;
        this.aliasPrefix = aliasPrefix;
        this.aliasSuffix = aliasSuffix;
        this.extraParams = extraParams;
        this.isDatasource = isDatasource;
        this.charset = charset;
        this.targetCharset = targetCharset;
        this.isJdbc = isJdbc;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getKeywordPrefix() {
        return this.keywordPrefix;
    }

    public String getKeywordSuffix() {
        return this.keywordSuffix;
    }

    public String getAliasPrefix() {
        return this.aliasPrefix;
    }

    public String getAliasSuffix() {
        return this.aliasSuffix;
    }

    public String getExtraParams() {
        return this.extraParams;
    }

    public List<String> getCharset() {
        return this.charset;
    }

    public List<String> getTargetCharset() {
        return this.targetCharset;
    }

    public boolean isDatasource() {
        return this.isDatasource;
    }

    public boolean isJdbc() {
        return this.isJdbc;
    }

    public static String getKeywordPrefixByType(String type) {
        for (DataSourceTypeEnum datasource : DataSourceTypeEnum.values()) {
            if (!datasource.name().equalsIgnoreCase(type)) continue;
            return datasource.getKeywordPrefix();
        }
        return null;
    }
}

