/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.core.util;

import com.digiwin.dcc.core.util.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();

    private JSONUtils() {
    }

    public static String toJson(Object object) {
        try {
            return gson.toJson(object);
        }
        catch (Exception e) {
            logger.error("object to json exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (T)gson.fromJson(json, clazz);
        }
        catch (Exception e) {
            logger.error("parse object exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        if (src == null) {
            return null;
        }
        String json = new String(src, StandardCharsets.UTF_8);
        return JSONUtils.parseObject(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return new ArrayList();
        }
        try {
            Type type = TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType();
            return (List)gson.fromJson(json, type);
        }
        catch (Exception e) {
            logger.error("JSONArray.parseArray exception!", (Throwable)e);
            return new ArrayList();
        }
    }

    public static Map<String, Object> toMap(String json) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (Map)gson.fromJson(json, Map.class);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> classK, Class<V> classV) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            Type type = new TypeToken<Map<K, V>>(){}.getType();
            return (Map)gson.fromJson(json, type);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static JsonObject parseObject(String text) {
        try {
            return (JsonObject)gson.fromJson(text, JsonObject.class);
        }
        catch (Exception e) {
            throw new RuntimeException("String json deserialization exception.", e);
        }
    }

    public static JsonArray parseArray(String text) {
        try {
            return (JsonArray)gson.fromJson(text, JsonArray.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    private static class LocalDateTimeAdapter
    implements JsonDeserializer<LocalDateTime>,
    JsonSerializer<LocalDateTime> {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        private LocalDateTimeAdapter() {
        }

        public LocalDateTime deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return LocalDateTime.parse(json.getAsString(), dateTimeFormatter.withZone(ZoneId.systemDefault()));
        }

        public JsonElement serialize(LocalDateTime src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(dateTimeFormatter.format(src));
        }
    }
}

