/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.dto.OPSMergeConfig;
import com.digiwin.apphub.tool.merge.MergeProcessor;
import com.digiwin.apphub.tool.merge.adjust.AdjustProcessor;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.pipeline.PipelineDescriptor;
import com.digiwin.apphub.tool.pipeline.PipelineDescriptorLoader;
import com.digiwin.apphub.tool.pipeline.PipelineExecutor;
import com.digiwin.apphub.tool.setting.ToolSettingProviderFactory;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.spi.ToolServiceLoader;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeToolLauncher {
    public static Logger logger = LoggerFactory.getLogger(MergeToolLauncher.class);

    public static void main(String[] args) throws Exception {
        int exitCode = 0;
        try {
            MergeToolLauncher.printBanner();
            AppMergeContext context = MergeToolLauncher.getDefaultAppMergeContext();
            PipelineDescriptor descriptor = PipelineDescriptorLoader.loadFromYaml(context);
            MergeToolLauncher.initializeInstances(context, descriptor);
            PipelineExecutor executor = new PipelineExecutor(context.getServiceLoader(), descriptor);
            executor.execute(context);
        }
        catch (Exception e) {
            exitCode = 1;
            logger.error("Unexpected Exception Occurred!", e);
        }
        System.exit(exitCode);
    }

    private static AppMergeContext getDefaultAppMergeContext() throws Exception {
        String workingFolder = ToolConstants.getWorkingFolderPath();
        String makeConfigFileName = ToolConstants.getMakeConfigFileName();
        if (makeConfigFileName == null || makeConfigFileName.isBlank()) {
            throw new IllegalArgumentException("makeConfigFileName can not be null or blank!");
        }
        if (Paths.get(makeConfigFileName, new String[0]).isAbsolute()) {
            throw new IllegalArgumentException("makeConfigFileName should not be absolute path: " + makeConfigFileName);
        }
        String makeConfigFileNameUnderWorkingFolder = Paths.get(workingFolder, makeConfigFileName).toString();
        LogBlockPrinter.printCaption("Startup Arguments:", new Object[0]);
        String profile = ToolConstants.getProfile();
        LogBlockPrinter.printContent("profile = ", profile);
        LogBlockPrinter.printContent("working folder = {}", workingFolder);
        LogBlockPrinter.printContent("make config file = {}", makeConfigFileNameUnderWorkingFolder);
        OPSMergeConfig opsMergeConfig = OPSMergeConfig.load(makeConfigFileNameUnderWorkingFolder);
        AppMergeContext context = new AppMergeContext(workingFolder, opsMergeConfig);
        Path settingPath = Paths.get(workingFolder, "settings", "dap-app-hub-setting.yaml");
        LogBlockPrinter.printContent("setting file = {}", settingPath);
        ToolSettingResolver settingProvider = ToolSettingProviderFactory.create(settingPath);
        context.setSettingProvider(settingProvider);
        LogBlockPrinter.printContent(2, null, "resolver = {}", settingProvider.getClass().getName());
        LogBlockPrinter.printContent("output folder = {}", context.getOutputPath());
        LogBlockPrinter.printContent("merged app folder = {}", context.getMergedAppPathManager().getPath());
        return context;
    }

    public static void printBanner() {
        LogBlockPrinter.printBanner();
    }

    public static void initializeInstances(AppMergeContext context, PipelineDescriptor descriptor) {
        ToolServiceLoader toolServiceLoader = new ToolServiceLoader(context.getSettingProvider());
        context.setServiceLoader(toolServiceLoader);
        toolServiceLoader.load(PropertyMergeStrategy.class, mergeStrategy -> " | name=" + mergeStrategy.getName());
        toolServiceLoader.load(MergeableFileHandler.class, handler -> " | patterns=" + handler.handlePatterns().toString());
        toolServiceLoader.load(MergeProcessor.class);
        toolServiceLoader.load(ValidationProcessor.class);
        toolServiceLoader.load(AdjustProcessor.class);
        toolServiceLoader.load(PipelineAction.class);
    }
}

