/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool;

import com.digiwin.apphub.tool.dto.OPSAppSourceConfig;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.SourceType;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ToolConstants {
    public static final String VM_ARG_WORKING_FOLDER_PATH = "working.folder";
    public static final String VM_ARG_MAKE_CONFIG_FILE_NAME = "make.config.file";
    public static final String VM_ARG_PIPELINE_DESCRIPTOR_FILE_NAME = "pipeline.descriptor.file";
    public static final String VM_ARG_PIPELINE = "profile";
    public static final String FOLDER_DOWNLOAD = "download";
    public static final String FOLDER_SETTINGS = "settings";
    public static final String FOLDER_RUNTIME = "runtime";
    public static final String FOLDER_OUTPUT = "output";
    public static final String DEFAULT_MERGED_APP_NAME = "dap-merged-app";
    public static final String DEFAULT_SETTING_FILE_NAME = "dap-app-hub-setting.yaml";
    private static boolean useEmoji = Boolean.parseBoolean(System.getProperty("use.emoji", "true"));

    public static String getWorkingFolderPath() {
        String workingFolderPath = System.getProperty(VM_ARG_WORKING_FOLDER_PATH);
        if (workingFolderPath == null || workingFolderPath.isBlank()) {
            return System.getProperty("user.dir");
        }
        return workingFolderPath;
    }

    public static AppSource getRuntimeTemplate() {
        OPSAppSourceConfig templateOPSConfig = new OPSAppSourceConfig();
        templateOPSConfig.setDeploymentName(FOLDER_RUNTIME);
        templateOPSConfig.setVersion("1.0.0");
        Path runtimePath = Paths.get(ToolConstants.getWorkingFolderPath(), FOLDER_RUNTIME);
        AppSource appSource = new AppSource(templateOPSConfig, runtimePath, SourceType.DAP_SIMPLIFIED);
        return appSource;
    }

    public static Path getRuntimeTemplatePath() {
        return Paths.get(ToolConstants.getWorkingFolderPath(), FOLDER_RUNTIME);
    }

    public static String getMakeConfigFileName() {
        return System.getProperty(VM_ARG_MAKE_CONFIG_FILE_NAME);
    }

    public static boolean useEmoji() {
        return useEmoji;
    }

    public static String getSequenceKey(Object user, String ... subKeys) {
        StringBuilder keyBuilder = new StringBuilder(user.getClass().getSimpleName());
        if (subKeys != null) {
            for (String subKey : subKeys) {
                keyBuilder.append("-").append(subKey);
            }
        }
        keyBuilder.append("-process-seq");
        return keyBuilder.toString();
    }

    public static String getProfile() {
        String profile = System.getProperty(VM_ARG_PIPELINE);
        return profile == null ? "" : profile;
    }

    public static String getFileNameWithProfile(String fileName) {
        String extension;
        String baseName;
        String profile = ToolConstants.getProfile();
        if (profile == null || profile.isEmpty()) {
            return fileName;
        }
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
            baseName = fileName.substring(0, dotIndex);
            extension = fileName.substring(dotIndex);
        } else {
            baseName = fileName;
            extension = "";
        }
        return String.format("%s-%s%s", baseName, profile, extension);
    }
}

