/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.action;

import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.dto.OPSAppSourceConfig;
import com.digiwin.apphub.tool.exception.PipelineActionFailedException;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.SourceType;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.utils.SourceTypeResolver;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={PipelineAction.class})
public class DownloadAppSourceAction
implements PipelineAction {
    private static Logger logger = LoggerFactory.getLogger(DownloadAppSourceAction.class);

    @Override
    public void execute(AppMergeContext context) {
        List<OPSAppSourceConfig> apps = context.getOPSMergeConfig().getApps();
        Path targetDir = context.getWorkingFolder().resolve("download");
        ArrayList<AppSource> appSourceList = new ArrayList<AppSource>();
        for (OPSAppSourceConfig opsAppSourceConfig : apps) {
            try {
                File appSourceFile = DownloadAppSourceAction.downloadWithProgress(context, opsAppSourceConfig, targetDir);
                AppSource appSource = this.decompressAppSourceFile(context, opsAppSourceConfig, appSourceFile);
                appSourceList.add(appSource);
            }
            catch (Exception e) {
                logger.info("X [Failed] " + opsAppSourceConfig.getDeploymentName() + " download failed: " + e.getMessage());
                throw new PipelineActionFailedException("download failed!", e);
            }
        }
        context.setAppSources(appSourceList);
        List unknownTypeList = appSourceList.stream().filter(source -> source.getSourceType() == SourceType.UNKNOWN).collect(Collectors.toUnmodifiableList());
        if (unknownTypeList.size() > 0) {
            String message = unknownTypeList.stream().map(source -> {
                int index = appSourceList.indexOf(source) + 1;
                return index + "." + source.getDeploymentName();
            }).collect(Collectors.joining(", "));
            context.exitPipeline("unknown source type app exists: " + message);
        }
    }

    private AppSource decompressAppSourceFile(AppMergeContext context, OPSAppSourceConfig opsAppSourceConfig, File downloadedFile) {
        String name = opsAppSourceConfig.getDeploymentName();
        boolean decompress = true;
        Path targetDir = context.getWorkingFolder().resolve("download").resolve(name);
        if (Files.isDirectory(targetDir, new LinkOption[0])) {
            if (context.isDryRun()) {
                decompress = false;
                LogBlockPrinter.printGroupScopeDryRunContent("Skip decompress, folder already exists: {}", targetDir.getFileName());
            } else {
                LogBlockPrinter.printGroupScopeDryRunContent("Remove existing folder before decompress: {}", targetDir.getFileName());
                try {
                    FileUtils.deleteDirectory(targetDir.toFile());
                }
                catch (IOException e) {
                    throw new PipelineActionFailedException("Failed to delete existing folder: " + String.valueOf(targetDir), e);
                }
            }
        }
        if (decompress) {
            logger.info("  \u2502 O [Decompress] {} \u2192 {}", (Object)downloadedFile.getName(), (Object)targetDir.getFileName());
            try (ZipFile zip = new ZipFile(downloadedFile);){
                zip.extractAll(targetDir.toAbsolutePath().toString());
                logger.info("  \u2502 \u2714 Decompressed to folder: {}", (Object)targetDir.toAbsolutePath());
            }
            catch (IOException e) {
                throw new PipelineActionFailedException("Decompress failed: " + downloadedFile.getName(), e);
            }
        }
        SourceType sourceType = this.identifyAppSourceType(targetDir.toFile());
        logger.info("  \u2502 \u25ce [Source Type] ---> {}", (Object)sourceType);
        return new AppSource(opsAppSourceConfig, targetDir, sourceType);
    }

    private SourceType identifyAppSourceType(File appSourceFolder) {
        return SourceTypeResolver.resolve(appSourceFolder);
    }

    public static File downloadWithProgress(AppMergeContext context, OPSAppSourceConfig opsAppSourceConfig, Path outputPath) throws IOException {
        String name = opsAppSourceConfig.getDeploymentName();
        String registryUrl = opsAppSourceConfig.getRegistryUrl();
        String version = opsAppSourceConfig.getVersion();
        String warFileName = name + ".war";
        String warUrl = registryUrl + "/" + version + "/" + warFileName;
        Path downloadFilePath = outputPath.resolve(warFileName);
        LogBlockPrinter.printGroupStartContent("[Download] App: {} | Version: {}", name, version);
        LogBlockPrinter.printGroupScopeContent(null, "[URL] {}", warUrl);
        if (context.isDryRun()) {
            Path decompressedFolder = outputPath.resolve(name);
            if (Files.exists(downloadFilePath, new LinkOption[0])) {
                long size = Files.size(downloadFilePath);
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "[Dry Run] Found existing file: {} | Size: {} MB", downloadFilePath.getFileName(), String.format("%.2f", (double)size / 1024.0 / 1024.0));
                return downloadFilePath.toFile();
            }
            if (Files.exists(decompressedFolder, new LinkOption[0])) {
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "[Dry Run] WAR not found, but decompressed folder exists: {}", decompressedFolder.getFileName());
                return decompressedFolder.toFile();
            }
            LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "[Dry Run] Simulate download: {}", decompressedFolder.getFileName());
            return null;
        }
        URL url = new URL(warUrl);
        HttpURLConnection headConn = (HttpURLConnection)new URL(warUrl).openConnection();
        headConn.setRequestMethod("HEAD");
        int contentLength = headConn.getContentLength();
        headConn.disconnect();
        if (contentLength > 0) {
            logger.info(String.format("  \u2502 O [Size] %s: %.2f MB", warFileName, (double)contentLength / 1024.0 / 1024.0));
        } else {
            logger.info("  \u2502 X [Size] Unknown content length for: " + warFileName);
        }
        HttpURLConnection getConn = (HttpURLConnection)new URL(warUrl).openConnection();
        getConn.setRequestMethod("GET");
        Files.createDirectories(downloadFilePath.getParent(), new FileAttribute[0]);
        try (InputStream in = getConn.getInputStream();
             FileOutputStream out = new FileOutputStream(downloadFilePath.toFile());){
            int bytesRead;
            byte[] buffer = new byte[8192];
            long totalRead = 0L;
            long lastPrint = 0L;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                int percent = (int)((totalRead += (long)bytesRead) * 100L / (long)contentLength);
                if ((long)percent == lastPrint) continue;
                System.out.printf("\r[Progress] %s: %d%%", downloadFilePath.getFileName(), percent);
                lastPrint = percent;
            }
            System.out.println("\nO [Success] " + String.valueOf(downloadFilePath.getFileName()) + " downloaded");
        }
        return downloadFilePath.toFile();
    }

    private void identifyAppSource() {
    }
}

