/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.action;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.MergeProcessor;
import com.digiwin.apphub.tool.merge.MergeResult;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={PipelineAction.class})
public class MergeAppSourceAction
implements PipelineAction {
    private static final Logger logger = LoggerFactory.getLogger(MergeAppSourceAction.class);
    private List<MergeProcessor<?>> mergeProcessorList = Collections.emptyList();

    @Inject
    public void setProcessor(List<MergeProcessor<?>> processorList) {
        this.mergeProcessorList = processorList;
    }

    @Override
    public void execute(AppMergeContext context) throws Exception {
        for (MergeProcessor<?> processor : this.mergeProcessorList) {
            int seq = context.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, "mergeProcessor"));
            LogBlockPrinter.printSession(String.format("%02d.Executing processor: %s (%s)", seq, processor.getClass().getName(), processor.getDisplayName()), "Processor finished", context, () -> {
                MergeResult result = processor.execute(context);
                if (result != null && result.isFailure()) {
                    context.exitPipeline(result.message());
                }
            });
        }
    }
}

