/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.context;

import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.dto.OPSMergeConfig;
import com.digiwin.apphub.tool.exception.PipelineActionExitException;
import com.digiwin.apphub.tool.merge.MergedAppPathManager;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.MergeCategory;
import com.digiwin.apphub.tool.pipeline.PipelineStep;
import com.digiwin.apphub.tool.pipeline.PipelineStepMode;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.spi.ToolServiceLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class AppMergeContext
implements PrinterContext {
    private ToolServiceLoader serviceLoader;
    private ToolSettingResolver settingProvider;
    private OPSMergeConfig opsMergeConfig;
    private PipelineStep currentStep;
    private Path workingFolder;
    private Path outputPath;
    private MergedAppPathManager mergedAppPathManager;
    private MergeCategory mergeCategory;
    private Map<String, Object> data = new HashMap<String, Object>();
    private List<AppSource> appSourceList = Collections.emptyList();

    public AppMergeContext(String workingFolderPath, OPSMergeConfig opsMergeConfig) {
        if (workingFolderPath == null || workingFolderPath.isBlank()) {
            throw new IllegalArgumentException("workingFolderPath can not be null or blank!");
        }
        this.workingFolder = Paths.get(workingFolderPath, new String[0]);
        this.opsMergeConfig = opsMergeConfig;
        this.outputPath = Paths.get(workingFolderPath, "output");
        this.mergedAppPathManager = new MergedAppPathManager(this.outputPath.resolve("dap-merged-app"));
    }

    public ToolSettingResolver getSettingProvider() {
        return this.settingProvider;
    }

    public void setSettingProvider(ToolSettingResolver settingProvider) {
        this.settingProvider = settingProvider;
    }

    public Path getWorkingFolder() {
        return this.workingFolder;
    }

    public MergedAppPathManager getMergedAppPathManager() {
        return this.mergedAppPathManager;
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public OPSMergeConfig getOPSMergeConfig() {
        return this.opsMergeConfig;
    }

    public PipelineStep getCurrentStep() {
        return this.currentStep;
    }

    public PipelineStepMode getCurrentStepMode() {
        if (this.currentStep == null) {
            return PipelineStepMode.NORMAL;
        }
        return this.currentStep.getMode();
    }

    public void setCurrentStep(PipelineStep currentStep) {
        this.currentStep = currentStep;
    }

    public void setAppSources(List<AppSource> appSourceList) {
        this.appSourceList = this.appSourceList == null ? Collections.emptyList() : appSourceList;
    }

    public List<AppSource> getAppSourceList() {
        return Collections.unmodifiableList(this.appSourceList);
    }

    public ToolServiceLoader getServiceLoader() {
        return this.serviceLoader;
    }

    public void setServiceLoader(ToolServiceLoader serviceLoader) {
        this.serviceLoader = serviceLoader;
    }

    public MergeCategory getMergeCategory() {
        return this.mergeCategory;
    }

    public void setMergeCategory(MergeCategory mergeCategory) {
        this.mergeCategory = mergeCategory;
    }

    public <T> T get(String key) {
        return (T)this.data.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        if (this.data.containsKey(key)) {
            return this.get(key);
        }
        return defaultValue;
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    public int incrementSequenceAndGet(String processKey) {
        int currentSeq = this.get(processKey, 0);
        int nextSeq = ++currentSeq;
        this.put(processKey, nextSeq);
        return nextSeq;
    }

    public void remove(String key) {
        this.data.remove(key);
    }

    public boolean isDryRun() {
        return this.getCurrentStepMode() == PipelineStepMode.DRY_RUN;
    }

    public void exitPipeline(String reason) throws PipelineActionExitException {
        throw new PipelineActionExitException(this, reason);
    }

    public <T> T computeIfAbsent(String key, Function<String, Object> mappingFunction) {
        return (T)this.data.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public int getLevel() {
        return this.get("level", 0);
    }

    @Override
    public int enterSession() {
        int currentLevel = this.getLevel();
        this.put("level", ++currentLevel);
        return currentLevel;
    }

    @Override
    public int exitSession() {
        int currentLevel = this.getLevel();
        this.put("level", --currentLevel);
        return currentLevel;
    }
}

