/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.metadata.AppSource;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppSourcePathManager {
    public static final String TYPE_APPLICATION_PROPERTIES_PARENT = "application.properties-folder";
    public static final String TYPE_CONFIG = "conf";
    public static final String TYPE_LIBRARY = "lib";
    private final Map<String, List<NamedPath>> pathMap = new HashMap<String, List<NamedPath>>();
    private final AppSource appSource;
    private NamedPath applicationPropertiesFolder = null;

    public AppSourcePathManager(AppSource appSource) {
        this.appSource = appSource;
    }

    public AppSource getAppSource() {
        return this.appSource;
    }

    public Path getPath() {
        return this.appSource.getPath();
    }

    public NamedPath addConfigPath(String name, String relativePath) {
        return this.addConfigPath(name, relativePath, false);
    }

    public NamedPath addConfigPath(String name, String relativePath, boolean isPrimaryApplicationPropertiesFolder) {
        NamedPath path = this.addPath(TYPE_CONFIG, name, relativePath);
        if (isPrimaryApplicationPropertiesFolder) {
            this.applicationPropertiesFolder = path;
        }
        return path;
    }

    public NamedPath addLibraryPath(String name, String relativePath) {
        return this.addPath(TYPE_LIBRARY, name, relativePath);
    }

    public NamedPath addPath(String type, String name, String relativePath) {
        Path resolved = this.resolveRelative(relativePath);
        NamedPath path = new NamedPath(type, name, resolved);
        this.pathMap.computeIfAbsent(type, key -> new ArrayList()).add(path);
        return path;
    }

    private Path resolveRelative(String relativePath) {
        if (Paths.get(relativePath, new String[0]).isAbsolute()) {
            throw new IllegalArgumentException("relativePath can not be absolute: " + relativePath);
        }
        return this.getPath().resolve(Paths.get(relativePath.replace("\\", "/"), new String[0]));
    }

    public List<NamedPath> getConfigPaths() {
        return this.getPaths(TYPE_CONFIG);
    }

    public List<NamedPath> getLibraryPaths() {
        return this.getPaths(TYPE_LIBRARY);
    }

    public NamedPath getLibraryPath(String usageName) {
        return this.getPath(TYPE_LIBRARY, usageName);
    }

    public NamedPath getConfigPath(String usageName) {
        return this.getPath(TYPE_CONFIG, usageName);
    }

    public NamedPath getPath(String type, String usageName) {
        return this.pathMap.getOrDefault(type, List.of()).stream().filter(p -> p.getName().equalsIgnoreCase(usageName)).findFirst().orElse(null);
    }

    public List<NamedPath> getPaths(String type) {
        return this.pathMap.getOrDefault(type, List.of());
    }

    public File getApplicationPropertiesFile() {
        return this.applicationPropertiesFolder.getPath().resolve("application.properties").toFile();
    }
}

