/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.merge.DAPAppSourcePathManager;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.metadata.AppSource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DAPModularAppSourcePathManager
extends DAPAppSourcePathManager {
    public static String USAGE_NAME_APPLICATION_MODULE = "application-module";
    public static String USAGE_NAME_PLATFORM_MODULE = "platform-module";

    public DAPModularAppSourcePathManager(AppSource appSource) {
        super(appSource);
        this.addConfigPath("platform-conf", "platform/conf");
        this.addConfigPath("platform-lang", "platform/lang");
        this.addLibraryPath("platform-lib", "platform/lib");
        this.addConfigPath("application-conf", "application/conf", true);
        this.addConfigPath("application-lang", "application/lang");
        this.addLibraryPath("application-lib", "application/lib");
        this.addPath(TYPE_SERVICE_GROUP, USAGE_NAME_APPLICATION_MODULE, "application/module");
        this.addPath(TYPE_SERVICE_GROUP, USAGE_NAME_PLATFORM_MODULE, "platform/module");
    }

    @Override
    public Map<String, List<FileSource>> getServiceGroupFileList() {
        HashMap<String, List<FileSource>> groupFileList = new HashMap<String, List<FileSource>>();
        List<NamedPath> paths = this.getServiceGroupPaths();
        for (NamedPath namedPath : paths) {
            try {
                Stream<Path> stream = Files.list(namedPath.getPath());
                try {
                    Map namedPathList = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> new FileSource(this.getAppSource(), namedPath, (Path)path)).collect(Collectors.groupingBy(FileSource::getSourceFileName, LinkedHashMap::new, Collectors.toList()));
                    for (Map.Entry entry : namedPathList.entrySet()) {
                        groupFileList.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to list service groups under: " + String.valueOf(namedPath.getPath()), e);
            }
        }
        return groupFileList;
    }
}

