/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.merge.DAPAppSourcePathManager;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.merge.handler.DAPServiceGroupFileSource;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DAPSimplifiedAppSourcePathManager
extends DAPAppSourcePathManager {
    public static final String DAP_INFO_KEY_GROUP_NAME = "group.name";
    public static final String USAGE_NAME_SERVICE_GROUP = "service-group";
    public static final String RESOURCE_LOCATION_DAP_INFO = "META-INF/dap.info";

    public DAPSimplifiedAppSourcePathManager(AppSource appSource) {
        super(appSource);
        this.addConfigPath("conf", "conf", true);
        this.addConfigPath("lan", "lang");
        this.addLibraryPath("lib", "lib");
        this.addPath(TYPE_SERVICE_GROUP, USAGE_NAME_SERVICE_GROUP, "lib");
    }

    @Override
    public Map<String, List<FileSource>> getServiceGroupFileList() {
        Map map;
        block8: {
            NamedPath applicationModuleNamedPath = this.getServiceGroupPath(USAGE_NAME_SERVICE_GROUP);
            Stream<Path> stream = Files.list(applicationModuleNamedPath.getPath());
            try {
                map = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".jar")).map(jarFilePath -> this.resolveServiceGroupFileSource(applicationModuleNamedPath, (Path)jarFilePath)).filter(Objects::nonNull).collect(Collectors.groupingBy(DAPServiceGroupFileSource::getGroupName, LinkedHashMap::new, Collectors.toList()));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LogBlockPrinter.printContent(LogBlockIcon.ERROR, "search service group in {} failed, reason={}", applicationModuleNamedPath.getPath(), e.getMessage());
                    return Collections.emptyMap();
                }
            }
            stream.close();
        }
        return map;
    }

    private DAPServiceGroupFileSource resolveServiceGroupFileSource(NamedPath moduleNamedPath, Path jarFilePath) {
        String groupName;
        DAPServiceGroupFileSource fileSource = null;
        Properties dapInfo = this.tryExtractDapInfo(jarFilePath);
        if (dapInfo != null && (groupName = dapInfo.getProperty(DAP_INFO_KEY_GROUP_NAME)) != null && !groupName.isBlank()) {
            fileSource = new DAPServiceGroupFileSource(this.getAppSource(), moduleNamedPath, jarFilePath, dapInfo);
        }
        return fileSource;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Properties tryExtractDapInfo(Path jarFilePath) {
        block16: {
            try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
                Properties properties;
                block17: {
                    JarEntry entry = jarFile.getJarEntry(RESOURCE_LOCATION_DAP_INFO);
                    if (entry == null) break block16;
                    Properties dapInfo = new Properties();
                    InputStream is = jarFile.getInputStream(entry);
                    try {
                        dapInfo.load(is);
                        properties = dapInfo;
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LogBlockPrinter.printContent(LogBlockIcon.ERROR, "foud dap.ino in jar:{}, but load it failed, reason={}", jarFilePath, e.getMessage());
                            break block16;
                        }
                    }
                    is.close();
                }
                return properties;
            }
            catch (Exception e) {
                LogBlockPrinter.printContent(LogBlockIcon.ERROR, "parse jar:{} failed, reason={}", FileSource.getRelativeAppPathDisplayName(this.getAppSource(), jarFilePath), e.getMessage());
            }
        }
        return null;
    }
}

