/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.inject.InjectSetting;
import com.digiwin.apphub.tool.merge.AppSourcePathManager;
import com.digiwin.apphub.tool.merge.GeneralMergeAnalysisReport;
import com.digiwin.apphub.tool.merge.MergeProcessor;
import com.digiwin.apphub.tool.merge.MergeResult;
import com.digiwin.apphub.tool.merge.MergedAppPathManager;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.merge.SourceTypePathManagerFactory;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.setting.dto.CustomNameVerMapping;
import com.digiwin.apphub.tool.setting.dto.LibChecking;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@AutoService(value={MergeProcessor.class, ValidationProcessor.class})
public class LibraryMergeProcessor
implements MergeProcessor<GeneralMergeAnalysisReport>,
ValidationProcessor {
    public static final String CONFIG_KEY_LIB_COPYING_INCLUDE_SUB_DIR = "merge.libCopying.includeSubDir";
    private static final Pattern JAR_PATTERN = Pattern.compile("^(.+?)-(\\d+(?:\\.\\d+)*[\\.\\w-]*)\\.jar$");
    @InjectSetting(key="validation.libChecking")
    private LibChecking config;
    @InjectSetting(key="merge.libCopying.includeSubDir")
    private boolean test;

    @Override
    public String getDisplayName() {
        return "Merge App Source Library";
    }

    @Override
    public void validate(AppMergeContext context) {
        HashMap libGroupMap = new HashMap();
        for (AppSource appSource : context.getAppSourceList()) {
            AppSourcePathManager pathManager = SourceTypePathManagerFactory.get(appSource, context.getMergeCategory());
            for (NamedPath namedPath : pathManager.getLibraryPaths()) {
                String usageName = namedPath.getName();
                Path libDir = namedPath.getPath();
                if (!Files.isDirectory(libDir, new LinkOption[0])) continue;
                try {
                    Stream<Path> jarFiles = Files.list(libDir).filter(p -> p.toString().endsWith(".jar"));
                    try {
                        jarFiles.forEach(jar -> {
                            String version;
                            String jarName;
                            String fileName = jar.getFileName().toString();
                            if (this.config.isExclude(fileName)) {
                                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "Excluded jar in [{}] of [{}]: {}", usageName, appSource.getDeploymentName(), fileName);
                                return;
                            }
                            CustomNameVerMapping customNameVerMapping = this.config.getCustomJarInfo(fileName);
                            if (customNameVerMapping == null) {
                                Matcher matcher = JAR_PATTERN.matcher(fileName);
                                if (!matcher.matches()) {
                                    LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "Unrecognized jar format in [{}] of [{}]: {}", usageName, appSource.getDeploymentName(), fileName);
                                    return;
                                }
                                jarName = matcher.group(1);
                                version = matcher.group(2);
                            } else {
                                jarName = customNameVerMapping.getJarName();
                                version = customNameVerMapping.getVersion();
                                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "Custom mapping info jar in [{}] of [{}]: {} -> name:{} | version: {}", usageName, appSource.getDeploymentName(), fileName, jarName, version);
                            }
                            String relative = appSource.getPath().relativize((Path)jar).toString().replace("\\", "/");
                            String display = "[" + appSource.getDeploymentName() + "]/" + relative;
                            libGroupMap.computeIfAbsent(usageName, k -> new HashMap()).computeIfAbsent(jarName, k -> new HashMap()).computeIfAbsent(version, k -> new HashSet()).add(display);
                        });
                    }
                    finally {
                        if (jarFiles == null) continue;
                        jarFiles.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to scan lib path: " + String.valueOf(libDir), e);
                }
            }
        }
        ArrayList<JarConflict> conflicts = new ArrayList<JarConflict>();
        for (Map.Entry libEntry : libGroupMap.entrySet()) {
            String usageName = (String)libEntry.getKey();
            Map jarMap = (Map)libEntry.getValue();
            for (Map.Entry jarEntry : jarMap.entrySet()) {
                String jarName = (String)jarEntry.getKey();
                Map versionMap = (Map)jarEntry.getValue();
                if (versionMap.size() <= 1) continue;
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.ERROR, "Conflict in [{}]: [{}] jar multiple version: {}", usageName, jarName, versionMap.keySet());
                versionMap.forEach((ver, sources) -> LogBlockPrinter.printGroupScopeContent(null, "  - {}: {}", ver, sources));
                conflicts.add(new JarConflict(usageName, jarName, versionMap));
            }
        }
        if (!conflicts.isEmpty()) {
            if (context.isDryRun()) {
                LogBlockPrinter.printGroupScopeDryRunWithNoExitContent("The same jar exists in multiple versions across libraries!", new Object[0]);
            } else {
                context.exitPipeline("The same jar exists in multiple versions across libraries!");
            }
        } else {
            LogBlockPrinter.printGroupScopeContent(LogBlockIcon.CHECK, "Libraries version check passed - no conflicts found.", new Object[0]);
        }
    }

    @Override
    public MergeResult<GeneralMergeAnalysisReport> execute(AppMergeContext context) throws Exception {
        boolean recursive = context.getSettingProvider().getOrDefault(Boolean.class, CONFIG_KEY_LIB_COPYING_INCLUDE_SUB_DIR, true);
        LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.INFO, "Config-Allow recursive copying({}): {}", CONFIG_KEY_LIB_COPYING_INCLUDE_SUB_DIR, recursive);
        MergedAppPathManager targetPathManager = context.getMergedAppPathManager();
        for (AppSource appSource : context.getAppSourceList()) {
            AppSourcePathManager sourcePathManager = SourceTypePathManagerFactory.get(appSource, context.getMergeCategory());
            LogBlockPrinter.printSession(String.format("%02d.Merge [%s] library...", context.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, "app", "lib")), appSource.getDeploymentName()), null, context, () -> {
                List<NamedPath> libList = sourcePathManager.getLibraryPaths();
                for (NamedPath namedSourcePath : libList) {
                    Path sourcePath = namedSourcePath.getPath();
                    NamedPath namedTargetPath = targetPathManager.getLibraryPath(namedSourcePath.getName());
                    if (namedTargetPath == null) {
                        throw new IllegalArgumentException(String.format("Can not find mapping output path! usage name=%s | source=%s", namedSourcePath.getName(), sourcePath));
                    }
                    Path targetPath = namedTargetPath.getPath();
                    this.copyFolder(context, appSource, sourcePath, targetPath, recursive);
                }
            });
        }
        return null;
    }

    private void copyFolder(AppMergeContext context, AppSource appSource, Path sourcePath, Path targetPath, boolean recursive) throws Exception {
        Files.createDirectories(targetPath, new FileAttribute[0]);
        int copiedCount = 0;
        int skippedCount = 0;
        try (Stream<Path> entries = Files.list(sourcePath);){
            for (Path entry : entries.toList()) {
                if (Files.isRegularFile(entry, new LinkOption[0])) {
                    Path targetEntry = targetPath.resolve(entry.getFileName());
                    if (Files.exists(targetEntry, new LinkOption[0])) {
                        ++skippedCount;
                        continue;
                    }
                    Files.copy(entry, targetEntry, new CopyOption[0]);
                    ++copiedCount;
                    continue;
                }
                if (!recursive) continue;
                this.copyFolder(context, appSource, entry, targetPath.resolve(entry.getFileName()), true);
            }
        }
        String relativeDisplayPath = FileSource.getRelativeAppPathDisplayName(appSource, sourcePath, false);
        LogBlockPrinter.printContent((PrinterContext)context, "{} file(s) copied from {}", copiedCount, relativeDisplayPath);
        if (skippedCount > 0) {
            LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.NOTICE, "{} file(s) skipped!(already exists) from {}", skippedCount, relativeDisplayPath);
        }
    }

    private static class JarConflict {
        private final String usageName;
        private final String jarName;
        private final Map<String, Set<String>> versionMap;

        public JarConflict(String usageName, String jarName, Map<String, Set<String>> versionMap) {
            this.usageName = usageName;
            this.jarName = jarName;
            this.versionMap = versionMap;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%s [%s] %s has multiple versions: %s%n", new Object[]{LogBlockIcon.ERROR, this.usageName, this.jarName, this.versionMap.keySet()}));
            this.versionMap.forEach((ver, sources) -> sb.append(String.format("  - %s: %s%n", ver, sources)));
            return sb.toString();
        }
    }
}

