/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.adjust;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.inject.InjectSetting;
import com.digiwin.apphub.tool.merge.adjust.AdjustProcessor;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

@AutoService(value={AdjustProcessor.class})
public class CopyFromRuntimeFolderAdjustProcessor
implements AdjustProcessor {
    @InjectSetting(key="adjust.copyFromRuntimeTemplate")
    private List<String> copyFileList;

    @Override
    public String getDisplayName() {
        return "Adjust application.properties";
    }

    @Override
    public void adjust(AppMergeContext context) throws Exception {
        Path runtimePath = context.getWorkingFolder().resolve("runtime");
        AtomicInteger totalFileCount = new AtomicInteger();
        AtomicInteger totalFolderCount = new AtomicInteger();
        for (String pattern : this.copyFileList) {
            LogBlockPrinter.printSession(String.format("process copy pattern: %s", pattern), null, context, () -> {
                AtomicInteger copyFileCount = new AtomicInteger();
                AtomicInteger createFolderCount = new AtomicInteger();
                String cleanPattern = pattern.startsWith("/") ? pattern.substring(1) : pattern;
                PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + cleanPattern);
                try (Stream<Path> paths = Files.walk(runtimePath, new FileVisitOption[0]);){
                    paths.forEach(path -> {
                        Path rel = runtimePath.relativize((Path)path);
                        if (matcher.matches(rel)) {
                            Path target = context.getMergedAppPathManager().getPath().resolve(rel);
                            try {
                                String sourceDisplayName = context.getWorkingFolder().relativize((Path)path).toString();
                                String targetDisplayName = context.getOutputPath().relativize(target).toString();
                                if (Files.isDirectory(path, new LinkOption[0])) {
                                    createFolderCount.incrementAndGet();
                                } else {
                                    copyFileCount.incrementAndGet();
                                }
                                this.copyFile(context, (Path)path, sourceDisplayName, target, targetDisplayName);
                            }
                            catch (IOException e) {
                                LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.ERROR, "Copy failed for {} -> {}", rel.toString(), target.toString());
                                throw new RuntimeException("Copy failed for " + String.valueOf(path), e);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to walk runtime path: " + String.valueOf(runtimePath), e);
                }
                int fileCount = copyFileCount.get();
                int folderCount = createFolderCount.get();
                totalFileCount.addAndGet(fileCount);
                totalFolderCount.addAndGet(folderCount);
                LogBlockPrinter.printContent((PrinterContext)context, fileCount == 0 ? LogBlockIcon.WARNING : LogBlockIcon.ITEM, "{} folder(s) and {} file(s) has been created or copied.", folderCount, fileCount);
            });
        }
        LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.INFO, "TOTAL: {} folder(s) and {} file(s) has been created or copied in all patterns.", totalFolderCount.get(), totalFileCount.get());
    }

    private void copyFile(AppMergeContext context, Path source, String sourceDisplayName, Path target, String targetDisplayName) throws IOException {
        try {
            if (Files.isDirectory(source, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
                LogBlockPrinter.printContent((PrinterContext)context, "create folder: {}", targetDisplayName);
            } else {
                String overridingInfo = Files.exists(target, new LinkOption[0]) ? "overriding-" : "";
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                LogBlockIcon icon = overridingInfo.isEmpty() ? LogBlockIcon.ITEM : LogBlockIcon.WARNING;
                LogBlockPrinter.printContent((PrinterContext)context, icon, "copy runtime file <{}to>: {} <from>: {}", overridingInfo, targetDisplayName, sourceDisplayName);
            }
        }
        catch (IOException e) {
            LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.ERROR, "copy runtime file failed! <to>: {} <from>: {}", targetDisplayName, sourceDisplayName);
            throw e;
        }
    }
}

