/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileDestination {
    private Path outputPath;
    NamedPath destinationPath;
    Path destinationFile;

    public FileDestination(Path outputPath, NamedPath destinationPath, Path destinationFile) {
        this.outputPath = outputPath;
        this.destinationPath = destinationPath;
        this.destinationFile = destinationFile;
    }

    public NamedPath getDestinationPath() {
        return this.destinationPath;
    }

    public Path getDestinationFile() {
        return this.destinationFile;
    }

    public String getOutputRelativeDisplayName() {
        String mergedFileDisplayPath = FileSource.getRelativeOutputPathDisplayName(this.outputPath, this.destinationFile);
        return mergedFileDisplayPath;
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public OutputStream openOutputStream(OpenOption ... options) throws IOException {
        if (!Files.exists(this.destinationPath.getPath(), new LinkOption[0])) {
            Files.createDirectories(this.destinationPath.getPath(), new FileAttribute[0]);
        }
        return Files.newOutputStream(this.destinationFile, options);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileDestination other = (FileDestination)obj;
        return this.destinationFile.toAbsolutePath().equals(other.destinationFile.toAbsolutePath());
    }

    public int hashCode() {
        return this.destinationFile.toAbsolutePath().hashCode();
    }

    public static FileDestination resolve(AppMergeContext context, FileSource fileSource) {
        NamedPath destinationPath = context.getMergedAppPathManager().getPath(fileSource.getSourcePath().getType(), fileSource.getSourcePath().getName());
        Path dentationFile = destinationPath.getPath().resolve(fileSource.getSourceFile().getFileName());
        FileDestination fileDestination = new FileDestination(context.getOutputPath(), destinationPath, dentationFile);
        return fileDestination;
    }
}

