/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.digiwin.apphub.tool.utils.FileCopyUtils;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import java.util.List;
import java.util.regex.Pattern;

@AutoService(value={MergeableFileHandler.class})
public class MergeDataPermissionValuesJsonHandler
implements MergeableFileHandler {
    private static final List<Pattern> mergeablePatterns = List.of(Pattern.compile("data-permission-values\\.json"), Pattern.compile("data-permission-values-.*\\.json"));

    @Override
    public List<Pattern> handlePatterns() {
        return mergeablePatterns;
    }

    @Override
    public boolean canHandle(String fileName) {
        return mergeablePatterns.stream().anyMatch(p -> p.matcher(fileName).matches());
    }

    @Override
    public void merge(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList) throws Exception {
        LogBlockPrinter.printSession(String.format("original file destination: %s", mergedDestination.getDestinationFile()), null, appMergeContext, () -> FileCopyUtils.executeRenamedFileCopy(appMergeContext, mergedDestination, mergeList, null));
    }
}

