/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.handler;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@AutoService(value={MergeableFileHandler.class})
public class MergeSpringApplicationXMLHandler
implements MergeableFileHandler {
    public static Logger logger = LoggerFactory.getLogger(MergeSpringApplicationXMLHandler.class);
    private static final List<Pattern> mergeablePatterns = List.of(Pattern.compile("spring-application\\.xml"));
    static final String NODE_BEAN = "bean";
    static final String NODE_COMPONENT_SCAN = "context:component-scan";

    @Override
    public List<Pattern> handlePatterns() {
        return mergeablePatterns;
    }

    @Override
    public boolean canHandle(String fileName) {
        return mergeablePatterns.stream().anyMatch(p -> p.matcher(fileName).matches());
    }

    @Override
    public void merge(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList) throws IOException {
        ArrayList<Element> beanList = new ArrayList<Element>();
        HashMap<String, String> beanIdToClassMap = new HashMap<String, String>();
        ArrayList<Element> componentScanList = new ArrayList<Element>();
        HashMap<String, String> namespaceMap = new HashMap<String, String>();
        StringBuilder schemaLocationHolder = new StringBuilder();
        for (FileSource fileSource : mergeList) {
            Path sourceFilePath = fileSource.getSourceFile();
            if (Files.notExists(sourceFilePath, new LinkOption[0])) continue;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(sourceFilePath.toFile());
                Element rootElement = doc.getDocumentElement();
                NamedNodeMap attributes = rootElement.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attr = attributes.item(i);
                    String name = attr.getNodeName();
                    String value = attr.getNodeValue();
                    if (name.equals("xmlns")) {
                        namespaceMap.put("", value);
                        continue;
                    }
                    if (name.startsWith("xmlns:")) {
                        String prefix = name.substring("xmlns:".length());
                        namespaceMap.put(prefix, value);
                        continue;
                    }
                    if (!name.equals("xsi:schemaLocation")) continue;
                    schemaLocationHolder.append(value);
                }
                NodeList beans = rootElement.getElementsByTagName(NODE_BEAN);
                for (int i = 0; i < beans.getLength(); ++i) {
                    Node bean = beans.item(i);
                    if (bean.getNodeType() != 1) continue;
                    Element beanElement = (Element)bean;
                    String id = beanElement.getAttribute("id");
                    String clazz = beanElement.getAttribute("class");
                    if (id.isEmpty() || clazz.isEmpty()) continue;
                    if (beanIdToClassMap.containsKey(id)) {
                        String oldClass = (String)beanIdToClassMap.get(id);
                        if (oldClass.equals(clazz)) continue;
                        throw new IllegalStateException("Bean id \u91cd\u590d\u4f46 class \u4e0d\u4e00\u81f4\uff1aid=" + id + ", class1=" + oldClass + ", class2=" + clazz + ", \u4f86\u6e90\uff1a" + sourceFilePath.toString());
                    }
                    beanIdToClassMap.put(id, clazz);
                    beanList.add(beanElement);
                }
                NodeList componentScans = rootElement.getElementsByTagName(NODE_COMPONENT_SCAN);
                for (int i = 0; i < componentScans.getLength(); ++i) {
                    Node componentScan = componentScans.item(i);
                    if (componentScan.getNodeType() != 1) continue;
                    Element componentScanElement = (Element)componentScan;
                    componentScanList.add(componentScanElement);
                }
            }
            catch (ParserConfigurationException | SAXException e) {
                logger.error("\u8b80\u53d6spring-application.xml\u6587\u4ef6\u6642\u51fa\u932f\uff1a", e);
            }
        }
        List<Object> dedupedComponentScans = new ArrayList();
        if (componentScanList != null && !componentScanList.isEmpty()) {
            dedupedComponentScans = this.dedupeComponentScans(componentScanList);
        }
        this.generateMergedSpringXml(mergedDestination, namespaceMap, schemaLocationHolder.toString(), beanList, componentScanList);
    }

    private void generateMergedSpringXml(FileDestination mergedDestination, Map<String, String> namespaceMap, String schemaLocation, List<Element> beanList, List<Element> componentScanList) {
        try {
            Path targetFilePath = mergedDestination.getDestinationFile();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document newDoc = builder.newDocument();
            Element root = newDoc.createElement("beans");
            newDoc.appendChild(root);
            for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
                String prefix = entry.getKey();
                String uri = entry.getValue();
                if (prefix.isEmpty()) {
                    root.setAttribute("xmlns", uri);
                    continue;
                }
                root.setAttribute("xmlns:" + prefix, uri);
            }
            if (schemaLocation != null && !schemaLocation.isEmpty()) {
                root.setAttribute("xsi:schemaLocation", schemaLocation);
            }
            for (Element oldBean : beanList) {
                Node imported = newDoc.importNode(oldBean, true);
                root.appendChild(imported);
            }
            Element mergedComponentScan = this.mergeComponentScans(newDoc, componentScanList, "context");
            if (mergedComponentScan != null) {
                root.appendChild(mergedComponentScan);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(newDoc);
            StreamResult result = new StreamResult(targetFilePath.toFile());
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new RuntimeException("\u751f\u6210\u5408\u4f75\u5f8c\u7684 spring xml \u5931\u6557\uff1a" + mergedDestination.toString(), e);
        }
    }

    private List<Element> dedupeComponentScans(List<Element> scans) {
        LinkedHashMap<String, Element> unique = new LinkedHashMap<String, Element>();
        for (Element scan : scans) {
            String normalized;
            String basePackage = scan.getAttribute("base-package");
            if (basePackage == null || basePackage.isEmpty() || unique.containsKey(normalized = Arrays.stream(basePackage.split(",")).map(String::trim).sorted().collect(Collectors.joining(",")))) continue;
            unique.put(normalized, scan);
        }
        return new ArrayList<Element>(unique.values());
    }

    private Element mergeComponentScans(Document targetDoc, List<Element> scanList, String namespacePrefix) {
        TreeSet<String> packageSet = new TreeSet<String>();
        for (Element scan : scanList) {
            String basePackage = scan.getAttribute("base-package");
            if (basePackage == null || basePackage.trim().isEmpty()) continue;
            for (String pkg : basePackage.split(",")) {
                if ((pkg = pkg.trim()).isEmpty()) continue;
                packageSet.add(pkg);
            }
        }
        if (packageSet.isEmpty()) {
            return null;
        }
        String mergedBasePackage = String.join((CharSequence)", ", packageSet);
        String tagName = namespacePrefix == null || namespacePrefix.isEmpty() ? "component-scan" : namespacePrefix + ":component-scan";
        Element merged = targetDoc.createElement(tagName);
        merged.setAttribute("base-package", mergedBasePackage);
        return merged;
    }
}

