/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.merge.properties;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.handler.PropertyGenerateContext;
import com.digiwin.apphub.tool.merge.handler.PropertyLineContext;
import com.digiwin.apphub.tool.merge.properties.PropertyMergeStrategy;
import com.digiwin.apphub.tool.spi.Ordered;
import com.digiwin.apphub.tool.utils.FilePathUtils;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.google.auto.service.AutoService;
import jakarta.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

@AutoService(value={PropertyMergeStrategy.class})
public class AppHubOverridingPropertyStrategy
implements PropertyMergeStrategy,
Ordered {
    private Properties templateApplicationProperties = null;

    @Override
    public String getName() {
        return "appHubOverriding";
    }

    @Override
    public boolean supports(String key) {
        return this.templateApplicationProperties.containsKey(key);
    }

    @Override
    public boolean supports(PropertyLineContext context) {
        if (this.isTargetApplicationProperties(context.getParentContext(), context.getDestinationFile())) {
            this.loadTemplate(context.getParentContext(), context.getFileDestination().getDestinationFile());
            return this.supports(context.getKey());
        }
        return false;
    }

    private boolean isTargetApplicationProperties(AppMergeContext context, Path currentDestination) {
        return FilePathUtils.isSameFile(context.getMergedAppPathManager().getApplicationPropertiesFile().toPath(), currentDestination);
    }

    @Override
    public void digest(PropertyLineContext context) {
        if (this.isTargetApplicationProperties(context.getParentContext(), context.getDestinationFile())) {
            this.loadTemplate(context.getParentContext(), context.getFileDestination().getDestinationFile());
            context.setKeyValue(context.getKey(), this.templateApplicationProperties.getProperty(context.getKey()));
        }
    }

    @Override
    public Map<String, String> generate(PropertyGenerateContext context) {
        if (this.isTargetApplicationProperties(context.getParentContext(), context.getDestinationFile())) {
            this.loadTemplate(context.getParentContext(), context.getDestinationFile());
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>();
            for (String key : this.templateApplicationProperties.stringPropertyNames()) {
                resultMap.put(key, this.templateApplicationProperties.getProperty(key));
            }
            return resultMap;
        }
        return Collections.emptyMap();
    }

    private void loadTemplate(AppMergeContext context, Path destination) {
        if (this.templateApplicationProperties != null) {
            return;
        }
        this.templateApplicationProperties = new Properties();
        Path applicationPropertiesPath = context.getMergedAppPathManager().getRuntimeTemplatePath(context, destination);
        if (applicationPropertiesPath.toFile().exists()) {
            try (InputStream in = Files.newInputStream(applicationPropertiesPath, new OpenOption[0]);){
                LogBlockPrinter.printContent(3, LogBlockIcon.ITEM, "load template file -> {}", applicationPropertiesPath);
                this.templateApplicationProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("load template application.properties failed!", e);
            }
        }
    }

    @Deprecated
    private void loadTemplateOld() {
        this.templateApplicationProperties = new Properties();
        Path path = ToolConstants.getRuntimeTemplatePath();
        Path applicationPropertiesPath = path.resolve("conf").resolve("application.properties");
        if (applicationPropertiesPath.toFile().exists()) {
            try (InputStream in = Files.newInputStream(applicationPropertiesPath, new OpenOption[0]);){
                LogBlockPrinter.printContent(3, LogBlockIcon.ITEM, "load template file -> {}", applicationPropertiesPath);
                this.templateApplicationProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException("load template application.properties failed!", e);
            }
        }
    }

    @PostConstruct
    @Deprecated
    public void init() {
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

