/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.metadata;

import com.digiwin.apphub.tool.dto.OPSAppSourceConfig;
import com.digiwin.apphub.tool.metadata.SourceType;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;

public class AppSource {
    private String appId;
    private SourceType sourceType;
    private OPSAppSourceConfig opsAppSourceConfig = null;
    private Path path;
    private Properties traceableProperties = new Properties();

    public AppSource(OPSAppSourceConfig opsAppSourceConfig, Path path, SourceType sourceType) {
        Objects.requireNonNull(opsAppSourceConfig);
        Objects.requireNonNull(sourceType);
        this.opsAppSourceConfig = opsAppSourceConfig;
        this.sourceType = sourceType;
        this.path = path;
    }

    public String getDeploymentName() {
        return this.opsAppSourceConfig.getDeploymentName();
    }

    public String getVersion() {
        return this.opsAppSourceConfig.getVersion();
    }

    public Path getPath() {
        return this.path;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppSource)) {
            return false;
        }
        AppSource other = (AppSource)o;
        return Objects.equals(this.path.toAbsolutePath().normalize(), other.path.toAbsolutePath().normalize());
    }

    public int hashCode() {
        return Objects.hash(this.path.toAbsolutePath().normalize());
    }
}

