/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.pipeline;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.action.AdjustMergedAppAction;
import com.digiwin.apphub.tool.action.DownloadAppSourceAction;
import com.digiwin.apphub.tool.action.MergeAppSourceAction;
import com.digiwin.apphub.tool.action.ValidationAppSourceAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.pipeline.PipelineDescriptor;
import com.digiwin.apphub.tool.pipeline.PipelineStep;
import com.digiwin.apphub.tool.pipeline.PipelineStepMode;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;

public class PipelineDescriptorLoader {
    private static PipelineDescriptor getDefaultPipelineDescriptor() {
        PipelineDescriptor descriptor = new PipelineDescriptor();
        descriptor.setProfile("dev");
        ArrayList<PipelineStep> steps = new ArrayList<PipelineStep>();
        steps.add(new PipelineStep(DownloadAppSourceAction.class.getSimpleName(), 10, PipelineStepMode.DRY_RUN));
        steps.add(new PipelineStep(ValidationAppSourceAction.class.getSimpleName(), 20, PipelineStepMode.NORMAL));
        steps.add(new PipelineStep(MergeAppSourceAction.class.getSimpleName(), 30, PipelineStepMode.NORMAL));
        steps.add(new PipelineStep(AdjustMergedAppAction.class.getSimpleName(), 40, PipelineStepMode.SKIP));
        steps.add(new PipelineStep("falcon-plug-in", 33, PipelineStepMode.SKIP));
        descriptor.setSteps(steps);
        return descriptor;
    }

    public static PipelineDescriptor loadFromYaml(AppMergeContext context) throws IOException {
        String userDefinedFileName = System.getProperty("pipeline.descriptor.file");
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.findAndRegisterModules();
        if (userDefinedFileName != null && !userDefinedFileName.isBlank()) {
            File descriptorFile = new File(userDefinedFileName);
            if (descriptorFile.exists()) {
                LogBlockPrinter.printContent("pipeline descriptor file = {}", descriptorFile.getAbsolutePath());
                return mapper.readValue(descriptorFile, PipelineDescriptor.class);
            }
            throw new IllegalArgumentException(String.format("pipeline descriptor file: %s does not exist!", descriptorFile));
        }
        if (Boolean.parseBoolean(System.getProperty("useCodePipelineDescriptor"))) {
            return PipelineDescriptorLoader.getDefaultPipelineDescriptor();
        }
        String defaultResourceName = "pipeline-descriptor.yaml";
        String profiledName = ToolConstants.getFileNameWithProfile(defaultResourceName);
        Path settingPath = context.getWorkingFolder().resolve("settings");
        Path path = settingPath.resolve(profiledName);
        if (Files.exists(path, new LinkOption[0])) {
            try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
                LogBlockPrinter.printContent("pipeline descriptor file = {}", path);
                PipelineDescriptor pipelineDescriptor = mapper.readValue(input, PipelineDescriptor.class);
                return pipelineDescriptor;
            }
        }
        try (InputStream input = PipelineDescriptorLoader.class.getClassLoader().getResourceAsStream(profiledName);){
            if (input == null) {
                throw new IllegalArgumentException("default pipeline descriptor resource not found: " + profiledName);
            }
            LogBlockPrinter.printContent("pipeline descriptor resource = {}", profiledName);
            PipelineDescriptor pipelineDescriptor = mapper.readValue(input, PipelineDescriptor.class);
            return pipelineDescriptor;
        }
    }
}

