/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.pipeline;

import com.digiwin.apphub.tool.action.PipelineAction;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.exception.PipelineActionExitException;
import com.digiwin.apphub.tool.pipeline.PipelineDescriptor;
import com.digiwin.apphub.tool.pipeline.PipelineStep;
import com.digiwin.apphub.tool.pipeline.PipelineStepMode;
import com.digiwin.apphub.tool.spi.ToolServiceLoader;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineExecutor {
    private static final Logger logger = LoggerFactory.getLogger(PipelineExecutor.class);
    private final PipelineDescriptor descriptor;

    public PipelineExecutor(ToolServiceLoader toolServiceLoader, PipelineDescriptor descriptor) {
        this.descriptor = descriptor;
        this.bindActions(toolServiceLoader);
    }

    private List<PipelineAction> bindActions(ToolServiceLoader toolServiceLoader) {
        List<PipelineAction> loaded = toolServiceLoader.load(PipelineAction.class);
        toolServiceLoader.load(PipelineAction.class).forEach(loaded::add);
        PipelineAction action = null;
        for (PipelineStep step : this.descriptor.getSteps()) {
            action = loaded.stream().filter(a -> step.getName().equalsIgnoreCase(a.getClass().getSimpleName())).findFirst().orElse(null);
            step.setAction(action);
        }
        return loaded.stream().filter(a -> this.descriptor.isEnabled(a.getClass().getSimpleName())).sorted(Comparator.comparingInt(a -> this.descriptor.getOrder(a.getClass().getSimpleName()))).collect(Collectors.toList());
    }

    private void checkExecutionPlan(AppMergeContext context) {
        LogBlockPrinter.printCaption("Pipeline Execution Plan:", new Object[0]);
        int stepNumber = 0;
        boolean stepFailed = false;
        for (PipelineStep step : this.descriptor.getSteps()) {
            LogBlockIcon icon;
            String actionExistsStatus;
            boolean actionExists = step.getAction() != null;
            boolean executable = step.isExecutable();
            if (actionExists) {
                actionExistsStatus = "ready.";
                icon = executable ? null : LogBlockIcon.NOTICE;
            } else {
                actionExistsStatus = "not exit!";
                if (executable) {
                    icon = LogBlockIcon.ERROR;
                    stepFailed = true;
                } else {
                    icon = LogBlockIcon.NOTICE;
                }
            }
            LogBlockPrinter.printContent(1, icon, "Step {}.{} | mode={} | order={} | action is {}", new Object[]{String.format("%02d", ++stepNumber), step.getName(), step.getMode(), String.format("%02d", step.getOrder()), actionExistsStatus});
        }
        if (stepFailed) {
            context.exitPipeline("Execution plan is not correct!");
        }
    }

    public int execute(AppMergeContext context) {
        this.checkExecutionPlan(context);
        int stepNumber = 0;
        for (PipelineStep step : this.descriptor.getSteps()) {
            step.setExecutionSeq(++stepNumber);
            context.setCurrentStep(step);
            LogBlockPrinter.printStepStart(step);
            if (step.getMode() == PipelineStepMode.SKIP) continue;
            long start = System.currentTimeMillis();
            try {
                step.getAction().execute(context);
                LogBlockPrinter.printStepEnd(step, System.currentTimeMillis() - start);
            }
            catch (PipelineActionExitException e) {
                LogBlockPrinter.printStepException(e.getCurrentStep(), e);
                logger.error("{} [Exit Pipeline]", (Object)LogBlockIcon.ERROR, (Object)e);
                return 1;
            }
            catch (Exception e) {
                LogBlockPrinter.printStepException(step, e);
                logger.error("{} [Unexpected Exit Pipeline]", (Object)LogBlockIcon.ERROR, (Object)e);
                return 1;
            }
        }
        logger.info("{} [Pipeline Completed]", (Object)LogBlockIcon.INFO);
        return 0;
    }
}

