/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.processor;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.inject.InjectSetting;
import com.digiwin.apphub.tool.merge.AppSourcePathManager;
import com.digiwin.apphub.tool.merge.DAPAppSourcePathManager;
import com.digiwin.apphub.tool.merge.GeneralMergeAnalysisReport;
import com.digiwin.apphub.tool.merge.MergeProcessor;
import com.digiwin.apphub.tool.merge.MergeResult;
import com.digiwin.apphub.tool.merge.SourceTypePathManagerFactory;
import com.digiwin.apphub.tool.merge.handler.DAPServiceGroupFileSource;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.MergeCategory;
import com.digiwin.apphub.tool.metadata.SourceType;
import com.digiwin.apphub.tool.processor.ServiceGroupTrackingRecord;
import com.digiwin.apphub.tool.setting.dto.ServiceGroupChecking;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.utils.PropertiesUtils;
import com.digiwin.apphub.tool.utils.dto.AppSourceTrackingRecord;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import com.google.auto.service.AutoService;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={ValidationProcessor.class, MergeProcessor.class})
public class MergeServiceGroupProcessor
implements ValidationProcessor,
MergeProcessor<GeneralMergeAnalysisReport> {
    private static Logger logger = LoggerFactory.getLogger(MergeServiceGroupProcessor.class);
    public static String DATA_KEY_DAP_SERVICE_GROUP_INFO = "dap-ervice-group-info";
    @InjectSetting(key="validation.serviceGroupChecking")
    private ServiceGroupChecking checkingRule;

    @Override
    public String getDisplayName() {
        return "Merge Service Group Processor";
    }

    @Override
    public void validate(AppMergeContext context) throws Exception {
        Map<String, ServiceGroupTrackingRecord> trackingList = this.createTrackingMap(context);
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "{} Service Group(s) found.", trackingList.size());
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "exclude auto-rename list: {}", this.checkingRule.getExcludeNames());
        for (Map.Entry<String, ServiceGroupTrackingRecord> item : trackingList.entrySet()) {
            String groupName = item.getKey();
            ServiceGroupTrackingRecord groupSource = item.getValue();
            Map<AppSource, List<FileSource>> groupFromList = groupSource.getAppGroupFileSourceList();
            if (groupSource.hasConflict()) {
                boolean excluded = this.checkingRule.isExclude(groupName);
                LogBlockPrinter.printGroupScopeContent(excluded ? LogBlockIcon.ITEM : LogBlockIcon.WARNING, "Service Group [{}]{} found from multiple app source: {}", groupName, excluded ? "(exclude auto-rename)" : "", groupFromList.keySet().stream().map(AppSource::getDeploymentName).collect(Collectors.toList()));
            } else {
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.ITEM, "Service Group [{}] found from app source: {}", groupName, groupFromList.keySet().stream().findFirst().map(AppSource::getDeploymentName).orElse(null));
            }
            this.printServiceGroupDetails(context, groupSource);
        }
    }

    private void printServiceGroupDetails(AppMergeContext context, ServiceGroupTrackingRecord groupSource) {
        if (context.getMergeCategory() == MergeCategory.DAP_SIMPLIFIED) {
            for (List<FileSource> fileSources : groupSource.getAppGroupFileSourceList().values()) {
                for (FileSource fs : fileSources) {
                    LogBlockPrinter.printGroupScopeContent(LogBlockIcon.ITEM, "  - {}", fs.getDisplayName());
                }
            }
        }
    }

    private Map<String, ServiceGroupTrackingRecord> createTrackingMap(AppMergeContext context) {
        Map trackingList = (Map)context.computeIfAbsent(DATA_KEY_DAP_SERVICE_GROUP_INFO, key -> new LinkedHashMap());
        for (AppSource appSource : context.getAppSourceList()) {
            AppSourcePathManager pathManager = SourceTypePathManagerFactory.get(appSource, context.getMergeCategory());
            if (!(pathManager instanceof DAPAppSourcePathManager)) continue;
            DAPAppSourcePathManager dapPathManager = (DAPAppSourcePathManager)pathManager;
            Map<String, List<FileSource>> groupList = dapPathManager.getServiceGroupFileList();
            for (Map.Entry<String, List<FileSource>> item : groupList.entrySet()) {
                String groupName = item.getKey();
                ServiceGroupTrackingRecord groupSource = trackingList.computeIfAbsent(groupName, key -> new ServiceGroupTrackingRecord(groupName));
                groupSource.addSource(appSource, item.getValue());
            }
        }
        return trackingList;
    }

    @Override
    public MergeResult<GeneralMergeAnalysisReport> execute(AppMergeContext context) throws Exception {
        AppSourceTrackingRecord appSourceInfoRecord = PropertiesUtils.getAppSourceTrackingRecord(context);
        Map trackingList = (Map)context.computeIfAbsent(DATA_KEY_DAP_SERVICE_GROUP_INFO, key -> new LinkedHashMap());
        HashSet<String> copyOnceList = new HashSet<String>();
        for (Map.Entry item : trackingList.entrySet()) {
            String groupName = (String)item.getKey();
            ServiceGroupTrackingRecord groupSource = (ServiceGroupTrackingRecord)item.getValue();
            List groupFileSourceList = groupSource.getAppGroupFileSourceList().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            boolean copyOnce = this.checkingRule.isExclude(groupName);
            boolean rename = groupSource.hasConflict() && !copyOnce;
            for (FileSource fs : groupFileSourceList) {
                String newGroupName = MergeServiceGroupProcessor.resolveNewGroupName(context, groupName, fs);
                appSourceInfoRecord.addGroup(fs.getAppSource(), rename ? newGroupName : groupName);
                if (rename) {
                    appSourceInfoRecord.addRenamedGroup(fs.getAppSource(), groupName, newGroupName);
                }
                FileDestination destination = context.getMergedAppPathManager().resolveDestination(context, fs);
                Path targetPath = rename ? destination.getDestinationPath().getPath().resolve(newGroupName) : destination.getDestinationFile();
                String displayName = rename ? FileSource.getRelativeOutputPathDisplayName(context, targetPath) : destination.getOutputRelativeDisplayName();
                SourceType sourceType = fs.getAppSource().getSourceType();
                if (sourceType == SourceType.DAP_MODULAR) {
                    if ((!copyOnce || copyOnceList.contains(groupName)) && copyOnce) continue;
                    LogBlockPrinter.printContent((PrinterContext)context, rename ? LogBlockIcon.WARNING : LogBlockIcon.ITEM, rename ? "copy [{}] renamed service group... <to>: {} <from>: {}" : "copy [{}] service group... <to>: {} <from>: {}", rename ? MergeServiceGroupProcessor.resolveNewGroupName(context, groupName, fs) : groupName, displayName, fs.getDisplayName());
                    copyOnceList.add(groupName);
                    FileUtils.copyDirectory(fs.getSourceFile().toFile(), targetPath.toFile());
                    continue;
                }
                if (sourceType != SourceType.DAP_SIMPLIFIED || !rename) continue;
                MergeServiceGroupProcessor.renameGroup(context, groupName, (DAPServiceGroupFileSource)fs);
            }
        }
        return null;
    }

    private static String resolveNewGroupName(AppMergeContext context, String groupName, FileSource fs) {
        return fs.getAppSource().getAppId() + "_" + groupName;
    }

    private static void renameGroup(AppMergeContext context, String groupName, DAPServiceGroupFileSource fs) {
        FileDestination destination = context.getMergedAppPathManager().resolveDestination(context, fs);
        String newName = MergeServiceGroupProcessor.resolveNewGroupName(context, groupName, fs);
        LogBlockPrinter.printContent((PrinterContext)context, LogBlockIcon.WARNING, "renamed [{}]/{} {} value... <to>: {} <from>: {}", destination.getOutputRelativeDisplayName(), "META-INF/dap.info", "group.name", groupName, newName);
        try {
            fs.setGroupName(newName);
            Properties newProperties = fs.getDapInfo();
            try (FileSystem fileSystem = FileSystems.newFileSystem(destination.getDestinationFile(), (ClassLoader)null);){
                Path dapInfoPath = fileSystem.getPath("META-INF/dap.info", new String[0]);
                try (OutputStream os = Files.newOutputStream(dapInfoPath, new OpenOption[0]);){
                    newProperties.store(os, "Updated by dap merge tool");
                }
            }
        }
        catch (Exception e) {
            LogBlockPrinter.printContent(LogBlockIcon.ERROR, "update jar:{} dap.info failed, reason={}", fs.getDisplayName(), e.getMessage());
        }
    }
}

