/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.processor;

import com.digiwin.apphub.tool.ToolConstants;
import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.merge.AppSourcePathManager;
import com.digiwin.apphub.tool.merge.GeneralMergeAnalysisReport;
import com.digiwin.apphub.tool.merge.MergeProcessor;
import com.digiwin.apphub.tool.merge.MergeResult;
import com.digiwin.apphub.tool.merge.MergedAppPathManager;
import com.digiwin.apphub.tool.merge.NamedPath;
import com.digiwin.apphub.tool.merge.SourceTypePathManagerFactory;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.merge.handler.MergeableFileHandler;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;

@AutoService(value={MergeProcessor.class, ValidationProcessor.class})
public class MergeableFileValidationProcessor
implements ValidationProcessor,
MergeProcessor<GeneralMergeAnalysisReport> {
    public static String KEY_MERGE_FILE_LIST = "merge-file-list";
    private SingleFileCopyHandler singleFileCopyHandler = new SingleFileCopyHandler();
    private List<MergeableFileHandler> fileHandlers;

    @Override
    public String getDisplayName() {
        return "File Merge Processor";
    }

    @Inject
    public void setFileHandlerList(List<MergeableFileHandler> fileHandlers) {
        this.fileHandlers = fileHandlers;
    }

    @Override
    public void validate(AppMergeContext context) {
        List<AppSource> sources = context.getAppSourceList();
        HashMap groupedByFolderAndFile = new HashMap();
        for (AppSource appSource : sources) {
            AppSourcePathManager pathManager = SourceTypePathManagerFactory.get(appSource, context.getMergeCategory());
            for (NamedPath namedPath : pathManager.getConfigPaths()) {
                String usageName = namedPath.getName();
                Path folderPath = namedPath.getPath();
                try {
                    Stream<Path> files = Files.list(folderPath);
                    try {
                        files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                            String fileName = file.getFileName().toString();
                            FileSource fileSource = new FileSource(appSource, namedPath, (Path)file);
                            groupedByFolderAndFile.computeIfAbsent(usageName, k -> new HashMap()).computeIfAbsent(fileName, k -> new ArrayList()).add(fileSource);
                        });
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                catch (IOException files) {}
            }
        }
        ArrayList<String> conflictFileNames = new ArrayList<String>();
        HashMap<MergeableFileHandler, List<FileSource>> mergeableFileHandlerListMap = new HashMap<MergeableFileHandler, List<FileSource>>();
        for (Map.Entry folderEntry : groupedByFolderAndFile.entrySet()) {
            String folderName = (String)folderEntry.getKey();
            Map fileMap = (Map)folderEntry.getValue();
            for (Map.Entry fileEntry : fileMap.entrySet()) {
                List currentFileList;
                String fileName = (String)fileEntry.getKey();
                List fileList = (List)fileEntry.getValue();
                MergeableFileHandler handler = this.fileHandlers.stream().filter(h -> h.canHandle(fileName)).findFirst().orElse(null);
                if (fileList.size() == 1) {
                    if (handler == null) {
                        handler = this.singleFileCopyHandler;
                    }
                    currentFileList = mergeableFileHandlerListMap.computeIfAbsent(handler, key -> new ArrayList());
                    currentFileList.addAll(fileList);
                }
                if (fileList.size() <= 1) continue;
                if (handler == null) {
                    LogBlockPrinter.printGroupScopeContent(LogBlockIcon.ERROR, "Unmergeable file conflict in [{}]: [{}]", folderName, fileName);
                    fileList.forEach(dp -> LogBlockPrinter.printGroupScopeContent(null, "  - {}", dp.getDisplayName()));
                    conflictFileNames.add(fileName);
                    continue;
                }
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "Mergeable file detected in [{}]: [{}] | handler: {}", folderName, fileName, handler.getClass().getSimpleName());
                fileList.forEach(dp -> LogBlockPrinter.printGroupScopeContent(null, "  - {}", dp.getDisplayName()));
                currentFileList = mergeableFileHandlerListMap.computeIfAbsent(handler, key -> new ArrayList());
                currentFileList.addAll(fileList);
            }
        }
        if (!conflictFileNames.isEmpty()) {
            if (context.isDryRun()) {
                LogBlockPrinter.printGroupScopeDryRunWithNoExitContent("Unmergeable file name conflict detected across source!", new Object[0]);
            } else {
                context.exitPipeline("Unmergeable file name conflict detected across source!");
            }
        }
        this.putMergeFileList(context, mergeableFileHandlerListMap);
    }

    @Override
    public MergeResult<GeneralMergeAnalysisReport> execute(AppMergeContext context) throws Exception {
        Map<MergeableFileHandler, List<FileSource>> mergeFileList = this.getMergeFileList(context);
        if (mergeFileList == null) {
            context.exitPipeline("There are no merge file list info, please check if pipeline has mapping validation processor!");
        }
        MergedAppPathManager targetPathManager = context.getMergedAppPathManager();
        for (Map.Entry<MergeableFileHandler, List<FileSource>> item : mergeFileList.entrySet()) {
            MergeableFileHandler handler = item.getKey();
            int sequence = context.incrementSequenceAndGet(ToolConstants.getSequenceKey(this, "fileHandler"));
            LogBlockPrinter.printSession(String.format("%02d.File Handler: %s", sequence, handler.getClass().getName()), null, context, () -> {
                Map<FileDestination, List<FileSource>> grouped = ((List)item.getValue()).stream().collect(Collectors.groupingBy(fs -> targetPathManager.resolveDestination(context, (FileSource)fs)));
                for (FileDestination fileDestination : grouped.keySet()) {
                    ((MergeableFileHandler)item.getKey()).merge(context, fileDestination, grouped.get(fileDestination));
                }
            });
        }
        return null;
    }

    private void putMergeFileList(AppMergeContext context, Map<MergeableFileHandler, List<FileSource>> mergeableFileHandlerListMap) {
        context.put(KEY_MERGE_FILE_LIST, mergeableFileHandlerListMap);
    }

    private Map<MergeableFileHandler, List<FileSource>> getMergeFileList(AppMergeContext context) {
        return (Map)context.get(KEY_MERGE_FILE_LIST);
    }

    private static class SingleFileCopyHandler
    implements MergeableFileHandler {
        private SingleFileCopyHandler() {
        }

        @Override
        public List<Pattern> handlePatterns() {
            return List.of();
        }

        @Override
        public boolean canHandle(String fileName) {
            return false;
        }

        @Override
        public void merge(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList) throws IOException {
            if (mergeList.size() == 0 || mergeList.size() > 1) {
                throw new IllegalArgumentException("mergeList size can one be 1! actual size=" + mergeList.size());
            }
            FileSource fileSource = mergeList.getFirst();
            String fromFileDisplayPath = FileSource.getRelativeAppPathDisplayName(fileSource.getAppSource(), fileSource.getSourceFile(), true);
            String toFileDisplayPath = mergedDestination.getOutputRelativeDisplayName();
            LogBlockPrinter.printContent((PrinterContext)appMergeContext, "copy file... <to>: {} <from>: {}", toFileDisplayPath, fromFileDisplayPath);
            Files.createDirectories(mergedDestination.getDestinationPath().getPath(), new FileAttribute[0]);
            Files.copy(fileSource.getSourceFile(), mergedDestination.getDestinationFile(), new CopyOption[0]);
        }
    }
}

