/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.setting;

import com.digiwin.apphub.tool.exception.PipelineActionFailedException;
import com.digiwin.apphub.tool.exception.SettingPathNotFoundException;
import com.digiwin.apphub.tool.serializer.ToolGsonProvider;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.util.function.Supplier;

public class ToolJsonSettingResolver
implements ToolSettingResolver {
    private String settingFilePath;

    public ToolJsonSettingResolver(String settingFilePath) {
        this.settingFilePath = settingFilePath;
    }

    @Override
    public <T> T get(Class<T> configType, String configPath) {
        return this.get(configType, configPath, null);
    }

    @Override
    public <T> T getOrDefault(Class<T> configType, String configPath, T defaultValue) {
        return (T)this.get(configType, configPath, () -> defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(Class<T> configType, String configPath, Supplier<T> defaultValueSupplier) {
        Gson gson = ToolGsonProvider.get();
        try (FileReader reader = new FileReader(this.settingFilePath);){
            JsonObject root = JsonParser.parseReader(reader).getAsJsonObject();
            if (configPath == null || configPath.isEmpty()) {
                T t = gson.fromJson((JsonElement)root, configType);
                return t;
            }
            String[] segments = configPath.split("\\.");
            JsonElement current = root;
            for (String segment : segments) {
                if (!current.isJsonObject()) {
                    throw new IllegalArgumentException("Invalid path: " + configPath);
                }
                String key = segment;
                Integer index = null;
                if (segment.contains("[") && segment.endsWith("]")) {
                    int bracketIndex = segment.indexOf("[");
                    key = segment.substring(0, bracketIndex);
                    try {
                        index = Integer.parseInt(segment.substring(bracketIndex + 1, segment.length() - 1));
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Invalid array index in path: " + configPath);
                    }
                }
                if ((current = current.getAsJsonObject().get(key)) == null) {
                    if (defaultValueSupplier == null) {
                        throw new SettingPathNotFoundException("Path not found: " + configPath);
                    }
                    T t = defaultValueSupplier.get();
                    return t;
                }
                if (index == null) continue;
                if (!current.isJsonArray()) {
                    throw new IllegalArgumentException("Expected array at: " + key);
                }
                current = current.getAsJsonArray().get(index);
            }
            T t = gson.fromJson(current, configType);
            return t;
        }
        catch (Exception e) {
            throw new PipelineActionFailedException("get setting object failed!", e);
        }
    }
}

