/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.setting;

import com.digiwin.apphub.tool.setting.ToolJsonSettingResolver;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.setting.ToolYamlSettingProvider;
import java.nio.file.Path;

public class ToolSettingProviderFactory {
    public static ToolSettingResolver create(String settingFilePath) {
        String lower = settingFilePath.toLowerCase();
        if (lower.endsWith(".json")) {
            return new ToolJsonSettingResolver(settingFilePath);
        }
        if (lower.endsWith(".yaml") || lower.endsWith(".yml")) {
            return new ToolYamlSettingProvider(settingFilePath);
        }
        throw new IllegalArgumentException("Unsupported setting file format: " + settingFilePath);
    }

    public static ToolSettingResolver create(Path settingFile) {
        return ToolSettingProviderFactory.create(settingFile.toString());
    }
}

