/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.context.PrinterContext;
import com.digiwin.apphub.tool.merge.handler.FileDestination;
import com.digiwin.apphub.tool.merge.handler.FileSource;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class FileCopyUtils {
    private static final String FORMAT_FILE_NAME_WITH_APP_ID = "%s-%s";

    public static void executeRenamedFileCopy(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList, FileNamingStrategy strategy, BeforeCopy callback) throws IOException {
        for (FileSource fs : mergeList) {
            Path renamedFile = strategy.resolve(appMergeContext, fs, mergedDestination);
            if (callback == null) {
                String fromFileDisplayPath = FileSource.getRelativeAppPathDisplayName(fs.getAppSource(), fs.getSourceFile(), true);
                String toFileDisplayPath = FileSource.getRelativeOutputPathDisplayName(appMergeContext, renamedFile);
                LogBlockPrinter.printContent((PrinterContext)appMergeContext, "copy renamed file... <to>: {} <from>:{}", toFileDisplayPath, fromFileDisplayPath);
            } else {
                callback.before(fs.getSourceFile(), renamedFile);
            }
            Files.createDirectories(mergedDestination.getDestinationPath().getPath(), new FileAttribute[0]);
            Files.copy(fs.getSourceFile(), renamedFile, new CopyOption[0]);
        }
    }

    public static void executeRenamedFileCopy(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList, BeforeCopy callback) throws IOException {
        FileCopyUtils.executeRenamedFileCopy(appMergeContext, mergedDestination, mergeList, FileCopyUtils::renameFileWithAppIdPrefix, callback);
    }

    public static void executeFirstFileCopy(AppMergeContext appMergeContext, FileDestination mergedDestination, List<FileSource> mergeList, BeforeCopy callback) throws IOException {
        if (mergeList.size() == 0) {
            return;
        }
        FileSource firstFile = mergeList.getFirst();
        if (callback == null) {
            String fromFileDisplayPath = FileSource.getRelativeAppPathDisplayName(firstFile.getAppSource(), firstFile.getSourceFile(), true);
            LogBlockPrinter.printContent((PrinterContext)appMergeContext, "copy first file... <to>: {} <from>:{}", mergedDestination.getOutputRelativeDisplayName(), fromFileDisplayPath);
        } else {
            callback.before(firstFile.getSourceFile(), mergedDestination.getDestinationPath().getPath());
        }
        Files.createDirectories(mergedDestination.getDestinationPath().getPath(), new FileAttribute[0]);
        Files.copy(firstFile.getSourceFile(), mergedDestination.getDestinationFile(), new CopyOption[0]);
    }

    public static Path renameFileWithAppIdPrefix(AppMergeContext appMergeContext, FileSource fileSource, FileDestination mergedDestination) {
        String sourceFileName = fileSource.getSourceFile().toFile().getName();
        String outputFileNameWithAppId = String.format(FORMAT_FILE_NAME_WITH_APP_ID, fileSource.getAppSource().getAppId(), sourceFileName);
        Path renamedFile = mergedDestination.getDestinationPath().getPath().resolve(outputFileNameWithAppId);
        return renamedFile;
    }

    @FunctionalInterface
    public static interface FileNamingStrategy {
        public Path resolve(AppMergeContext var1, FileSource var2, FileDestination var3);
    }

    @FunctionalInterface
    public static interface BeforeCopy {
        public void before(Path var1, Path var2);
    }
}

