/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.SourceTypePathManagerFactory;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.MergeCategory;
import com.digiwin.apphub.tool.setting.ToolSettingResolver;
import com.digiwin.apphub.tool.utils.dto.AppSourceTrackingRecord;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PropertiesUtils {
    public static final String CONFIG_KEY_APP_ID = "appId";
    public static final String FILE_APPLICATION_PROPERTIES = "application.properties";
    private static Pattern placeHolderPattern = Pattern.compile("@(.+?)@");

    public static boolean isPlaceholder(String propertyValue) {
        if (propertyValue == null || propertyValue.isEmpty()) {
            return false;
        }
        return placeHolderPattern.matcher(propertyValue).matches();
    }

    public static String getPlaceHolderName(String propertyValue) {
        Matcher matcher = placeHolderPattern.matcher(propertyValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Property value is not placeholder!");
        }
        return matcher.group();
    }

    public static List<AppIdMapping> getCustomAppIdMappingList(ToolSettingResolver settingResolver) {
        List result = settingResolver.getOrDefault(List.class, "customAppIdMappings", Collections.emptyList());
        return result.stream().filter(Objects::nonNull).map(map -> {
            AppIdMapping mapping = new AppIdMapping();
            mapping.setDeploymentName((String)map.get("deploymentName"));
            mapping.setAppId((String)map.get(CONFIG_KEY_APP_ID));
            return mapping;
        }).collect(Collectors.toList());
    }

    public static AppSourceTrackingRecord getAppSourceTrackingRecord(AppMergeContext context) {
        AppSourceTrackingRecord record = (AppSourceTrackingRecord)context.get(AppSourceTrackingRecord.KEY_APP_SOURCE_TRACKING_RECORD);
        if (record == null) {
            record = new AppSourceTrackingRecord();
            context.put(AppSourceTrackingRecord.KEY_APP_SOURCE_TRACKING_RECORD, record);
        }
        return record;
    }

    public static File getApplicationPropertiesFile(AppSource appSource, MergeCategory mergeCategory) {
        return SourceTypePathManagerFactory.get(appSource, mergeCategory).getApplicationPropertiesFile();
    }

    public static class AppIdMapping {
        String deploymentName;
        String appId;

        public String getDeploymentName() {
            return this.deploymentName;
        }

        public void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }
    }
}

