/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.utils.dto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class KeyValueRecord {
    private boolean conflict = false;
    private final String key;
    private final List<Source> sourceList = new ArrayList<Source>();

    public KeyValueRecord(Supplier<String> locationSupplier, String key, String value) {
        this.key = key;
        this.addSource(locationSupplier, value);
    }

    public void addSource(Supplier<String> locationSupplier, String value) {
        String originalValue;
        if (this.sourceList.size() > 0 && !this.conflict && (originalValue = this.getOriginalValue()) != null && !originalValue.equals(value)) {
            this.conflict = true;
        }
        this.sourceList.add(new Source(locationSupplier.get(), value));
    }

    public String getKey() {
        return this.key;
    }

    public String getOriginalLocation() {
        return this.sourceList.get((int)0).location;
    }

    public String getOriginalValue() {
        return this.sourceList.get((int)0).value;
    }

    public String getAllValue() {
        if (!this.conflict) {
            return this.getOriginalValue();
        }
        Set values = this.sourceList.stream().map(s -> "[" + s.value + "]").collect(Collectors.toSet());
        return String.join((CharSequence)" - ", values);
    }

    public boolean hasConflict() {
        return this.conflict;
    }

    public List<Source> getConflictingSources() {
        if (!this.conflict) {
            return Collections.emptyList();
        }
        String originalValue = this.getOriginalValue();
        return this.sourceList.stream().skip(1L).filter(s -> !originalValue.equals(s.value)).collect(Collectors.toList());
    }

    public static class Source {
        private final String location;
        private final String value;

        public Source(String location, String value) {
            this.location = location;
            this.value = value;
        }

        public String getLocation() {
            return this.location;
        }

        public String getValue() {
            return this.value;
        }
    }
}

