/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apphub.tool.validation;

import com.digiwin.apphub.tool.context.AppMergeContext;
import com.digiwin.apphub.tool.merge.MergeCategoryPathManagerInitializer;
import com.digiwin.apphub.tool.metadata.AppSource;
import com.digiwin.apphub.tool.metadata.MergeCategory;
import com.digiwin.apphub.tool.metadata.SourceType;
import com.digiwin.apphub.tool.spi.Ordered;
import com.digiwin.apphub.tool.utils.LogBlockIcon;
import com.digiwin.apphub.tool.utils.LogBlockPrinter;
import com.digiwin.apphub.tool.utils.PropertiesUtils;
import com.digiwin.apphub.tool.validation.ValidationProcessor;
import com.google.auto.service.AutoService;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

@AutoService(value={ValidationProcessor.class})
public class MergeCategoryValidationProcessor
implements ValidationProcessor,
Ordered {
    @Override
    public String getDisplayName() {
        return "Resolve Merge Category";
    }

    @Override
    public void validate(AppMergeContext context) throws Exception {
        this.resolveMergeCategory(context);
        this.validateAppId(context);
    }

    private String resolveAppId(AppMergeContext context, AppSource appSource) throws Exception {
        PropertiesUtils.AppIdMapping customMapping;
        List<PropertiesUtils.AppIdMapping> fallbackMapping = PropertiesUtils.getCustomAppIdMappingList(context.getSettingProvider());
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "Custom appId mapping size={}", fallbackMapping.size());
        String appId = null;
        File applicationPropertiesFile = PropertiesUtils.getApplicationPropertiesFile(appSource, context.getMergeCategory());
        if (applicationPropertiesFile.exists()) {
            Properties properties = new Properties();
            try (InputStream inputStream = Files.newInputStream(applicationPropertiesFile.toPath(), new OpenOption[0]);){
                properties.load(inputStream);
            }
            String appIdValue = properties.getProperty("appId");
            if (appIdValue == null || appIdValue.isEmpty()) {
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "[{}] {}'s appId is null or empty!", appSource.getDeploymentName(), "application.properties");
            } else if (PropertiesUtils.isPlaceholder(appIdValue)) {
                LogBlockPrinter.printGroupScopeContent(LogBlockIcon.NOTICE, "[{}] {}'s appId is a placeholder!", appSource.getDeploymentName(), "application.properties");
            } else {
                appId = appIdValue;
            }
        }
        if ((appId == null || appId.isEmpty()) && (customMapping = (PropertiesUtils.AppIdMapping)fallbackMapping.stream().filter(item -> appSource.getDeploymentName().equalsIgnoreCase(item.getDeploymentName())).findFirst().orElse(null)) != null) {
            appId = customMapping.getAppId();
            LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "[{}] found custom appId mapping, value={}", appSource.getDeploymentName(), appId);
        }
        appSource.setAppId(appId);
        return appId;
    }

    private void validateAppId(AppMergeContext context) {
        List noAppIdDeploymentList = context.getAppSourceList().stream().filter(appSource -> appSource.getAppId() == null || appSource.getAppId().isEmpty()).map(appSource -> appSource.getDeploymentName()).collect(Collectors.toList());
        if (noAppIdDeploymentList.size() > 0) {
            String reason = String.format("appId is not correct detected across source -> %s", noAppIdDeploymentList);
            if (context.isDryRun()) {
                LogBlockPrinter.printGroupScopeDryRunWithNoExitContent(reason, new Object[0]);
            } else {
                context.exitPipeline(reason);
            }
        }
    }

    private MergeCategory resolveMergeCategory(AppMergeContext context) throws Exception {
        List<AppSource> appSourceList = context.getAppSourceList();
        if (appSourceList.size() == 0) {
            context.exitPipeline("There are no any app source need to validate.");
        }
        Set sourceTypes = appSourceList.stream().map(AppSource::getSourceType).collect(Collectors.toSet());
        for (AppSource appSource : appSourceList) {
            this.resolveAppId(context, appSource);
            String appId = appSource.getAppId();
            LogBlockIcon icon = appId == null || appId.isEmpty() ? LogBlockIcon.ERROR : null;
            LogBlockPrinter.printGroupScopeContent(icon, "Type: {} | Name: {} | App ID: {}", String.format("%-16s", new Object[]{appSource.getSourceType()}), appSource.getDeploymentName(), appId);
        }
        MergeCategory category = MergeCategory.NOT_SUPPORT;
        if (sourceTypes.size() == 1) {
            SourceType singleType = (SourceType)((Object)sourceTypes.iterator().next());
            switch (singleType) {
                case DAP_MODULAR: {
                    category = MergeCategory.DAP_MODULAR;
                    break;
                }
                case DAP_SIMPLIFIED: {
                    category = MergeCategory.DAP_SIMPLIFIED;
                    break;
                }
                case SPRING_BOOT_FAT_JAR: {
                    category = MergeCategory.SPRING_BOOT_FAT_JAR;
                    break;
                }
                default: {
                    context.exitPipeline("Merge cannot proceed: unsupported source type encountered - " + String.valueOf((Object)singleType) + ".");
                    break;
                }
            }
        } else if (sourceTypes.size() == 2 && sourceTypes.contains((Object)SourceType.DAP_SIMPLIFIED) && sourceTypes.contains((Object)SourceType.SPRING_BOOT_FAT_JAR)) {
            category = MergeCategory.DAP_SIMPLIFIED_AND_SPRING_BOOT_FAT_JAR;
        } else {
            context.exitPipeline("Merge cannot proceed: unsupported source type combination - " + String.valueOf(sourceTypes) + ".");
        }
        LogBlockPrinter.printGroupScopeContent(LogBlockIcon.INFO, "[Target Merge Category] ---> {}", new Object[]{category});
        context.setMergeCategory(category);
        MergeCategoryPathManagerInitializer.init(context);
        return category;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

