/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.gem.NamedGem;
import org.mapstruct.ap.internal.gem.QualifierGem;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.selector.MethodSelector;
import org.mapstruct.ap.internal.model.source.selector.SelectedMethod;
import org.mapstruct.ap.internal.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.TypeUtils;

public class QualifierSelector
implements MethodSelector {
    private final TypeUtils typeUtils;
    private final TypeMirror namedAnnotationTypeMirror;

    public QualifierSelector(TypeUtils typeUtils, ElementUtils elementUtils) {
        this.typeUtils = typeUtils;
        this.namedAnnotationTypeMirror = elementUtils.getTypeElement("org.mapstruct.Named").asType();
    }

    @Override
    public <T extends Method> List<SelectedMethod<T>> getMatchingMethods(Method mappingMethod, List<SelectedMethod<T>> methods, List<Type> sourceTypes, Type mappingTargetType, Type returnType, SelectionCriteria criteria) {
        int numberOfQualifiersToMatch = 0;
        ArrayList<TypeMirror> qualifierTypes = new ArrayList<TypeMirror>();
        if (criteria.getQualifiers() != null) {
            qualifierTypes.addAll(criteria.getQualifiers());
            numberOfQualifiersToMatch += criteria.getQualifiers().size();
        }
        ArrayList<String> qualfiedByNames = new ArrayList<String>();
        if (criteria.getQualifiedByNames() != null) {
            qualfiedByNames.addAll(criteria.getQualifiedByNames());
            numberOfQualifiersToMatch += criteria.getQualifiedByNames().size();
        }
        if (!qualfiedByNames.isEmpty()) {
            qualifierTypes.add(this.namedAnnotationTypeMirror);
        }
        if (qualifierTypes.isEmpty()) {
            ArrayList<SelectedMethod<T>> nonQualiferAnnotatedMethods = new ArrayList<SelectedMethod<T>>(methods.size());
            for (SelectedMethod<T> candidate : methods) {
                if (candidate.getMethod() instanceof SourceMethod) {
                    Set<AnnotationMirror> qualifierAnnotations = this.getQualifierAnnotationMirrors((Method)candidate.getMethod());
                    if (!qualifierAnnotations.isEmpty()) continue;
                    nonQualiferAnnotatedMethods.add(candidate);
                    continue;
                }
                nonQualiferAnnotatedMethods.add(candidate);
            }
            return nonQualiferAnnotatedMethods;
        }
        ArrayList<SelectedMethod<T>> matches = new ArrayList<SelectedMethod<T>>(methods.size());
        for (SelectedMethod<T> candidate : methods) {
            if (!(candidate.getMethod() instanceof SourceMethod)) continue;
            Set<AnnotationMirror> qualifierAnnotationMirrors = this.getQualifierAnnotationMirrors((Method)candidate.getMethod());
            int matchingQualifierCounter = 0;
            block2: for (AnnotationMirror qualifierAnnotationMirror : qualifierAnnotationMirrors) {
                for (TypeMirror qualifierType : qualifierTypes) {
                    DeclaredType qualifierAnnotationType;
                    if (!this.typeUtils.isSameType(qualifierType, qualifierAnnotationType = qualifierAnnotationMirror.getAnnotationType())) continue;
                    if (this.typeUtils.isSameType(qualifierAnnotationType, this.namedAnnotationTypeMirror)) {
                        NamedGem named = NamedGem.instanceOn(qualifierAnnotationMirror);
                        if (!named.value().hasValue() || !qualfiedByNames.contains(named.value().get())) continue block2;
                        ++matchingQualifierCounter;
                        continue block2;
                    }
                    ++matchingQualifierCounter;
                    continue block2;
                }
            }
            if (matchingQualifierCounter != numberOfQualifiersToMatch) continue;
            matches.add(candidate);
        }
        return matches;
    }

    private Set<AnnotationMirror> getQualifierAnnotationMirrors(Method candidate) {
        HashSet<AnnotationMirror> qualiferAnnotations = new HashSet<AnnotationMirror>();
        SourceMethod candidateSM = (SourceMethod)candidate;
        List<? extends AnnotationMirror> methodAnnotations = candidateSM.getExecutable().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : methodAnnotations) {
            this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
        }
        Type mapper = candidate.getDeclaringMapper();
        if (mapper != null) {
            List<? extends AnnotationMirror> list = mapper.getTypeElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
            }
        }
        return qualiferAnnotations;
    }

    private void addOnlyWhenQualifier(Set<AnnotationMirror> annotationSet, AnnotationMirror candidate) {
        if (QualifierGem.instanceOn(candidate.getAnnotationType().asElement()) != null) {
            annotationSet.add(candidate);
        }
    }
}

