/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos;

import com.digiwin.configcenter.core.DWOrdered;
import com.digiwin.configcenter.nacos.ConfigCenterPriorityEnum;
import com.digiwin.configcenter.nacos.config.loader.DWConfigLoader;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import com.digiwin.configcenter.nacos.util.DAPNacosConfigPropertyFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class DWNacosEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    static ServiceLoader<DWConfigLoader> loadedService = null;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        DAPNacosConfigProperty dapNacosConfigProperty = DAPNacosConfigPropertyFactory.getDAPNacosConfigProperty(environment);
        if (dapNacosConfigProperty == null || !dapNacosConfigProperty.isEnable()) {
            System.out.println("DWNacosEnvironmentPostProcessor enable false");
            return;
        }
        ConfigCenterPriorityEnum configCenterPriorityEnum = null;
        try {
            configCenterPriorityEnum = ConfigCenterPriorityEnum.valueOf(dapNacosConfigProperty.getPriority());
        }
        catch (Exception e) {
            System.out.println("Illegal priority");
            return;
        }
        ArrayList<DWConfigLoader> serviceList = new ArrayList<DWConfigLoader>();
        loadedService.forEach(serviceList::add);
        if ("BEFORE".equals(configCenterPriorityEnum.getLocation())) {
            serviceList.sort(Comparator.comparing(DWOrdered::getOrder));
        } else {
            serviceList.sort(Comparator.comparing(DWOrdered::getOrder).reversed());
        }
        for (int i = 0; i < serviceList.size(); ++i) {
            DWConfigLoader dwConfigLoader = (DWConfigLoader)serviceList.get(i);
            dwConfigLoader.loadConfig(environment, dapNacosConfigProperty);
        }
    }

    static {
        loadedService = ServiceLoader.load(DWConfigLoader.class);
    }
}

