/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.config.loader;

import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.digiwin.configcenter.nacos.ConfigCenterPriorityEnum;
import com.digiwin.configcenter.nacos.DWConfigFile;
import com.digiwin.configcenter.nacos.config.loader.DWConfigLoader;
import com.digiwin.configcenter.nacos.factory.DWNacosConfigFactory;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import com.digiwin.configcenter.nacos.propertysource.DWPropertySource;
import com.digiwin.configcenter.nacos.propertysource.DWRefreshableNacosPropertySource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public abstract class AbstractConfigLoader
implements DWConfigLoader {
    private static final Log logger = LogFactory.getLog(AbstractConfigLoader.class);
    private Map<String, DWRefreshableNacosPropertySource> refreshablePropertySourceMap = new ConcurrentHashMap<String, DWRefreshableNacosPropertySource>();

    public void addDWRefreshableNacosPropertySource(String propertySourceName, DWRefreshableNacosPropertySource refreshableNacosPropertySource) {
        this.refreshablePropertySourceMap.put(propertySourceName, refreshableNacosPropertySource);
    }

    @Override
    public void loadConfig(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        ArrayList<DWPropertySource> dwPropertySourceList = new ArrayList<DWPropertySource>();
        List<DWConfigFile> dwConfigFiles = this.getConfigFile(environment, dapNacosConfigProperty);
        for (DWConfigFile configFile : dwConfigFiles) {
            if (configFile.skip()) {
                System.out.println("skip configFile :" + configFile);
                continue;
            }
            Properties loadProperties = this.buildBaseProperties(environment, dapNacosConfigProperty);
            loadProperties.setProperty("namespace", configFile.getNameSpace());
            try {
                ConfigService configService = DWNacosConfigFactory.createConfigService(loadProperties);
                String config = configService.getConfig(configFile.getName(), configFile.getGroup(), this.getConfigtimeout(environment, dapNacosConfigProperty));
                String propertySourceName = this.getpropertySourceName(configFile);
                DWPropertySource dapPropertySource = new DWPropertySource(propertySourceName, config, configFile.getType().toUpperCase(), configFile.getGroup(), configFile.getName(), configFile, Boolean.valueOf(configFile.getAutoRefresh()));
                dwPropertySourceList.add(dapPropertySource);
                this.addDWRefreshableNacosPropertySource(propertySourceName, new DWRefreshableNacosPropertySource(dapPropertySource, environment, loadProperties));
            }
            catch (Exception e) {
                System.out.println(this.getClass().getName() + "load config fail configFile: " + configFile);
                System.out.println("Exception:" + e);
                for (StackTraceElement stackTraceElement : e.getStackTrace()) {
                    System.out.println("" + stackTraceElement);
                }
                throw new RuntimeException(this.getClass().getName() + "load config fail configFile: " + configFile + " ,e: " + e);
            }
        }
        for (DWPropertySource dwPropertySource : dwPropertySourceList) {
            this.addEnviroment(environment, dwPropertySource, ConfigCenterPriorityEnum.valueOf(dapNacosConfigProperty.getPriority()));
        }
        this.enableAutoRefreshed();
    }

    public void enableAutoRefreshed() {
        for (Map.Entry<String, DWRefreshableNacosPropertySource> entry : this.refreshablePropertySourceMap.entrySet()) {
            final DWRefreshableNacosPropertySource refreshableNacosPropertySource = entry.getValue();
            if (!refreshableNacosPropertySource.getDwPropertySource().isAutoRefreshed()) continue;
            AbstractListener listener = new AbstractListener(){

                public void receiveConfigInfo(String configInfo) {
                    logger.info((Object)("config changed configFile:" + refreshableNacosPropertySource.getDwPropertySource().getConfigFile() + ",configInfo:" + configInfo));
                    ConfigurableEnvironment environment = refreshableNacosPropertySource.getEnvironment();
                    DWPropertySource dwPropertySource = refreshableNacosPropertySource.getDwPropertySource();
                    DWPropertySource newDWPropertySource = new DWPropertySource(dwPropertySource.getName(), configInfo, dwPropertySource.getType(), dwPropertySource.getGroupId(), dwPropertySource.getDataId(), dwPropertySource.getConfigFile(), dwPropertySource.isAutoRefreshed());
                    environment.getPropertySources().replace(dwPropertySource.getName(), (PropertySource)newDWPropertySource);
                }
            };
            try {
                ConfigService configService = DWNacosConfigFactory.createConfigService(refreshableNacosPropertySource.getProperties());
                String dataId = refreshableNacosPropertySource.getDwPropertySource().getDataId();
                String groupId = refreshableNacosPropertySource.getDwPropertySource().getGroupId();
                configService.addListener(dataId, groupId, (Listener)listener);
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Properties buildBaseProperties(ConfigurableEnvironment environment, DAPNacosConfigProperty nacosConfigProperty) {
        Properties baseProperties = nacosConfigProperty.buildProperties();
        return baseProperties;
    }

    public void addEnviroment(ConfigurableEnvironment environment, DWPropertySource propertySource, ConfigCenterPriorityEnum configCenterPriority) {
        if (environment.getPropertySources().contains(propertySource.getName())) {
            environment.getPropertySources().replace(propertySource.getName(), (PropertySource)propertySource);
        } else if ("BEFORE".equals(configCenterPriority.getLocation())) {
            environment.getPropertySources().addBefore(configCenterPriority.getPivot(), (PropertySource)propertySource);
        } else {
            environment.getPropertySources().addAfter(configCenterPriority.getPivot(), (PropertySource)propertySource);
        }
    }

    public abstract String getNameSpace(ConfigurableEnvironment var1);

    public final long getConfigtimeout(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        return StringUtils.isNumeric((CharSequence)dapNacosConfigProperty.getConfigRequestTimeOut()) ? Long.parseLong(dapNacosConfigProperty.getConfigRequestTimeOut()) : 5000L;
    }

    abstract List<DWConfigFile> getConfigFile(ConfigurableEnvironment var1, DAPNacosConfigProperty var2);

    abstract String getpropertySourceName(DWConfigFile var1);
}

