/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.config.loader;

import com.digiwin.configcenter.DWConfigTypeEnum;
import com.digiwin.configcenter.nacos.DWConfigFile;
import com.digiwin.configcenter.nacos.config.loader.AbstractConfigLoader;
import com.digiwin.configcenter.nacos.config.loader.PlatformConfigLoader;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class GroupConfigLoader
extends AbstractConfigLoader {
    public static final Integer CONFIG_ORDER = PlatformConfigLoader.CONFIG_ORDER - 1000;
    public static final String DAP_GROUP_REMOTE_CONFIG_PREFIX = "dap.group.remote.config.";

    @Override
    List<DWConfigFile> getConfigFile(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        String nameSpace = environment.getProperty("configGroupName");
        String group = environment.getProperty("SMALLVERSION");
        String groupautorefreshStr = environment.getProperty("dap.configcenter.group.autorefresh", "false");
        Boolean groupautorefresh = StringUtils.isNotBlank((CharSequence)groupautorefreshStr) ? Boolean.valueOf(groupautorefreshStr).booleanValue() : dapNacosConfigProperty.isAutoRefresh();
        String finalautorefreshStr = Boolean.toString(groupautorefresh);
        String configTypeStr = environment.getProperty("dap.configcenter.file.type", "JSON");
        String configType = DWConfigTypeEnum.valueOfTypeName(configTypeStr).name();
        ArrayList<DWConfigFile> dwConfigFiles = new ArrayList<DWConfigFile>();
        String groupedDataIds = environment.getProperty("dap.configcenter.group.configs", "mq.json,httpclient.json,common.json");
        for (String dataId : groupedDataIds.split(",")) {
            String resolvedDataId = environment.resolvePlaceholders(dataId);
            DWConfigFile dwConfigFile = new DWConfigFile(nameSpace, group, resolvedDataId, configType, finalautorefreshStr);
            dwConfigFiles.add(dwConfigFile);
        }
        return dwConfigFiles;
    }

    @Override
    String getpropertySourceName(DWConfigFile configFile) {
        return "dap.group.remote.config.#@#" + configFile.getGroup() + "#@#" + configFile.getName();
    }

    @Override
    public String getNameSpace(ConfigurableEnvironment environment) {
        return environment.getProperty("configGroupName");
    }

    @Override
    public int getOrder() {
        return CONFIG_ORDER;
    }
}

