/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.configcenter.nacos.config.loader;

import com.digiwin.configcenter.DWConfigTypeEnum;
import com.digiwin.configcenter.nacos.DWConfigFile;
import com.digiwin.configcenter.nacos.config.loader.AbstractConfigLoader;
import com.digiwin.configcenter.nacos.properties.DAPNacosConfigProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.env.ConfigurableEnvironment;

public class PlatformConfigLoader
extends AbstractConfigLoader {
    public static final String PLATFORM_NAMESPACE = "dap";
    public static final Integer CONFIG_ORDER = 2147482647;
    public static final String DAP_PLATFORM_REMOTE_CONFIG_PREFIX = "dap.platform.remote.config.";

    @Override
    public String getNameSpace(ConfigurableEnvironment environment) {
        return PLATFORM_NAMESPACE;
    }

    @Override
    List<DWConfigFile> getConfigFile(ConfigurableEnvironment environment, DAPNacosConfigProperty dapNacosConfigProperty) {
        ArrayList<DWConfigFile> dwConfigFiles = new ArrayList<DWConfigFile>();
        String platformGroup = environment.getProperty("PLATFORM");
        String platformautorefreshStr = environment.getProperty("dap.configcenter.platform.autorefresh", "false");
        Boolean platformautorefresh = StringUtils.isNotBlank((CharSequence)platformautorefreshStr) ? Boolean.valueOf(platformautorefreshStr).booleanValue() : dapNacosConfigProperty.isAutoRefresh();
        String finalautorefreshStr = Boolean.toString(platformautorefresh);
        String configTypeStr = environment.getProperty("dap.configcenter.file.type", "JSON");
        String configType = DWConfigTypeEnum.valueOfTypeName(configTypeStr).name();
        String platformDataIds = environment.getProperty("dap.configcenter.platform.configs", "dap_platform_backend");
        for (String dataId : platformDataIds.split(",")) {
            String resolvedDataId = environment.resolvePlaceholders(dataId);
            DWConfigFile dwConfigFile = new DWConfigFile(PLATFORM_NAMESPACE, platformGroup, resolvedDataId, configType, finalautorefreshStr);
            dwConfigFiles.add(dwConfigFile);
        }
        return dwConfigFiles;
    }

    @Override
    String getpropertySourceName(DWConfigFile configFile) {
        return "dap.platform.remote.config.#@#" + configFile.getGroup() + "#@#" + configFile.getName();
    }

    @Override
    public int getOrder() {
        return CONFIG_ORDER;
    }
}

