/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.datasource.utils;

import com.dap.component.dao.api.ApplicationPropertiesProvider;
import com.dap.component.dao.api.CurrentModuleNameProvider;
import com.dap.component.dao.api.ModulePropertiesProvider;
import com.digiwin.app.module.spring.SpringContextUtils;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DWMultipleDataSourcePropertiesUtil {
    private static Log _log = LogFactory.getLog(DWMultipleDataSourcePropertiesUtil.class);
    private static String _CLASSTAG = "[DWMultipleDataSourcePropertiesUtil] ";
    private static String paramFileName = "module";
    private static DWMultipleDataSourcePropertiesUtil multipleDataSourceUtil = new DWMultipleDataSourcePropertiesUtil();
    private static final String APPLICATION_CONFIG_PROPERTIES = "application";

    public static DWMultipleDataSourcePropertiesUtil paramFileName(String paramFileName) {
        DWMultipleDataSourcePropertiesUtil.paramFileName = paramFileName;
        return multipleDataSourceUtil;
    }

    public static String getSqlByParamKey(String key, String ... params) {
        String queryModuleName;
        if (params != null && params.length > 0) {
            queryModuleName = params[0];
        } else {
            CurrentModuleNameProvider currentModuleNameProvider = (CurrentModuleNameProvider)SpringContextUtils.getBean(CurrentModuleNameProvider.class);
            queryModuleName = currentModuleNameProvider.get();
        }
        String propertiesName = "module";
        String daoMultipleDataSourceSupport = "";
        if (queryModuleName != null) {
            ModulePropertiesProvider modulePropertiesProvider = (ModulePropertiesProvider)SpringContextUtils.getBean(ModulePropertiesProvider.class);
            daoMultipleDataSourceSupport = modulePropertiesProvider.getValue(propertiesName, queryModuleName, key);
        } else {
            ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
            daoMultipleDataSourceSupport = applicationPropertiesProvider.getValue(propertiesName, key);
        }
        return daoMultipleDataSourceSupport;
    }

    public static Properties getMultipleDataSourceConfig() {
        CurrentModuleNameProvider currentModuleNameProvider = (CurrentModuleNameProvider)SpringContextUtils.getBean(CurrentModuleNameProvider.class);
        String currentModuleName = currentModuleNameProvider.get();
        Properties configData = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceConfig(currentModuleName);
        return configData;
    }

    public static Properties getMultipleDataSourceProperties(String moduleName) {
        Properties result = null;
        if (StringUtils.isNotBlank((CharSequence)moduleName)) {
            ModulePropertiesProvider modulePropertiesProvider = (ModulePropertiesProvider)SpringContextUtils.getBean(ModulePropertiesProvider.class);
            result = modulePropertiesProvider.get(paramFileName, moduleName);
        } else {
            ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
            result = applicationPropertiesProvider.get(APPLICATION_CONFIG_PROPERTIES);
        }
        return result;
    }

    public static Properties getMultipleDataSourceConfig(String moduleName) {
        String propertiesFileName = "";
        if (moduleName != null) {
            ModulePropertiesProvider modulePropertiesProvider = (ModulePropertiesProvider)SpringContextUtils.getBean(ModulePropertiesProvider.class);
            propertiesFileName = modulePropertiesProvider.getValue(paramFileName, moduleName, "daoMultipleDataSourceConfigProperties", "datasource-config.yaml");
        } else {
            ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
            propertiesFileName = applicationPropertiesProvider.getValue(paramFileName, "daoMultipleDataSourceConfigProperties", "datasource-config.yaml");
        }
        Properties configData = DWMultipleDataSourcePropertiesUtil.getProperties(propertiesFileName);
        return configData;
    }

    public static Properties getMultipleDataSourceTenant() {
        CurrentModuleNameProvider currentModuleNameProvider = (CurrentModuleNameProvider)SpringContextUtils.getBean(CurrentModuleNameProvider.class);
        String currentModuleName = currentModuleNameProvider.get();
        Properties tenantData = DWMultipleDataSourcePropertiesUtil.getMultipleDataSourceTenant(currentModuleName);
        return tenantData;
    }

    public static Properties getMultipleDataSourceTenant(String moduleName) {
        String propertiesFileName = "";
        if (moduleName != null) {
            ModulePropertiesProvider modulePropertiesProvider = (ModulePropertiesProvider)SpringContextUtils.getBean(ModulePropertiesProvider.class);
            propertiesFileName = modulePropertiesProvider.getValue(paramFileName, moduleName, "daoMultipleDataSourceTenantProperties", "datasource-tenant.yaml");
        } else {
            ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
            propertiesFileName = applicationPropertiesProvider.getValue(paramFileName, "daoMultipleDataSourceTenantProperties", "datasource-tenant.yaml");
        }
        Properties tenantData = DWMultipleDataSourcePropertiesUtil.getProperties(propertiesFileName);
        return tenantData;
    }

    public static String getParamFileName() {
        return paramFileName;
    }

    private static Properties getProperties(String propertiesFileName) {
        Properties result = new Properties();
        if (StringUtils.isNotBlank((CharSequence)propertiesFileName)) {
            ApplicationPropertiesProvider applicationPropertiesProvider = (ApplicationPropertiesProvider)SpringContextUtils.getBean(ApplicationPropertiesProvider.class);
            result = applicationPropertiesProvider.get(DWMultipleDataSourcePropertiesUtil.removeExtensionName(propertiesFileName));
        }
        return result;
    }

    private static String removeExtensionName(String fileName) {
        if (fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.indexOf("."));
        }
        return fileName;
    }
}

