/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.data;

import java.util.HashSet;
import java.util.Set;

public class DWDataTableStatementOption {
    private Set<DWDataTableStatement> tableItems = new HashSet<DWDataTableStatement>();
    private DWDataTableStatement globalItem = new DWDataTableStatement("*");

    public void enableBatchMode() {
        this.setBatchMode(true, false);
    }

    public void enableBatchModeAndReturnGeneratedKeys() {
        this.setBatchMode(true, true);
    }

    public void enableBatchMode(String tableNameOrAsterisk) {
        this.setBatchMode(tableNameOrAsterisk, true, false);
    }

    public void enableBatchModeAndReturnGeneratedKeys(String tableNameOrAsterisk) {
        this.setBatchMode(tableNameOrAsterisk, true, true);
    }

    private void setBatchMode(boolean batchMode, boolean returnGeneratedKeys) {
        this.setBatchMode("*", batchMode, returnGeneratedKeys);
    }

    private void setBatchMode(String tableNameOrAsterisk, boolean batchMode, boolean returnGeneratedKeys) {
        boolean notExist;
        if (tableNameOrAsterisk == null) {
            throw new IllegalArgumentException("tableNameOrAsterisk is null!");
        }
        DWDataTableStatement statement = this.getDWDataTableStatement(tableNameOrAsterisk, false);
        boolean bl = notExist = statement == null;
        if (notExist) {
            statement = new DWDataTableStatement(tableNameOrAsterisk);
            if ("*".equalsIgnoreCase(tableNameOrAsterisk)) {
                this.globalItem = statement;
            } else {
                this.tableItems.add(statement);
            }
        }
        statement.batchMode = batchMode;
        statement.returnGeneratedKeys = returnGeneratedKeys;
    }

    private DWDataTableStatement getDWDataTableStatement(String tableName, boolean returnGlobalItemIfNotExists) {
        DWDataTableStatement statement = this.tableItems.stream().filter(item -> ((DWDataTableStatement)item).tableName.equalsIgnoreCase(tableName)).findFirst().orElse(null);
        if (statement == null && returnGlobalItemIfNotExists) {
            return this.globalItem;
        }
        return statement;
    }

    public boolean isBatchMode(String tableName) {
        return this.getDWDataTableStatement(tableName, true).batchMode;
    }

    public boolean isReturnGeneratedKeys(String tableName) {
        return this.getDWDataTableStatement(tableName, true).returnGeneratedKeys;
    }

    private class DWDataTableStatement {
        private String tableName;
        private boolean batchMode = false;
        private boolean returnGeneratedKeys = true;

        public DWDataTableStatement(String tableNameOrAsterisk) {
            if (tableNameOrAsterisk == null) {
                throw new IllegalArgumentException("tableNameOrAsterisk is null!");
            }
            this.tableName = tableNameOrAsterisk;
        }
    }
}

