/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao.dialect;

import com.digiwin.app.dao.DWDataRowSqlInfo;
import com.digiwin.app.dao.DWDataSetSqlInfo;
import com.digiwin.app.dao.DWOn;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWOnCondition;
import com.digiwin.app.dao.DWOnFromTableCondition;
import com.digiwin.app.dao.DWOnJoinTableCondition;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPlainTextConditionValue;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryElement;
import com.digiwin.app.dao.DWQueryExists;
import com.digiwin.app.dao.DWQueryField;
import com.digiwin.app.dao.DWQueryGroupBy;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryJoin;
import com.digiwin.app.dao.DWQueryJoinOnColumn;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryNotExists;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSqlInfo;
import com.digiwin.app.dao.DWSubQueryInfo;
import com.digiwin.app.dao.DWSubQueryJoin;
import com.digiwin.app.dao.DWUnionInfo;
import com.digiwin.app.dao.basic.DWDataSetOperationOptionBuilder;
import com.digiwin.app.dao.dialect.DWSQLDialect;
import com.digiwin.app.dao.dialect.DWSQLParseInfo;
import com.digiwin.app.dao.filter.DWSQLFilterChain;
import com.digiwin.app.data.DWAutoIncrementOption;
import com.digiwin.app.data.DWDataOptimisticLockingInfo;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataRowCondition;
import com.digiwin.app.data.DWDataRowState;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWSQLOptionsBuilder;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataException;
import com.digiwin.app.data.exceptions.ExecuteException;
import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.DWValueAttribute;
import com.digiwin.app.metadata.rdbms.DWRdbmsAttributes;
import com.digiwin.app.metadata.rdbms.DWRdbmsField;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import com.digiwin.app.metadata.rdbms.DWRdbmsRelationshipAttribute;
import com.digiwin.app.module.spring.SpringContextUtils;
import com.digiwin.utils.DWTenantUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public abstract class DWCommonSQLDialect
implements DWSQLDialect {
    private static Log log = LogFactory.getLog(DWCommonSQLDialect.class);
    @Deprecated
    private static boolean tenantEnabled = DWTenantUtils.isTenantenabled();
    private static String custFieldPrefix = "cust_field$.";
    private static final String OPTION_IGNORE_ORDER_BY = "optionIgnoreOrderBy";
    protected DWSQLFilterChain dwsqlFilterChain = (DWSQLFilterChain)SpringContextUtils.getBean((String)"dw-sqlFilterChain");

    protected abstract void attachPageSQLInfo(StringBuilder var1, List<Object> var2, int var3, int var4);

    @Deprecated
    public static DWDataSetOperationOption createDefaultOption() {
        DWDataSetOperationOption defaultOption = new DWDataSetOperationOption();
        defaultOption.setTenantEnabled(tenantEnabled);
        defaultOption.setRelatedTableTenantEnabled(tenantEnabled);
        return defaultOption;
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo queryInfo) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parseCount(option, queryInfo, null);
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo queryInfo, DWDataSetOperationOption option) {
        return this.parseCount(option, queryInfo, null);
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo queryInfo, String sql) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parseCount(option, queryInfo, sql);
    }

    @Override
    public DWSqlInfo parseCount(DWPagableQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        return this.parseCount(option, queryInfo, sql);
    }

    @Override
    public DWSqlInfo parseCount(DWDataSetOperationOption option, DWPagableQueryInfo pagableQueryInfo, String sql) {
        option.set(OPTION_IGNORE_ORDER_BY, true);
        DWSqlInfo sqlInfo = this.parse(option, (DWQueryInfo)pagableQueryInfo, sql);
        option.set(OPTION_IGNORE_ORDER_BY, false);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(1) FROM (").append(sqlInfo.getSql()).append(") AS DWSQLDialect_Count");
        sqlInfo.setSqlAndParameters(sb.toString(), sqlInfo.getParametersAsList());
        return sqlInfo;
    }

    private DWSqlInfo parseFieldSql(DWDataSetOperationOption option, DWQueryInfo queryInfo, boolean checkVersion) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        LinkedHashSet<String> selectFields = new LinkedHashSet<String>();
        for (Object field2 : queryInfo.getSelectObjects()) {
            if (field2 instanceof String) {
                selectFields.add((String)field2);
                continue;
            }
            if (!(field2 instanceof DWQueryInfo)) continue;
            DWSqlInfo subQueryInfo = this.parseSubQuery(option, (DWSubQueryInfo)field2);
            selectFields.add(subQueryInfo.getSql());
            parameters.addAll(subQueryInfo.getParametersAsList());
        }
        if (checkVersion) {
            boolean exist;
            DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(queryInfo.getTableName(), DWRdbmsMetadata.class);
            String versionField = metadata.getVersionControl();
            boolean bl = exist = versionField == null ? true : selectFields.stream().anyMatch(field -> versionField.equalsIgnoreCase((String)field));
            if (!exist) {
                selectFields.add(versionField);
            }
        }
        return new DWSqlInfo(String.join((CharSequence)",", selectFields), parameters);
    }

    private DWSqlInfo parseSelectFieldsSql(DWDataSetOperationOption option, DWQueryInfo queryInfo) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean autoSelectVersion = option.isSelectVersionFieldEnabled();
        if (queryInfo.isDistinct()) {
            sb.append(" DISTINCT ");
            autoSelectVersion = false;
        }
        if (queryInfo.isSelectAll()) {
            HashMap<String, Object> queryFieldsMap = new HashMap<String, Object>();
            DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(queryInfo.getTableName(), DWRdbmsMetadata.class);
            for (DWRdbmsField metadataField : metadata.getFields()) {
                queryFieldsMap.put(metadataField.getName(), metadataField.getName());
            }
            String[] aliasArr = new String[2];
            if (queryInfo.getSelectObjects().size() > 0) {
                for (Object queryField : queryInfo.getSelectObjects()) {
                    aliasArr = ((String)queryField).split(" ");
                    queryFieldsMap.put(aliasArr[0], aliasArr[0] + " AS " + aliasArr[1]);
                }
            }
            for (Object key : queryFieldsMap.keySet()) {
                sb.append((String)queryFieldsMap.get(key) + ", ");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
        } else if (queryInfo.getSelectObjects().size() > 0) {
            DWSqlInfo fieldInfo = this.parseFieldSql(option, queryInfo, autoSelectVersion);
            sb.append(fieldInfo.getSql());
            parameters.addAll(fieldInfo.getParametersAsList());
        } else {
            sb.append(" * ");
        }
        return new DWSqlInfo(sb.toString(), parameters);
    }

    protected DWSqlInfo parseSelectSql(DWDataSetOperationOption option, DWQueryInfo queryInfo) {
        if (null == queryInfo) {
            throw new DWDataException("queryInfo cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        sb.append("SELECT ");
        DWSqlInfo selectFieldSqlInfo = this.parseSelectFieldsSql(option, queryInfo);
        sb.append(selectFieldSqlInfo.getSql());
        parameters.addAll(selectFieldSqlInfo.getParametersAsList());
        sb.append(" FROM ");
        if (queryInfo.getFromInfo() == null) {
            sb.append(queryInfo.getTableName());
        } else {
            DWSqlInfo subQueryInfo = this.parseSubQuery(option, queryInfo.getFromInfo());
            sb.append(subQueryInfo.getSql());
            parameters.addAll(subQueryInfo.getParametersAsList());
        }
        sb.append(" ");
        return new DWSqlInfo(sb.toString(), parameters);
    }

    private DWSqlInfo parseSubQuery(DWDataSetOperationOption option, DWSubQueryInfo subQueryInfo) {
        DWSqlInfo sqlInfo = this.parse(option, subQueryInfo, null);
        StringBuilder s = new StringBuilder();
        s.append("(").append(sqlInfo.getSql()).append(")");
        String aliasName = subQueryInfo.getAliasName();
        if (aliasName != null && aliasName.length() > 0) {
            s.append(" ").append(aliasName);
        }
        sqlInfo.setSqlAndParameters(s.toString(), sqlInfo.getParametersAsList());
        return sqlInfo;
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, queryInfo, null);
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo, String sql) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, queryInfo, sql);
    }

    @Override
    public DWSqlInfo parse(DWQueryInfo queryInfo, String sql, DWDataSetOperationOption option) {
        return this.parse(option, queryInfo, sql);
    }

    @Override
    public DWSqlInfo parse(DWDataSetOperationOption option, DWQueryInfo queryInfo, String sql) {
        boolean isIgnoreOrderBy;
        DWQueryGroupBy groupBy;
        boolean hasUserCustomSQL;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean bl = hasUserCustomSQL = sql != null && !sql.isEmpty();
        if (!hasUserCustomSQL) {
            DWSqlInfo selectSqlInfo = this.parseSelectSql(option, queryInfo);
            sql = selectSqlInfo.getSql();
            parameters.addAll(selectSqlInfo.getParametersAsList());
        }
        String sqlWithNoWhereOrGroupClause = sql;
        sqlBuilder.append(sql);
        this.dwsqlFilterChain.doFilter(queryInfo, (IDWSQLOptions)option);
        queryInfo.getCondition().setTableName(queryInfo.getTableName());
        DWSqlInfo conditionSqlInfo = this.parse(option, queryInfo.getCondition(), queryInfo.getFixedCondition());
        if (conditionSqlInfo != null) {
            boolean hasWhere;
            boolean bl2 = hasWhere = hasUserCustomSQL ? sql.toUpperCase().contains(" WHERE ") : false;
            if (hasWhere) {
                sqlBuilder.append(" ").append(queryInfo.getCondition().getJoinOperator()).append(" ");
            } else {
                sqlBuilder.append(" WHERE ");
            }
            sqlBuilder.append(conditionSqlInfo.getSql());
            parameters.addAll(conditionSqlInfo.getParametersAsList());
        }
        if ((groupBy = queryInfo.getGroupBy()) != null && !CollectionUtils.isEmpty(groupBy.getFields())) {
            List<String> groupFields = groupBy.getFields();
            sqlBuilder.append(" GROUP BY ").append(String.join((CharSequence)",", groupFields.toArray(new String[groupFields.size()])));
            if (!CollectionUtils.isEmpty(groupBy.getHavingCondition().getItems())) {
                DWSqlInfo havingSqlInfo = this.parse(option, groupBy.getHavingCondition());
                sqlBuilder.append(" HAVING " + havingSqlInfo.getSql());
                parameters.addAll(havingSqlInfo.getParametersAsList());
            }
        }
        Object parsedSql = sqlBuilder.toString();
        LinkedList<Object> joinParameters = new LinkedList<Object>();
        parsedSql = this.attachJoin(option, (String)parsedSql, queryInfo, joinParameters, sqlWithNoWhereOrGroupClause);
        String[] sqlParts = ((String)parsedSql).toUpperCase().split(" JOIN ");
        int count = Long.valueOf(sqlParts[0].chars().filter(ch -> ch == 63).count()).intValue();
        ArrayList<Object> newParameters = new ArrayList<Object>();
        if (count == 0) {
            for (Object parameter : joinParameters) {
                newParameters.add(parameter);
            }
            for (Object parameter : parameters) {
                newParameters.add(parameter);
            }
        } else {
            for (int i = 0; i < parameters.size(); ++i) {
                newParameters.add(parameters.get(i));
                if (i + 1 != count) continue;
                for (Object e : joinParameters) {
                    newParameters.add(e);
                }
            }
        }
        List<DWUnionInfo> unions = queryInfo.getUnions();
        for (DWUnionInfo dWUnionInfo : unions) {
            DWSqlInfo unionResultInfo = this.parse(option, dWUnionInfo.getQueryInfo(), sql);
            parsedSql = (String)parsedSql + " " + dWUnionInfo.getOpeartor().getValue() + " " + unionResultInfo.getSql();
            newParameters.addAll(unionResultInfo.getParametersAsList());
        }
        boolean bl3 = isIgnoreOrderBy = option.get(OPTION_IGNORE_ORDER_BY) == null ? false : (Boolean)option.get(OPTION_IGNORE_ORDER_BY);
        if (!isIgnoreOrderBy && null != queryInfo.getOrderfields() && !queryInfo.getOrderfields().isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder((String)parsedSql);
            stringBuilder.append(" ORDER BY ");
            for (DWQueryOrderby queryOrderbyMap : queryInfo.getOrderfields()) {
                String fieldName = queryOrderbyMap.getName();
                if (fieldName.startsWith(custFieldPrefix)) {
                    String searchCustFieldKey = this.custFieldSqlForEqual(fieldName);
                    stringBuilder.append(searchCustFieldKey + " " + queryOrderbyMap.getOrderby()).append(",");
                    continue;
                }
                stringBuilder.append(queryOrderbyMap.getName()).append(" ").append(queryOrderbyMap.getOrderby()).append(",");
            }
            if (queryInfo.getOrderfields().size() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.lastIndexOf(","));
            }
            parsedSql = stringBuilder.toString();
        }
        DWSqlInfo dWSqlInfo = new DWSqlInfo((String)parsedSql, newParameters);
        return dWSqlInfo;
    }

    @Override
    public DWSqlInfo parse(DWPagableQueryInfo pagableQueryInfo) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, pagableQueryInfo, null);
    }

    @Override
    public DWSqlInfo parse(DWPagableQueryInfo pagableQueryInfo, String sql) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, pagableQueryInfo, sql);
    }

    @Override
    public DWSqlInfo parse(DWPagableQueryInfo pagableQueryInfo, String sql, DWDataSetOperationOption option) {
        return this.parse(option, pagableQueryInfo, sql);
    }

    @Override
    public DWSqlInfo parse(DWDataSetOperationOption option, DWPagableQueryInfo pagableQueryInfo, String sql) {
        DWSqlInfo queryInfoSqlInfo = this.parse(option, (DWQueryInfo)pagableQueryInfo, sql);
        int pageSize = pagableQueryInfo.getPageSize();
        int pageNumber = pagableQueryInfo.getPageNumber();
        String queryInfoSql = queryInfoSqlInfo.getSql();
        List<Object> pagableQuerySqlParameters = queryInfoSqlInfo.getParametersAsList();
        StringBuilder pagableQueryInfoStringBuilder = new StringBuilder(queryInfoSql);
        this.attachPageSQLInfo(pagableQueryInfoStringBuilder, pagableQuerySqlParameters, pageSize, pageNumber);
        DWSqlInfo resultInfo = new DWSqlInfo(pagableQueryInfoStringBuilder.toString(), pagableQuerySqlParameters);
        return resultInfo;
    }

    private DWSqlInfo parse(DWDataSetOperationOption option, DWQueryCondition generalCondition, DWQueryCondition fixedCondition) {
        DWSqlInfo generalSqlInfo = this.parse(option, generalCondition);
        DWSqlInfo fixedSqlInfo = this.parse(option, fixedCondition);
        if (fixedSqlInfo == null && generalSqlInfo == null) {
            return null;
        }
        if (fixedSqlInfo == null) {
            return generalSqlInfo;
        }
        if (generalSqlInfo == null) {
            return fixedSqlInfo;
        }
        String mergedSql = String.format("(%s AND %s)", generalSqlInfo.getSql(), fixedSqlInfo.getSql());
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.addAll(generalSqlInfo.getParametersAsList());
        parameters.addAll(fixedSqlInfo.getParametersAsList());
        DWSqlInfo mergedSqlInfo = new DWSqlInfo(mergedSql, parameters);
        return mergedSqlInfo;
    }

    @Override
    public DWSqlInfo parse(DWQueryCondition condition) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, condition);
    }

    @Override
    public DWSqlInfo parse(DWQueryCondition condition, DWDataSetOperationOption option) {
        return this.parse(option, condition);
    }

    @Override
    public DWSqlInfo parse(DWDataSetOperationOption option, DWQueryCondition condition) {
        if (condition == null || condition.size() == 0) {
            return null;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        boolean hasOtherElementSQL = false;
        sqlBuilder.append("(");
        for (DWQueryElement element : condition.getItems()) {
            DWSqlInfo innerSqlInfo;
            if (element == null) continue;
            if (element instanceof DWQueryCondition) {
                ((DWQueryCondition)element).setTableName(condition.getTableName());
                innerSqlInfo = this.parse(option, (DWQueryCondition)element);
            } else if (element instanceof DWQueryField) {
                ((DWQueryField)element).setTableName(condition.getTableName());
                innerSqlInfo = this.parse(option, (DWQueryField)element);
            } else if (element instanceof DWQueryExists) {
                innerSqlInfo = this.parse(option, (DWQueryExists)element);
            } else {
                throw new NotImplementedException("DWQueryConditionElement->" + element.getClass().getSimpleName() + " not support yet!");
            }
            if (innerSqlInfo == null) continue;
            if (hasOtherElementSQL) {
                sqlBuilder.append(" ").append(condition.getJoinOperator()).append(" ");
            }
            sqlBuilder.append(innerSqlInfo.getSql());
            parameters.addAll(innerSqlInfo.getParametersAsList());
            hasOtherElementSQL = true;
        }
        sqlBuilder.append(")");
        DWSqlInfo sqlInfo = new DWSqlInfo(sqlBuilder.toString(), parameters);
        return sqlInfo;
    }

    private void appendConditionValue(DWDataSetOperationOption option, StringBuilder sqlBuilder, List<Object> sqlParameters, Object conditionValue) {
        if (conditionValue instanceof DWSubQueryInfo) {
            DWSqlInfo sqlInfo = this.parseSubQuery(option, (DWSubQueryInfo)conditionValue);
            sqlBuilder.append(sqlInfo.getSql());
            sqlParameters.addAll(sqlInfo.getParametersAsList());
        } else if (conditionValue instanceof DWPlainTextConditionValue) {
            sqlBuilder.append(((DWPlainTextConditionValue)conditionValue).getPlainText());
        } else {
            sqlBuilder.append("?");
            sqlParameters.add(conditionValue);
        }
    }

    @Override
    public DWSqlInfo parse(DWQueryExists existsInfo) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, existsInfo);
    }

    @Override
    public DWSqlInfo parse(DWQueryExists existsInfo, DWDataSetOperationOption option) {
        return this.parse(option, existsInfo);
    }

    @Override
    public DWSqlInfo parse(DWDataSetOperationOption option, DWQueryExists existsInfo) {
        StringBuilder sqlBuilder = new StringBuilder();
        if (existsInfo instanceof DWQueryNotExists) {
            sqlBuilder.append("NOT EXISTS ");
        } else {
            sqlBuilder.append("EXISTS ");
        }
        DWSubQueryInfo subQueryInfo = existsInfo.getSubQueryInfo();
        DWSqlInfo sqlInfo = this.parseSubQuery(option, subQueryInfo);
        sqlBuilder.append(sqlInfo.getSql());
        return sqlInfo.setSqlAndParameters(sqlBuilder.toString(), sqlInfo.getParametersAsList());
    }

    @Override
    public DWSqlInfo parse(DWQueryField fieldInfo) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parse(option, fieldInfo);
    }

    @Override
    public DWSqlInfo parse(DWQueryField fieldInfo, DWDataSetOperationOption option) {
        return this.parse(option, fieldInfo);
    }

    @Override
    public DWSqlInfo parse(DWDataSetOperationOption option, DWQueryField fieldInfo) {
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        switch (fieldInfo.getOperator()) {
            case BETWEEN: 
            case Between: {
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" BETWEEN ");
                if (fieldInfo.getValues().length < 2) {
                    throw new IllegalArgumentException("Operator [BETWEEEN] values size is less than 2.");
                }
                this.appendConditionValue(option, sqlBuilder, parameters, fieldInfo.getValues()[0]);
                sqlBuilder.append(" AND ");
                this.appendConditionValue(option, sqlBuilder, parameters, fieldInfo.getValues()[1]);
                break;
            }
            case EQUAL: 
            case Equals: {
                String fieldName = fieldInfo.getName();
                if (fieldName.startsWith(custFieldPrefix)) {
                    String searchCustFieldKey = this.custFieldSqlForEqual(fieldName);
                    sqlBuilder.append(searchCustFieldKey);
                } else {
                    sqlBuilder.append(fieldName);
                }
                Object value = fieldInfo.getFirstValue();
                if (value == null) {
                    sqlBuilder.append(" is null");
                    break;
                }
                sqlBuilder.append(" = ");
                this.appendConditionValue(option, sqlBuilder, parameters, value);
                break;
            }
            case NotEquals: {
                sqlBuilder.append(fieldInfo.getName());
                Object value2 = fieldInfo.getFirstValue();
                if (value2 == null) {
                    sqlBuilder.append(" is not null");
                    break;
                }
                sqlBuilder.append(" <> ");
                this.appendConditionValue(option, sqlBuilder, parameters, value2);
                break;
            }
            case LIKE: 
            case Like: 
            case NotLike: 
            case REGEXP: 
            case GreaterThan: 
            case GreaterThanOrEqualTo: 
            case LessThan: 
            case LessThanOrEqualTo: {
                String fieldName = fieldInfo.getName();
                if (fieldName.startsWith(custFieldPrefix)) {
                    String searchCustFieldKey = this.custFieldSqlForEqual(fieldName);
                    sqlBuilder.append(searchCustFieldKey);
                } else {
                    sqlBuilder.append(fieldInfo.getName());
                }
                String sqlOperator = fieldInfo.getOperator().getValue().toUpperCase();
                sqlBuilder.append(" ").append(sqlOperator).append(" ");
                this.appendConditionValue(option, sqlBuilder, parameters, fieldInfo.getFirstValue());
                break;
            }
            case IN: 
            case In: {
                String fieldName = fieldInfo.getName();
                if (fieldName.startsWith(custFieldPrefix)) {
                    String searchInValues = this.custFieldSqlForIn(fieldName, fieldInfo.getValues());
                    sqlBuilder.append(searchInValues);
                    parameters.addAll(Arrays.asList(fieldInfo.getValues()));
                    break;
                }
                if (fieldInfo.getValues().length < 1) {
                    throw new IllegalArgumentException("Operator IN expected at least one value.");
                }
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" IN (");
                if (fieldInfo.getValues()[0] instanceof DWSubQueryInfo) {
                    this.appendConditionValue(option, sqlBuilder, parameters, fieldInfo.getValues()[0]);
                } else {
                    sqlBuilder.append(String.join((CharSequence)", ", Collections.nCopies(fieldInfo.getValues().length, "?")));
                    parameters.addAll(Arrays.asList(fieldInfo.getValues()));
                }
                sqlBuilder.append(")");
                break;
            }
            case NOTIN: 
            case NotIn: {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(fieldInfo.getTableName(), DWRdbmsMetadata.class);
                Collection<String> pkList = metadata.getPrimaryKeys();
                sqlBuilder.append(" NOT EXISTS ( ");
                sqlBuilder.append(" SELECT ");
                sqlBuilder.append(fieldInfo.getName());
                sqlBuilder.append(" FROM ");
                sqlBuilder.append(fieldInfo.getTableName());
                sqlBuilder.append(" AS tb2 WHERE ");
                for (String pk : pkList) {
                    sqlBuilder.append(fieldInfo.getTableName());
                    sqlBuilder.append(".");
                    sqlBuilder.append(pk);
                    sqlBuilder.append(" = tb2.");
                    sqlBuilder.append(pk);
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(" ( ");
                for (Object val : fieldInfo.getValues()) {
                    sqlBuilder.append(" tb2.");
                    sqlBuilder.append(fieldInfo.getName());
                    sqlBuilder.append(" = ? ");
                    parameters.add(val);
                    sqlBuilder.append(" OR");
                }
                sqlBuilder.delete(sqlBuilder.length() - 3, sqlBuilder.length());
                sqlBuilder.append(" )) ");
                break;
            }
            default: {
                throw new NotImplementedException(String.format("%s operator not support yet!", fieldInfo.getOperator().toString()));
            }
        }
        return new DWSqlInfo(sqlBuilder.toString(), parameters);
    }

    @Override
    public DWDataSetSqlInfo parse(DWDataSet dataset, DWDataSetOperationOption option) {
        return this.parse(option, dataset);
    }

    @Override
    public DWDataSetSqlInfo parse(DWDataSetOperationOption option, DWDataSet dataset) {
        DWDataSetSqlInfo datasetSqlInfo = new DWDataSetSqlInfo(dataset, option);
        for (DWDataTable dataTable : dataset.getTables()) {
            DWDataRowSqlInfo rowSqlInfo;
            int index = 0;
            int deleteIndex = 0;
            int updateIndex = 0;
            int creatIndex = 0;
            DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(dataTable.getName(), DWRdbmsMetadata.class);
            DWSQLParseInfo parseInfo = new DWSQLParseInfo(dataTable.getRows().size());
            parseInfo.setBatchMode(option.getTableStatementOption().isBatchMode(dataTable.getName()));
            for (DWDataRow row : dataTable.getRows()) {
                rowSqlInfo = this.parse(option, row, metadata, parseInfo);
                if (rowSqlInfo == null) continue;
                if (row.getState().equals("C")) {
                    index = creatIndex++;
                } else if (row.getState().equals("U")) {
                    index = updateIndex++;
                }
                rowSqlInfo.setRowIndex(index);
                datasetSqlInfo.add(rowSqlInfo);
            }
            Iterator<DWDataRow> removedRows = dataTable.getRows().getIteratorOfRemovedRows();
            while (removedRows.hasNext()) {
                rowSqlInfo = this.parse(option, removedRows.next(), metadata, parseInfo);
                if (rowSqlInfo == null) continue;
                rowSqlInfo.setRowIndex(deleteIndex++);
                datasetSqlInfo.add(rowSqlInfo);
            }
        }
        if (!DWSQLOptionsBuilder.SQL_ORDER_TYPE_NOT_SORT_ACTION.equalsIgnoreCase(option.getSqlOrderTypeOfExecution())) {
            datasetSqlInfo.sort(new DWDataRowSqlInfoComparator(this, datasetSqlInfo, option));
        }
        return datasetSqlInfo;
    }

    @Override
    public DWDataRowSqlInfo parse(DWDataRow row, DWDataSetOperationOption option) {
        return this.parse(option, row);
    }

    @Override
    public DWDataRowSqlInfo parse(DWDataSetOperationOption option, DWDataRow row) {
        String tableName = row.getDataTable().getName();
        DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(tableName, DWRdbmsMetadata.class);
        return this.parse(option, row, metadata, new DWSQLParseInfo(1));
    }

    private DWDataRowSqlInfo parse(DWDataSetOperationOption option, DWDataRow row, DWRdbmsMetadata metadata, DWSQLParseInfo parseInfo) {
        DWDataRowSqlInfo sqlInfo = null;
        switch (row.getState()) {
            case "C": {
                this.dwsqlFilterChain.doFilter(row, (IDWSQLOptions)option);
                parseInfo.setInsert();
                sqlInfo = this.parseInsertSql(option, row, metadata, parseInfo);
                break;
            }
            case "U": {
                this.dwsqlFilterChain.doFilter(row, (IDWSQLOptions)option);
                parseInfo.setUpdate();
                sqlInfo = this.parseUpdateSql(option, row, metadata, parseInfo);
                break;
            }
            case "D": {
                this.dwsqlFilterChain.doFilter(row, (IDWSQLOptions)option);
                parseInfo.setDelete();
                sqlInfo = this.parseDeleteSql(option, row, metadata, parseInfo);
                break;
            }
            default: {
                if (Objects.equals(row.getState(), "")) break;
                throw new DWDataException("13008", String.format("This Operation[%s] is unknown!", row.getState()));
            }
        }
        return sqlInfo;
    }

    private Object processCellValue(DWDataSetOperationOption option, Object cellValue, DWRdbmsField fieldInfo, boolean processDefaultValue) {
        Object processValue = cellValue;
        if (cellValue instanceof DWSubQueryInfo) {
            processValue = this.parseSubQuery(option, (DWSubQueryInfo)cellValue);
        } else if (processDefaultValue && processValue == null && fieldInfo.getDefaultValue() != null) {
            String defaultValue = fieldInfo.getDefaultValue();
            processValue = "NULL".equalsIgnoreCase(defaultValue) ? null : defaultValue;
        }
        if (fieldInfo.isNumericType() && !fieldInfo.isNullable() && (processValue == null || processValue.toString().length() == 0)) {
            processValue = 0;
        }
        return processValue;
    }

    private DWDataRowSqlInfo parseInsertSql(DWDataSetOperationOption option, DWDataRow row, DWRdbmsMetadata metadata, DWSQLParseInfo parseInfo) {
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        Object cellValue = null;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> insertColumnList = new ArrayList<String>();
        DWAutoIncrementOption.DWAutoIncrementSource valueSource = option.getInsertOption().getAutoIncrementOption().getSource(tableName);
        boolean hasAutoIncrementSource = valueSource != null;
        DWAutoIncrementOption.DWAutoIncrementValueProxy[] valueProxys = null;
        List<String> autoIncrementRefColumns = null;
        if (hasAutoIncrementSource) {
            valueProxys = valueSource.getValues();
            autoIncrementRefColumns = Arrays.stream(valueProxys).map(i -> i.getTargetColumn()).collect(Collectors.toList());
            for (String targetColumn : autoIncrementRefColumns) {
                if (dataMap.containsKey(targetColumn)) continue;
                row.set(targetColumn, null);
            }
        } else {
            autoIncrementRefColumns = Collections.emptyList();
        }
        sqlBuilder.append("INSERT INTO ").append(tableName);
        ArrayList<String> valueTextList = new ArrayList<String>();
        for (Map.Entry<String, Object> cell : dataMap.entrySet()) {
            DWRdbmsField rdbmsField;
            String columnName = cell.getKey();
            if (DWDataRowState.isRowStateColumn(columnName) || (cellValue = cell.getValue()) instanceof DWDataRowCollection || (rdbmsField = (DWRdbmsField)metadata.tryGetField(columnName)) == null) continue;
            Object customInsertDefaultValueFromMetadata = option.get("customInsertDefaultValueFromMetadata");
            boolean globalInsertDefaultValueFromMetadata = option.get("insertDefaultValueFromMetadata", false);
            DWValueAttribute metadataAttribute = (DWValueAttribute)metadata.getAttribute(DWRdbmsAttributes.RDBMS_INSERT_DEFAULT_VALUE);
            String metadataInsertDefaultValueFromMetadata = (String)metadataAttribute.getValue();
            boolean selectedInsertDefaultValueFromMetadata = this.chooseDefaultValueSetting(globalInsertDefaultValueFromMetadata, metadataInsertDefaultValueFromMetadata, customInsertDefaultValueFromMetadata);
            cellValue = this.processCellValue(option, cellValue, rdbmsField, selectedInsertDefaultValueFromMetadata);
            insertColumnList.add(columnName);
            if (autoIncrementRefColumns.contains(columnName) && cellValue == null) {
                DWAutoIncrementOption.DWAutoIncrementValueProxy valueProxy = Arrays.stream(valueProxys).filter(s -> s.getTargetColumn().equals(cell.getKey())).findFirst().get();
                params.add(valueProxy);
                valueTextList.add("?");
                continue;
            }
            if (cellValue instanceof DWSqlInfo) {
                DWSqlInfo subSqlInfo = (DWSqlInfo)cellValue;
                params.addAll(subSqlInfo.getParametersAsList());
                valueTextList.add(subSqlInfo.getSql());
                continue;
            }
            params.add(cellValue);
            valueTextList.add("?");
        }
        DWSubQueryInfo subQueryInfo = DWDataRowCondition.getInsertFrom(row);
        if (subQueryInfo == null) {
            sqlBuilder.append("(").append(String.join((CharSequence)", ", insertColumnList)).append(") ").append("VALUES (").append(String.join((CharSequence)", ", valueTextList)).append(")");
        } else {
            DWSqlInfo subSqlInfo = this.parseSubQuery(option, subQueryInfo);
            if (!(insertColumnList.size() == 1 && DWTenantUtils.getTenantColumnName().equals(insertColumnList.get(0)) || insertColumnList.size() == 0)) {
                sqlBuilder.append("(").append(String.join((CharSequence)", ", insertColumnList)).append(") ");
            }
            sqlBuilder.append(subSqlInfo.getSql());
            params.clear();
            params.addAll(subSqlInfo.getParametersAsList());
        }
        DWDataRowSqlInfo sqlInfo = parseInfo.createInsertSqlInfo(metadata, row, sqlBuilder.toString(), params, insertColumnList);
        return sqlInfo;
    }

    public boolean containsIgnoreCase(String str, Collection<String> list) {
        for (String i : list) {
            if (!i.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private DWDataRowSqlInfo parseUpdateSql(DWDataSetOperationOption option, DWDataRow row, DWRdbmsMetadata metadata, DWSQLParseInfo parseInfo) {
        Object cellValue;
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        Collection<String> pkList = metadata.getPrimaryKeys();
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> columnValueOrderList = new ArrayList<String>();
        String versionControlFieldName = metadata.getVersionControl();
        Object currentVersion = null;
        HashMap<String, Object> pkInfo = new HashMap<String, Object>();
        DWDataOptimisticLockingInfo lockingInfo = null;
        sqlBuilder.append("UPDATE ").append(tableName).append(" SET ");
        for (Map.Entry<String, Object> cell : dataMap.entrySet()) {
            DWRdbmsField rdbmsField;
            String columnName = cell.getKey();
            if (DWDataRowState.isRowStateColumn(columnName) || (cellValue = cell.getValue()) instanceof DWDataRowCollection || (rdbmsField = (DWRdbmsField)metadata.tryGetField(columnName)) == null) continue;
            columnName = rdbmsField.getName();
            Object customUpdateDefaultValueFromMetadata = option.get("customUpdateDefaultValueFromMetadata");
            boolean globalUpdateDefaultValueFromMetadata = option.get("updateDefaultValueFromMetadata", false);
            DWValueAttribute metadataAttribute = (DWValueAttribute)metadata.getAttribute(DWRdbmsAttributes.RDBMS_UPDATE_DEFAULT_VALUE);
            String metadataUpdateDefaultValueFromMetadata = (String)metadataAttribute.getValue();
            boolean selectedUpdateDefaultValueFromMetadata = this.chooseDefaultValueSetting(globalUpdateDefaultValueFromMetadata, metadataUpdateDefaultValueFromMetadata, customUpdateDefaultValueFromMetadata);
            cellValue = this.processCellValue(option, cellValue, rdbmsField, selectedUpdateDefaultValueFromMetadata);
            if (versionControlFieldName != null && versionControlFieldName.equalsIgnoreCase(columnName.toLowerCase())) {
                sqlBuilder.append(columnName).append(" = ").append(columnName).append(" + 1,");
                currentVersion = cellValue;
                lockingInfo = new DWDataOptimisticLockingInfo(tableName);
                lockingInfo.setLockingVersion(currentVersion);
                continue;
            }
            if (pkList.contains(cell.getKey())) {
                pkInfo.put(columnName, cellValue);
                continue;
            }
            if (cellValue instanceof DWSqlInfo) {
                DWSqlInfo subSqlInfo = (DWSqlInfo)cellValue;
                sqlBuilder.append(cell.getKey() + " = " + subSqlInfo.getSql() + " ,");
                params.addAll(subSqlInfo.getParametersAsList());
                continue;
            }
            sqlBuilder.append(cell.getKey() + " = ? ,");
            params.add(cellValue);
            columnValueOrderList.add(cell.getKey());
        }
        if (params.size() == 0) {
            log.debug((Object)("this row [" + String.valueOf(row) + "] has no any update field info!"));
            return null;
        }
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(",")).append(" WHERE 1=1 ");
        if (option.getUpdateOption().isEnableBatchCondition() && row.getCondition() != null) {
            DWSqlInfo conditionSqlInfo = this.parse(option, row.getCondition());
            params.addAll(conditionSqlInfo.getParametersAsList());
            sqlBuilder.append("AND ").append(conditionSqlInfo.getSql());
        } else {
            if (pkList.isEmpty()) {
                DWCommonSQLDialect.throwNoPKInMetadataException(tableName);
            }
            for (String pk : pkList) {
                sqlBuilder.append(" AND " + pk + " = ?");
                cellValue = pkInfo.get(pk);
                if (cellValue == null) {
                    if (row.getCondition() == null) {
                        DWCommonSQLDialect.throwPKFieldIsNullException(row, pk);
                    } else {
                        throw new DWDataException("13010", String.format("This row(%s) pk field(%s) value is null!, and it has batchCondition but updateOption isEnableBatchCondition=false", row, pk));
                    }
                }
                params.add(cellValue);
                columnValueOrderList.add(pk);
            }
            if (lockingInfo != null) {
                lockingInfo.setPrimaryKeyInfo(pkInfo);
                sqlBuilder.append(" AND ").append(versionControlFieldName).append(" = ").append("?");
                params.add(currentVersion);
                columnValueOrderList.add(versionControlFieldName);
            }
        }
        DWDataRowSqlInfo sqlInfo = parseInfo.createUpdateSqlInfo(metadata, row, sqlBuilder.toString(), params, columnValueOrderList, lockingInfo);
        return sqlInfo;
    }

    private static void throwNoPKInMetadataException(String tableName) {
        throw new DWDataException("13009", String.format("Table(%s) has no any Primary Key definition!", tableName));
    }

    private static void throwPKFieldIsNullException(DWDataRow row, String pk) {
        throw new DWDataException("13010", String.format("This row(%s) pk field(%s) value is null!", row, pk));
    }

    private DWDataRowSqlInfo parseDeleteSql(DWDataSetOperationOption option, DWDataRow row, DWRdbmsMetadata metadata, DWSQLParseInfo parseInfo) {
        String tableName = row.getDataTable().getName();
        Map<String, Object> dataMap = row.getData();
        DWDataOptimisticLockingInfo lockingInfo = null;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> params = new ArrayList();
        Collection<String> pkList = metadata.getPrimaryKeys();
        sqlBuilder.append("DELETE FROM ").append(tableName).append(" WHERE ");
        if (option.getDeleteOption().isEnableBatchCondition() && row.getCondition() != null) {
            DWSqlInfo conditionSqlInfo = this.parse(option, row.getCondition());
            params = conditionSqlInfo.getParametersAsList();
            sqlBuilder.append(conditionSqlInfo.getSql());
        } else {
            String versionControlFieldName = metadata.getVersionControl();
            if (pkList.isEmpty()) {
                DWCommonSQLDialect.throwNoPKInMetadataException(tableName);
            }
            int i = 0;
            HashMap<String, Object> pkInfo = new HashMap<String, Object>();
            for (String pk : pkList) {
                if (++i != 1) {
                    sqlBuilder.append(" AND ");
                }
                sqlBuilder.append(pk).append(" = ?");
                Optional<String> result = dataMap.keySet().stream().filter(key -> key.equalsIgnoreCase(pk)).findFirst();
                if (result.isPresent()) {
                    Object pkValue = dataMap.get(result.get());
                    params.add(pkValue);
                    pkInfo.put(pk, pkValue);
                    continue;
                }
                DWCommonSQLDialect.throwPKFieldIsNullException(row, pk);
            }
            if (versionControlFieldName != null && dataMap.containsKey(versionControlFieldName)) {
                Object currentVersion = dataMap.get(versionControlFieldName);
                sqlBuilder.append(" AND ");
                sqlBuilder.append(versionControlFieldName).append(" = ?");
                params.add(currentVersion);
                lockingInfo = new DWDataOptimisticLockingInfo(tableName);
                lockingInfo.setLockingVersion(currentVersion);
                lockingInfo.setPrimaryKeyInfo(pkInfo);
            }
        }
        DWDataRowSqlInfo sqlInfo = parseInfo.createDeleteSqlInfo(metadata, row, sqlBuilder.toString(), params, new ArrayList<String>(pkList), lockingInfo);
        return sqlInfo;
    }

    @Override
    public DWSqlInfo parseDeleteSql(String tableName, DWQueryCondition condition) {
        DWDataSetOperationOption option = DWDataSetOperationOptionBuilder.createDefaultOption();
        return this.parseDeleteSql(option, tableName, condition);
    }

    @Override
    public DWSqlInfo parseDeleteSql(DWDataSetOperationOption option, String tableName, DWQueryCondition condition) {
        DWSqlInfo conditionSqlInfo = this.parse(option, condition);
        StringBuilder delSql = new StringBuilder();
        delSql.append("DELETE FROM ").append(tableName).append(" WHERE ").append(conditionSqlInfo.getSql());
        DWSqlInfo sqlInfo = new DWSqlInfo(delSql.toString(), conditionSqlInfo.getParametersAsList());
        return sqlInfo;
    }

    @Override
    public DWSqlInfo parse(String sql, Object ... params) {
        return this.parse(null, sql, params);
    }

    @Override
    public DWSqlInfo parse(IDWSQLOptions option, String sql, Object ... params) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (params != null) {
            parameters.addAll(Arrays.asList(params));
        }
        DWSqlInfo sqlInfo = new DWSqlInfo(sql, parameters);
        this.dwsqlFilterChain.doFilter(sqlInfo, option);
        return sqlInfo;
    }

    private String attachJoin(DWDataSetOperationOption option, String sql, DWQueryInfo queryInfo, LinkedList<Object> joinParameters, String sqlWithNoWhereOrGroupClause) {
        List<DWQueryJoin> joins = queryInfo.getJoin();
        if (joins.size() == 0) {
            return sql;
        }
        CCJSqlParserManager parserManager = new CCJSqlParserManager();
        Statement statement = null;
        try {
            statement = parserManager.parse((Reader)new StringReader(sql));
        }
        catch (JSQLParserException e) {
            throw new ExecuteException(e);
        }
        Select selectStatement = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)selectStatement.getSelectBody();
        String fromTableName = queryInfo.getTableName();
        SimpleNode node = plainSelect.getASTNode();
        this.setTable(node, fromTableName, null);
        ArrayList<Join> joinList = plainSelect.getJoins();
        if (joinList == null) {
            joinList = new ArrayList<Join>();
        }
        ArrayList allSelectJoinTableFields = new ArrayList();
        HashSet<String> joinTableNameSet = new HashSet<String>();
        for (int i = 0; i < joins.size(); ++i) {
            DWQueryJoin queryJoin = joins.get(i);
            if (!queryJoin.hasJoin()) continue;
            if (queryJoin instanceof DWSubQueryJoin) {
                DWSubQueryJoin subQueryJoin = (DWSubQueryJoin)queryJoin;
                DWSqlInfo subQuerySqlInfo = this.parseSubQuery(option, subQueryJoin.getSubQueryInfo());
                String sqlWithSubQueryJoin = sqlWithNoWhereOrGroupClause + " " + queryJoin.getRelation().getValue() + " " + subQuerySqlInfo.getSql();
                joinParameters.addAll(subQuerySqlInfo.getParametersAsList());
                DWSqlInfo joinConditionSqlInfo = this.parse(option, subQueryJoin.getJoinCondition());
                joinParameters.addAll(joinConditionSqlInfo.getParametersAsList());
                sqlWithSubQueryJoin = sqlWithSubQueryJoin + " on " + joinConditionSqlInfo.getSql();
                try {
                    Statement withSubQueryStatement = parserManager.parse((Reader)new StringReader(sqlWithSubQueryJoin));
                    Select withSubQuerySelectStatement = (Select)withSubQueryStatement;
                    PlainSelect withSubQueryJoinPlainSelect = (PlainSelect)withSubQuerySelectStatement.getSelectBody();
                    joinList.add((Join)withSubQueryJoinPlainSelect.getJoins().get(0));
                    continue;
                }
                catch (JSQLParserException e) {
                    throw new ExecuteException(e);
                }
            }
            DWQueryJoinRelation relation = queryJoin.getRelation();
            String joinTableName = queryJoin.getJoinTableName();
            String joinTableNameAlias = queryJoin.getJoinTableAlias();
            Set<String> selectJoinTableFields = queryInfo.getJoinTableSelectField(joinTableName);
            if (selectJoinTableFields.size() != 0) {
                Statement tempStatement = null;
                try {
                    tempStatement = StringUtils.isNotBlank((CharSequence)joinTableNameAlias) ? parserManager.parse((Reader)new StringReader("SELECT " + String.join((CharSequence)", ", joinTableNameAlias + "." + String.valueOf(selectJoinTableFields)))) : parserManager.parse((Reader)new StringReader("SELECT " + String.join((CharSequence)", ", selectJoinTableFields)));
                }
                catch (JSQLParserException e) {
                    throw new ExecuteException(e);
                }
                Select tempSelectStatement = (Select)tempStatement;
                PlainSelect tempPlainSelect = (PlainSelect)tempSelectStatement.getSelectBody();
                SimpleNode tempNode = tempPlainSelect.getASTNode();
                this.setTable(tempNode, joinTableName, joinTableNameAlias);
                if (!joinTableNameSet.contains(joinTableName)) {
                    List selectItems = tempPlainSelect.getSelectItems();
                    allSelectJoinTableFields.addAll(selectItems);
                    joinTableNameSet.add(joinTableName);
                }
            }
            Join join = new Join();
            Table joinTable = this.getTable(joinTableName, joinTableNameAlias);
            join.setRightItem((FromItem)joinTable);
            switch (relation) {
                case Join: {
                    break;
                }
                case InnerJoin: {
                    join.setInner(true);
                    break;
                }
                case LeftJoin: {
                    join.setLeft(true);
                    break;
                }
                case RightJoin: {
                    join.setRight(true);
                    break;
                }
                case FullJoin: {
                    join.setFull(true);
                }
            }
            List<DWOn> ons = queryJoin.getOn();
            int onSize = ons.size();
            Expression expression = this.praseOn(fromTableName, queryJoin, ons, onSize, joinParameters);
            join.setOnExpression(expression);
            this.dwsqlFilterChain.doFilterOthers(join, option);
            joinList.add(join);
        }
        plainSelect.setJoins(joinList);
        for (SelectItem selectJoinTableField : allSelectJoinTableFields) {
            plainSelect.addSelectItems(new SelectItem[]{selectJoinTableField});
        }
        return plainSelect.toString();
    }

    private void setTable(SimpleNode node, String fromTableName, String alias) {
        int numChildren;
        Column column;
        Object value = node.jjtGetValue();
        if (value instanceof Column && (column = (Column)value).getTable() == null) {
            Table fromTable = this.getTable(fromTableName, alias);
            column.setTable(fromTable);
        }
        if ((numChildren = node.jjtGetNumChildren()) == 0) {
            return;
        }
        for (int i = 0; i < numChildren; ++i) {
            SimpleNode childNode = (SimpleNode)node.jjtGetChild(i);
            this.setTable(childNode, fromTableName, alias);
        }
    }

    private Expression praseOn(String fromTableName, DWQueryJoin queryJoin, List<DWOn> ons, int onSize, LinkedList<Object> joinParameters) {
        DWOn on = ons.get(onSize - 1);
        if (on instanceof DWOnJoinTableCondition) {
            String joinTableName = queryJoin.getJoinTableName();
            ((DWOnJoinTableCondition)on).setJoinTableName(joinTableName);
        } else if (on instanceof DWOnFromTableCondition) {
            ((DWOnFromTableCondition)on).setFromTableName(fromTableName);
        }
        Expression expression = this.getExpression(queryJoin, on, joinParameters);
        if (onSize == 1) {
            return expression;
        }
        AndExpression andExpression = new AndExpression(null, expression);
        Expression innerExpression = this.praseOn(fromTableName, queryJoin, ons, --onSize, joinParameters);
        andExpression.setLeftExpression(innerExpression);
        return andExpression;
    }

    private Expression praseJoinOnColumn(BinaryExpression expression, DWQueryJoinOnColumn queryJoin, DWOnColumn onColumn) {
        Object[] relationTableFieldArray;
        Object[] joinTableFieldArray;
        Object joinTableName = queryJoin.getJoinTableName();
        String joinTableAlias = queryJoin.getJoinTableAlias();
        Object relationTableName = queryJoin.getRelationTableName();
        String relationTableAlias = queryJoin.getRelationTableAlias();
        Object joinTableField = onColumn.getJoinTableField();
        Object relationTableField = onColumn.getRelationTableField();
        String regEx = "^\\w*\\.\\w*[A-Za-z0-9]$";
        if (StringUtils.isNotBlank((CharSequence)joinTableField) && this.verifyRegEx(regEx, (String)joinTableField) && ArrayUtils.isNotEmpty((Object[])(joinTableFieldArray = StringUtils.split((String)joinTableField, (String)"."))) && joinTableFieldArray.length >= 2) {
            joinTableAlias = null;
            joinTableName = joinTableFieldArray[joinTableFieldArray.length - 2];
            joinTableField = joinTableFieldArray[joinTableFieldArray.length - 1];
        }
        if (StringUtils.isNotBlank((CharSequence)relationTableField) && this.verifyRegEx(regEx, (String)relationTableField) && ArrayUtils.isNotEmpty((Object[])(relationTableFieldArray = StringUtils.split((String)relationTableField, (String)"."))) && relationTableFieldArray.length >= 2) {
            relationTableAlias = null;
            relationTableName = relationTableFieldArray[relationTableFieldArray.length - 2];
            relationTableField = relationTableFieldArray[relationTableFieldArray.length - 1];
        }
        Table joinTable = this.getTable((String)joinTableName, joinTableAlias);
        Column mainColumn = new Column(joinTable, (String)joinTableField);
        Table relationTable = this.getTable((String)relationTableName, relationTableAlias);
        Column joinColumn = new Column(relationTable, (String)relationTableField);
        expression.setLeftExpression((Expression)mainColumn);
        expression.setRightExpression((Expression)joinColumn);
        return expression;
    }

    private Expression praseJoinOnCondition(BinaryExpression expression, DWOnCondition onCondition) {
        String tableName = onCondition.getConditionTableName();
        String alias = onCondition.getConditionTableAlias();
        String fieldName = onCondition.getConditionFieldName();
        Table conditionTable = this.getTable(tableName, alias);
        Column column = new Column(conditionTable, fieldName);
        JdbcParameter jdbcParameter = new JdbcParameter();
        expression.setLeftExpression((Expression)column);
        expression.setRightExpression((Expression)jdbcParameter);
        return expression;
    }

    private Expression getExpression(DWQueryJoin queryJoin, DWOn on, LinkedList<Object> joinParameters) {
        Object[] values;
        DWQueryValueOperator operator = on.getOperator();
        EqualsTo expression = null;
        switch (operator) {
            case EQUAL: 
            case Equals: {
                expression = new EqualsTo();
                break;
            }
            case GreaterThan: {
                expression = new GreaterThan();
                break;
            }
            case GreaterThanOrEqualTo: {
                expression = new GreaterThanEquals();
                break;
            }
            case LessThan: {
                expression = new MinorThan();
                break;
            }
            case LessThanOrEqualTo: {
                expression = new MinorThanEquals();
                break;
            }
            case NotEquals: {
                expression = new NotEqualsTo();
                break;
            }
            case BETWEEN: 
            case Between: {
                int betweenValuesLength;
                if (on instanceof DWOnColumn) {
                    throw new UnsupportedOperationException();
                }
                expression = new Between();
                DWOnCondition betweenOnCondition = (DWOnCondition)on;
                Object[] betweenValues = betweenOnCondition.getValues();
                for (int i = betweenValuesLength = betweenValues.length; i != 0; --i) {
                    joinParameters.addFirst(betweenValues[i - 1]);
                }
                String betweenConditionTableName = betweenOnCondition.getConditionTableName();
                String betweenConditionTableAlias = betweenOnCondition.getConditionTableAlias();
                String betweenConditionFieldName = betweenOnCondition.getConditionFieldName();
                Table betweenConditionTable = this.getTable(betweenConditionTableName, betweenConditionTableAlias);
                Column betweenColumn = new Column(betweenConditionTable, betweenConditionFieldName);
                JdbcParameter betweenStartJdbcParameter = new JdbcParameter();
                JdbcParameter betweenEndJdbcParameter = new JdbcParameter();
                ((Between)expression).setLeftExpression((Expression)betweenColumn);
                ((Between)expression).setBetweenExpressionStart((Expression)betweenStartJdbcParameter);
                ((Between)expression).setBetweenExpressionEnd((Expression)betweenEndJdbcParameter);
                return expression;
            }
            case IN: 
            case In: 
            case NOTIN: 
            case NotIn: {
                if (on instanceof DWOnColumn) {
                    throw new UnsupportedOperationException();
                }
                expression = new InExpression();
                if (operator.equals((Object)DWQueryValueOperator.NOTIN) || operator.equals((Object)DWQueryValueOperator.NotIn)) {
                    ((InExpression)expression).setNot(true);
                }
                DWOnCondition inOnCondition = (DWOnCondition)on;
                Object[] inValues = inOnCondition.getValues();
                int inValuesLength = inValues.length;
                ArrayList<JdbcParameter> list = new ArrayList<JdbcParameter>();
                for (int i = inValuesLength; i != 0; --i) {
                    joinParameters.addFirst(inValues[i - 1]);
                    JdbcParameter jdbcParameter = new JdbcParameter();
                    list.add(jdbcParameter);
                }
                ExpressionList expressionList = new ExpressionList(list);
                String inConditionTableName = inOnCondition.getConditionTableName();
                String inConditionTableAlias = inOnCondition.getConditionTableAlias();
                String inConditionFieldName = inOnCondition.getConditionFieldName();
                Table inConditionTable = this.getTable(inConditionTableName, inConditionTableAlias);
                Column inColumn = new Column(inConditionTable, inConditionFieldName);
                ((InExpression)expression).setLeftExpression((Expression)inColumn);
                ((InExpression)expression).setRightItemsList((ItemsList)expressionList);
                return expression;
            }
            case LIKE: 
            case Like: 
            case NotLike: {
                if (on instanceof DWOnColumn) {
                    throw new UnsupportedOperationException();
                }
                expression = new LikeExpression();
                if (operator != DWQueryValueOperator.NotLike) break;
                ((LikeExpression)expression).setNot(true);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (on instanceof DWOnColumn) {
            return this.praseJoinOnColumn((BinaryExpression)expression, (DWQueryJoinOnColumn)queryJoin, (DWOnColumn)on);
        }
        DWOnCondition onCondition = (DWOnCondition)on;
        for (Object value : values = onCondition.getValues()) {
            joinParameters.addFirst(value);
        }
        return this.praseJoinOnCondition((BinaryExpression)expression, onCondition);
    }

    private Table getTable(String tableName, String alias) {
        Table table = new Table(tableName);
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            Alias tableAlias = new Alias(alias);
            table.setAlias(tableAlias);
        }
        return table;
    }

    private boolean chooseDefaultValueSetting(boolean globalSetting, String metadataSetting, Object customSetting) {
        if (customSetting != null) {
            return Boolean.valueOf(customSetting.toString());
        }
        if (metadataSetting != null) {
            return "y".equals(metadataSetting.trim().toLowerCase());
        }
        return globalSetting;
    }

    private boolean verifyRegEx(String regEx, String inspectedStr) {
        Pattern r = Pattern.compile(regEx);
        Matcher m = r.matcher(inspectedStr);
        return m.matches();
    }

    protected abstract String custFieldSqlForEqual(String var1);

    protected abstract String custFieldSqlForIn(String var1, Object var2);

    private class DWDataRowSqlInfoComparator
    implements Comparator<DWDataRowSqlInfo> {
        private Map<String, Integer> weightInfo = new HashMap<String, Integer>();
        private String orderType = null;

        private DWDataRowSqlInfoComparator(DWCommonSQLDialect dWCommonSQLDialect, DWDataSetSqlInfo datasetSqlInfo, DWDataSetOperationOption option) {
            if (this.orderType == null) {
                this.orderType = "";
            }
            this.orderType = option.getSqlOrderTypeOfExecution();
            this.analyze(datasetSqlInfo);
        }

        private boolean allMatched(Collection<String> targetJoinKeys, Collection<String> targetPrimaryKeys) {
            return targetPrimaryKeys.stream().allMatch(pk -> targetJoinKeys.contains(pk));
        }

        private int getAvailableWeight(int baseWeight, boolean higher) {
            ArrayList<Integer> sortedWeightInfo = new ArrayList<Integer>(this.weightInfo.values());
            Collections.sort(sortedWeightInfo);
            Integer maxWeight = null;
            Integer previousWeight = null;
            Iterator iterator = sortedWeightInfo.iterator();
            while (iterator.hasNext()) {
                Integer weight;
                previousWeight = weight = (Integer)iterator.next();
                if (baseWeight >= weight) continue;
                maxWeight = weight;
                break;
            }
            if (maxWeight == null) {
                maxWeight = (Integer)sortedWeightInfo.get(sortedWeightInfo.size() - 1);
                return maxWeight * 2;
            }
            return previousWeight + (maxWeight - previousWeight) / 2;
        }

        private void updateWeightInfo(DWRdbmsMetadata primaryMetadata, DWRdbmsRelationshipAttribute ra) {
            String primaryTableName = primaryMetadata.getName();
            String targetTableName = ra.getDetailTableName();
            DWRdbmsMetadata targetMetadata = (DWRdbmsMetadata)DWMetadataContainer.get(targetTableName, DWRdbmsMetadata.class);
            int baseWeight = 1000;
            boolean isOneToMany = ra.isOneToMany();
            boolean isOneToOne = ra.isOneToOne();
            Integer primaryWeight = null;
            Integer targetWeight = null;
            primaryWeight = this.weightInfo.get(primaryTableName);
            targetWeight = this.weightInfo.get(targetTableName);
            if (isOneToMany) {
                if (primaryWeight == null) {
                    primaryWeight = baseWeight;
                }
                if (targetWeight == null) {
                    targetWeight = primaryWeight / 2;
                } else if (targetWeight >= primaryWeight) {
                    primaryWeight = this.getAvailableWeight(targetWeight, true);
                }
                this.weightInfo.put(primaryTableName, primaryWeight);
                this.weightInfo.put(targetTableName, targetWeight);
            } else if (isOneToOne) {
                isOneToOne = true;
                if (targetWeight == null) {
                    targetWeight = baseWeight;
                }
                if (primaryWeight == null) {
                    primaryWeight = targetWeight / 2;
                } else if (primaryWeight >= targetWeight) {
                    targetWeight = this.getAvailableWeight(primaryWeight, true);
                }
                this.weightInfo.put(primaryTableName, primaryWeight);
                this.weightInfo.put(targetTableName, targetWeight);
            }
        }

        private void analyze(DWDataSetSqlInfo datasetSqlInfo) {
            ArrayList<DWRdbmsMetadata> metadatas = new ArrayList<DWRdbmsMetadata>();
            for (DWDataRowSqlInfo sqlInfo : datasetSqlInfo) {
                DWRdbmsMetadata metadata = (DWRdbmsMetadata)DWMetadataContainer.get(sqlInfo.getRow().getDataTable().getName(), DWRdbmsMetadata.class);
                if (metadatas.contains(metadata)) continue;
                metadatas.add(metadata);
            }
            metadatas.stream().forEach(m -> {
                Collection relations = m.getAttributes(DWRdbmsRelationshipAttribute.class);
                for (DWRdbmsRelationshipAttribute ra : relations) {
                    this.updateWeightInfo((DWRdbmsMetadata)m, ra);
                }
            });
        }

        @Override
        public int compare(DWDataRowSqlInfo sqlInfo1, DWDataRowSqlInfo sqlInfo2) {
            DWDataRow row1 = sqlInfo1.getRow();
            DWDataRow row2 = sqlInfo2.getRow();
            String row1State = DWDataRowState.getRowState(row1);
            String row2State = DWDataRowState.getRowState(row2);
            String highPriorityState = DWSQLOptionsBuilder.SQL_ORDER_TYPE_DELETE_HIGH_PRIORITY.equalsIgnoreCase(this.orderType) ? "D" : "C";
            if (highPriorityState.equals(row1State)) {
                if (!highPriorityState.equals(row2State)) {
                    return -1;
                }
            } else if (highPriorityState.equals(row2State)) {
                return 1;
            }
            if ("C".equals(row1State) && "C".equals(row2State) && !row1.getDataTable().getName().equals(row2.getDataTable().getName())) {
                Integer row1Weight = this.weightInfo.get(row1.getDataTable().getName());
                Integer row2Weight = this.weightInfo.get(row2.getDataTable().getName());
                if (row1Weight == null) {
                    row1Weight = 0;
                }
                if (row2Weight == null) {
                    row2Weight = 0;
                }
                return row1Weight > row2Weight ? -1 : (row1Weight < row2Weight ? 1 : 0);
            }
            if ("D".equals(row1State) && "D".equals(row2State) && !row1.getDataTable().getName().equals(row2.getDataTable().getName())) {
                Integer row1Weight = this.weightInfo.get(row1.getDataTable().getName());
                Integer row2Weight = this.weightInfo.get(row2.getDataTable().getName());
                if (row1Weight == null) {
                    row1Weight = 0;
                }
                if (row2Weight == null) {
                    row2Weight = 0;
                }
                return row1Weight > row2Weight ? 1 : (row1Weight < row2Weight ? -1 : 0);
            }
            return 0;
        }
    }

    public class CustomStringList
    extends ArrayList<String> {
        @Override
        public boolean contains(Object o) {
            String paramStr = (String)o;
            for (String s : this) {
                if (!paramStr.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }
    }
}

