/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.dao;

import com.digiwin.app.dao.DWOn;
import com.digiwin.app.dao.DWOnColumn;
import com.digiwin.app.dao.DWOnCondition;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryGroupBy;
import com.digiwin.app.dao.DWQueryJoin;
import com.digiwin.app.dao.DWQueryJoinOnColumn;
import com.digiwin.app.dao.DWQueryJoinOnCondition;
import com.digiwin.app.dao.DWQueryJoinRelation;
import com.digiwin.app.dao.DWQueryJoinTable;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSubQueryInfo;
import com.digiwin.app.dao.DWUnionInfo;
import com.digiwin.app.dao.DWUnionOperator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DWQueryInfo
implements Serializable {
    private String tableName;
    private DWQueryCondition condition = new DWQueryCondition();
    private DWQueryCondition fixedCondition = new DWQueryCondition();
    private List<DWQueryOrderby> orderfields = new ArrayList<DWQueryOrderby>();
    private List<DWQueryJoin> joins = new LinkedList<DWQueryJoin>();
    private Map<String, Set<String>> joinTableSelectFields = new HashMap<String, Set<String>>();
    private DWQueryGroupBy groupBy;
    private boolean distinct = false;
    private List<String> selectFields;
    private boolean selectAll = false;
    private List<DWUnionInfo> unions = new ArrayList<DWUnionInfo>();
    private DWSubQueryInfo fromInfo;
    private List<Object> selectObject;

    public DWQueryInfo setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public DWQueryInfo() {
    }

    public DWQueryInfo(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.condition.setTableName(this.tableName);
        this.tableName = tableName;
    }

    public DWQueryCondition getCondition() {
        return this.condition;
    }

    public DWQueryInfo setCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        condition.setTableName(this.tableName);
        this.condition = condition;
        return this;
    }

    public DWQueryCondition getFixedCondition() {
        return this.fixedCondition;
    }

    public DWQueryInfo setFixedCondition(DWQueryCondition condition) {
        if (condition == null) {
            condition = new DWQueryCondition();
        }
        this.fixedCondition = condition;
        return this;
    }

    public DWQueryInfo toOR() {
        this.condition.ORJoin();
        return this;
    }

    public List<DWQueryOrderby> getOrderfields() {
        return this.orderfields;
    }

    public DWQueryInfo addFieldInfo(String name, DWQueryValueOperator operator, Object ... values) {
        this.condition.addFieldInfo(name, operator, values);
        return this;
    }

    public DWQueryInfo addEqualInfo(String name, Object value) {
        this.condition.addEqualInfo(name, value);
        return this;
    }

    public DWQueryInfo addBetweenInfo(String name, Object value1, Object value2) {
        this.condition.addBetweenInfo(name, value1, value2);
        return this;
    }

    @Deprecated
    public List<String> getSelectFields() {
        return this.selectFields;
    }

    @Deprecated
    public void setSelectFields(List<String> selectFields) {
        this.setSelectFields(selectFields == null ? null : selectFields.toArray(new String[selectFields.size()]));
    }

    @Deprecated
    public DWQueryInfo setSelectFields(String ... fields) {
        List<Object> convertFields = new ArrayList();
        if (fields != null) {
            if (fields.length == 1) {
                String tempField_zero;
                int replaceField_zero_length;
                int originalField_zero_length = fields[0].length();
                int dotCount = originalField_zero_length - (replaceField_zero_length = (tempField_zero = fields[0].replace(",", "")).length());
                if (dotCount > 1) {
                    String[] fiedldSplits;
                    for (String fieldSplit : fiedldSplits = fields[0].split(",")) {
                        convertFields.add(fieldSplit.trim());
                    }
                } else {
                    convertFields = Arrays.asList(fields);
                }
            } else {
                convertFields = Arrays.asList(fields);
            }
        }
        this.selectObject = null;
        this.addInnerSelectFields(fields == null ? null : convertFields.toArray());
        this.selectFields = fields == null ? null : convertFields;
        return this;
    }

    @Deprecated
    public DWQueryInfo removeSelectFields(String field) {
        this.selectFields.remove(field);
        return this;
    }

    public void setOrderfields(List<DWQueryOrderby> orderfields) {
        this.orderfields = orderfields;
    }

    public DWQueryInfo addOrderBy(String name) {
        return this.addOrderBy(name, true);
    }

    public DWQueryInfo addOrderBy(String name, boolean ascending) {
        DWQueryOrderby field = new DWQueryOrderby(name);
        if (ascending) {
            field.setOrderby(DWQueryOrderby.SORT_ASCENDING);
        } else {
            field.setOrderby(DWQueryOrderby.SORT_DESCENDING);
        }
        this.orderfields.add(field);
        return this;
    }

    public List<DWQueryOrderby> addSuffixOrderby(String name, String orderby) {
        this.orderfields.add(new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public List<DWQueryOrderby> addPrefixOrderby(String name, String orderby) {
        this.orderfields.add(0, new DWQueryOrderby(name, orderby));
        return this.orderfields;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public DWQueryInfo setJoin(DWQueryJoin queryJoin) {
        this.joins.add(queryJoin);
        return this;
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String relationTableName, DWOnColumn ... ons) {
        return this.setJoinOnColumn(relation, new DWQueryJoinTable(joinTableName), new DWQueryJoinTable(relationTableName), ons);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, DWOnColumn ... ons) {
        return this.setJoinOnColumn(relation, new DWQueryJoinTable(joinTableName), ons);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String relationTableName, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        return this.setJoinOnColumn(relation, new DWQueryJoinTable(joinTableName), new DWQueryJoinTable(relationTableName), joinTableField, operator, relationTableField);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, String joinTableName, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        return this.setJoinOnColumn(relation, new DWQueryJoinTable(joinTableName), joinTableField, operator, relationTableField);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, String joinTableName, DWOnCondition ... ons) {
        return this.setJoinOnCondition(relation, new DWQueryJoinTable(joinTableName), ons);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, String joinTableName, String conditionTableName, String conditionFieldName, DWQueryValueOperator operator, Object ... values) {
        return this.setJoinOnCondition(relation, new DWQueryJoinTable(joinTableName), conditionTableName, null, conditionFieldName, operator, values);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWQueryJoinTable relationTable, DWOnColumn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, relationTable, ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWOnColumn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, new DWQueryJoinTable(this.tableName), ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWQueryJoinTable relationTable, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        DWOnColumn on = new DWOnColumn(joinTableField, operator, relationTableField);
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, relationTable, on);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnColumn(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, String joinTableField, DWQueryValueOperator operator, String relationTableField) {
        DWOnColumn on = new DWOnColumn(joinTableField, operator, relationTableField);
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, new DWQueryJoinTable(this.tableName), on);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWOnCondition ... ons) {
        DWQueryJoinOnCondition queryJoin = new DWQueryJoinOnCondition(relation, joinTable, ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnCondition(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, String conditionTableName, String conditionTableAlias, String conditionFieldName, DWQueryValueOperator operator, Object ... values) {
        DWOnCondition on = new DWOnCondition(conditionTableName, conditionTableAlias, conditionFieldName, operator, values);
        DWQueryJoinOnCondition queryJoin = new DWQueryJoinOnCondition(relation, joinTable, on);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnMultipleColumnAndCondition(DWQueryJoinRelation relation, String joinTableName, DWOn ... ons) {
        return this.setJoinOnMultipleColumnAndCondition(relation, new DWQueryJoinTable(joinTableName), ons);
    }

    public DWQueryInfo setJoinOnMultipleColumnAndCondition(DWQueryJoinRelation relation, String joinTableName, String relationTableName, DWOn ... ons) {
        return this.setJoinOnMultipleColumnAndCondition(relation, new DWQueryJoinTable(joinTableName), new DWQueryJoinTable(relationTableName), ons);
    }

    public DWQueryInfo setJoinOnMultipleColumnAndCondition(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWOn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, new DWQueryJoinTable(this.tableName), ons);
        return this.setJoin(queryJoin);
    }

    public DWQueryInfo setJoinOnMultipleColumnAndCondition(DWQueryJoinRelation relation, DWQueryJoinTable joinTable, DWQueryJoinTable relationTable, DWOn ... ons) {
        DWQueryJoinOnColumn queryJoin = new DWQueryJoinOnColumn(relation, joinTable, relationTable, ons);
        return this.setJoin(queryJoin);
    }

    public Set<String> getJoinTableSelectField(String joinTableName) {
        Set set = this.joinTableSelectFields.getOrDefault(joinTableName, new HashSet());
        return set;
    }

    public DWQueryInfo addJoinTableSelectField(String joinTableName, String ... selectFields) {
        Set set = this.joinTableSelectFields.getOrDefault(joinTableName, new HashSet());
        for (String selectField : selectFields) {
            set.add(selectField);
        }
        this.joinTableSelectFields.put(joinTableName, set);
        return this;
    }

    public List<DWQueryJoin> getJoin() {
        return this.joins;
    }

    public void setJoin(List<DWQueryJoin> joins) {
        this.joins = joins;
    }

    public DWQueryGroupBy addGroupFields(String ... fields) {
        if (this.groupBy == null) {
            this.groupBy = new DWQueryGroupBy(fields);
        } else {
            this.groupBy.addFields(fields);
        }
        return this.groupBy;
    }

    public DWQueryGroupBy getGroupBy() {
        return this.groupBy;
    }

    public DWQueryInfo addUnion(DWQueryInfo queryInfo, DWUnionOperator operator) {
        this.unions.add(new DWUnionInfo(queryInfo, operator));
        return this;
    }

    public List<DWUnionInfo> getUnions() {
        return this.unions;
    }

    public void setUnion(List<DWUnionInfo> unions) {
        this.unions = unions;
    }

    public DWQueryInfo from(DWSubQueryInfo fromInfo) {
        this.fromInfo = fromInfo;
        return this;
    }

    public DWSubQueryInfo getFromInfo() {
        return this.fromInfo;
    }

    public DWQueryInfo addSelectField(DWSubQueryInfo ... subQueryInfos) {
        this.addInnerSelectFields(subQueryInfos);
        return this;
    }

    public DWQueryInfo addSelectField(String ... fields) {
        this.addInnerSelectFields(fields);
        return this;
    }

    public List<Object> getSelectObjects() {
        if (this.selectObject == null) {
            this.selectObject = new ArrayList<Object>();
        }
        if (this.selectObject.size() == 0 && this.selectFields != null && this.selectFields.size() > 0) {
            this.selectObject.addAll(this.selectFields);
        }
        return this.selectObject;
    }

    private void addInnerSelectFields(Object ... fields) {
        if (this.selectObject == null) {
            this.selectObject = new ArrayList<Object>();
        }
        if (fields == null) {
            return;
        }
        this.selectObject.addAll(Arrays.asList(fields));
    }

    public <T extends DWQueryInfo> T get() {
        return (T)this;
    }
}

