/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.metadata;

import com.digiwin.app.metadata.DWMetadata;
import com.digiwin.app.metadata.exceptions.DWMetadataTypeNotMatchedException;
import com.digiwin.app.metadata.loader.DWMetadataLoaderManager;
import org.springframework.util.StringUtils;

public interface DWMetadataRepository {
    public static final String DW_METADATA_REPOSITORY_NAME = "dw-metadataRepository";
    public static final String DW_QUERY_RUNNER_NAME = "dw-queryRunner";
    public static final Integer DEFAULT_EXPIRE_TIME = 12;
    public static final Integer DEFAULT_INIT_CACHE_SIZE = 500;
    public static final Integer DEFAULT_MAX_CACHE_SIZE = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    default public <T extends DWMetadata<?>> T get(String name, Class<? extends DWMetadata<?>> metadataType) {
        if (!StringUtils.hasText((String)name)) {
            throw new IllegalArgumentException("'name' of DWMetadata is null or empty!");
        }
        String cacheKey = this.buildCacheKey(name);
        DWMetadata<?> metadata = null;
        if (!this.doHas(cacheKey)) {
            Class<DWMetadataRepository> clazz = DWMetadataRepository.class;
            // MONITORENTER : com.digiwin.app.metadata.DWMetadataRepository.class
            if (!this.doHas(cacheKey)) {
                metadata = DWMetadataLoaderManager.load(metadataType, name);
                this.doAdd(cacheKey, metadata);
            }
            // MONITOREXIT : clazz
        }
        if (metadataType.isInstance(metadata = (DWMetadata<?>)this.doGet(cacheKey))) return (T)metadata;
        throw new DWMetadataTypeNotMatchedException(name, metadataType.getName());
    }

    default public void remove(String name) {
        String cacheKey = this.buildCacheKey(name);
        this.doRemove(cacheKey);
    }

    public boolean doHas(String var1);

    public <T extends DWMetadata<?>> T doGet(String var1);

    public void doAdd(String var1, DWMetadata<?> var2);

    public void doRemove(String var1);

    default public String buildCacheKey(String name) {
        return name;
    }

    default public String parseUrl(String url) {
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        if (url.contains("//")) {
            url = url.substring(url.indexOf("//") + 2);
        }
        return url;
    }

    default public String getQueryRunnerName() {
        return DW_QUERY_RUNNER_NAME;
    }
}

