/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.metadata.DWMetadataContainer;
import com.digiwin.app.metadata.loader.DWRdbMetadataLoader;
import com.digiwin.app.metadata.loader.DWUIMetadataLoader;
import com.digiwin.app.metadata.rdbms.DWRdbmsMetadata;
import java.util.List;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"daoCurrentModuleNameProvider", "daoModulePropertiesProvider", "daoApplicationPropertiesProvider", "daoSpringContextProvider", "daoUpdateDataSource", "daoApplicationResourceBundleProvider", "daoApplicationClassLoaderProvider", "dw-spring-context-utils"})
@Configuration
public class DWMetadataAutoConfiguration {
    private static Log log = LogFactory.getLog(DWMetadataAutoConfiguration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DependsOn(value={"dw-queryRunner"})
    @Bean(name={"dw-rdbMetadataLoader"})
    @ConditionalOnBean(name={"dw-queryRunner"})
    public DWRdbMetadataLoader dwRdbMetadataLoader(Environment environment) {
        DWRdbMetadataLoader loader = new DWRdbMetadataLoader();
        String autoLoad = environment.getProperty("dap.dwdao.metadata.auto-load-on-star-up", "false");
        if (Boolean.parseBoolean(autoLoad)) {
            log.info((Object)"auto load dao metadata enabled!");
            StopWatch watch = StopWatch.createStarted();
            List tableNames = loader.getTableNames();
            try {
                for (String tableName : tableNames) {
                    DWMetadataContainer.get((String)tableName, DWRdbmsMetadata.class);
                    log.debug((Object)String.format("auto load table(name=%s) metadata...", tableName));
                }
            }
            catch (Exception e) {
                log.warn((Object)"DWMetadataAutoConfiguration auto load dwdao metadata failed!", (Throwable)e);
            }
            finally {
                watch.stop();
            }
            long spendingTime = watch.getTime();
            log.info((Object)String.format("auto load table metadata completed! total time(ms:%s)", spendingTime));
        }
        return loader;
    }

    @Bean(name={"dw-uiMetadataLoader"})
    public DWUIMetadataLoader dwUIMetadataLoader() {
        return new DWUIMetadataLoader();
    }
}

