/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.autoconfigure;

import com.digiwin.app.autoconfigure.DWDruidSpringAopConfiguration;
import com.digiwin.app.autoconfigure.DWDruidStatViewServletConfiguration;
import com.digiwin.app.autoconfigure.DWDruidWebStatFilterConfiguration;
import com.digiwin.app.autoconfigure.condition.DWDefaultDWDaoEnableCondition;
import com.digiwin.app.autoconfigure.context.DWDaoDynamicDataSourcePropertySource;
import com.digiwin.app.dao.security.AESUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.handler.IgnoreTopLevelConverterNotFoundBindHandler;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

@DependsOn(value={"daoUpdateDataSource", "daoModuleNameProvider", "daoSpringContextProvider", "daoConfigProvider", "daoResourceBundleProvider", "daoClassProvider", "dw-spring-context-utils"})
@Configuration
@Import(value={DWDruidSpringAopConfiguration.class, DWDruidStatViewServletConfiguration.class, DWDruidWebStatFilterConfiguration.class})
public class DWDaoDynamicDataSourceConfiguration {
    @Bean(name={"dw-dataSource"})
    @Conditional(value={DWDefaultDWDaoEnableCondition.class})
    @ConfigurationProperties(value="dap.dwdao.default.datasource")
    public DataSource defaultDWDaoDataSource(ApplicationContext context) {
        String dbPasswordEncryptionKey;
        String datasourceUrl = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url");
        if (StringUtils.isBlank((CharSequence)datasourceUrl)) {
            PropertySource propertySource;
            String datasourceUrlType = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url.type");
            String datasourceUrlHost = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url.host");
            String datasourceUrlPort = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url.port");
            String datasourceUrlDatabase = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url.database");
            String datasourceUrlArgs = context.getEnvironment().getProperty("dap.dwdao.default.datasource.url.args");
            StringBuilder datasourceUrlCombination = new StringBuilder();
            datasourceUrlCombination.append("jdbc:" + datasourceUrlType + "://" + datasourceUrlHost);
            if (!"".equals(datasourceUrlPort)) {
                datasourceUrlCombination.append(":" + datasourceUrlPort);
            }
            datasourceUrlCombination.append("/" + datasourceUrlDatabase);
            if (!"".equals(datasourceUrlArgs)) {
                datasourceUrlCombination.append("?" + datasourceUrlArgs);
            }
            if ((propertySource = ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().get("dap-application-propertysource")) instanceof PropertiesPropertySource) {
                PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
                ((Map)propertiesPropertySource.getSource()).put("dap.dwdao.default.datasource.url", datasourceUrlCombination.toString());
            }
            if (propertySource instanceof EnumerablePropertySource) {
                Properties datasourceUrlProperties = new Properties();
                datasourceUrlProperties.setProperty("dap.dwdao.default.datasource.url", datasourceUrlCombination.toString());
                DWDaoDynamicDataSourcePropertySource dwDaoDynamicDataSourcePropertySource = new DWDaoDynamicDataSourcePropertySource(datasourceUrlProperties);
                ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().addFirst((PropertySource)dwDaoDynamicDataSourcePropertySource);
            }
        }
        if ((dbPasswordEncryptionKey = context.getEnvironment().getProperty("dap.dwdao.default.datasource.password.encryption.key")) != null && !"".equals(dbPasswordEncryptionKey.trim())) {
            String dbPassword = context.getEnvironment().getProperty("dap.dwdao.default.datasource.password");
            dbPassword = AESUtil.decode((String)dbPassword, (String)dbPasswordEncryptionKey);
            HashMap<String, String> dbPasswordDecodeMap = new HashMap<String, String>();
            dbPasswordDecodeMap.put("dap.dwdao.default.datasource.password", dbPassword);
            MapPropertySource dapApplicationPropertysourceDecode = new MapPropertySource("dap-application-propertysource-dwdao-encode", dbPasswordDecodeMap);
            ((ConfigurableEnvironment)context.getEnvironment()).getPropertySources().addFirst((PropertySource)dapApplicationPropertysourceDecode);
        }
        Binder binder = Binder.get((Environment)context.getEnvironment());
        IgnoreTopLevelConverterNotFoundBindHandler handler = new IgnoreTopLevelConverterNotFoundBindHandler();
        ConfigurationPropertyName cfgPropertyName = ConfigurationPropertyName.of((CharSequence)"dap.dwdao.default.datasource");
        BindResult result = binder.bind(cfgPropertyName, Bindable.of(DataSourceProperties.class), (BindHandler)handler);
        DataSourceBuilder dataSourceBuilder = ((DataSourceProperties)result.get()).initializeDataSourceBuilder();
        return dataSourceBuilder.build();
    }
}

